/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.ai.goal.boids;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ldev/hybridlabs/aquatic/entity/ai/goal/boids/BoidGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "mob", "Lnet/minecraft/world/entity/Mob;", "separationInfluence", "", "separationRange", "alignmentInfluence", "cohesionInfluence", "<init>", "(Lnet/minecraft/world/entity/Mob;FFFF)V", "timeToFindNearbyEntities", "", "nearbyMobs", "", "maxSpeed", "canUse", "", "getMaxDelta", "", "tick", "", "random", "Lnet/minecraft/world/phys/Vec3;", "separation", "alignment", "cohesion", "Companion", "hybrid-aquatic-forge-1.20.1"})
public final class BoidGoal
extends Goal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Mob mob;
    private final float separationInfluence;
    private final float separationRange;
    private final float alignmentInfluence;
    private final float cohesionInfluence;
    private int timeToFindNearbyEntities;
    @NotNull
    private List<? extends Mob> nearbyMobs;
    private final float maxSpeed;

    public BoidGoal(@NotNull Mob mob, float separationInfluence, float separationRange, float alignmentInfluence, float cohesionInfluence) {
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        this.mob = mob;
        this.separationInfluence = separationInfluence;
        this.separationRange = separationRange;
        this.alignmentInfluence = alignmentInfluence;
        this.cohesionInfluence = cohesionInfluence;
        this.nearbyMobs = new ArrayList();
        this.maxSpeed = (float)this.mob.m_21133_(Attributes.f_22279_);
    }

    public boolean m_8036_() {
        this.timeToFindNearbyEntities += -1;
        if (this.timeToFindNearbyEntities <= 0) {
            this.timeToFindNearbyEntities = this.m_183277_(40);
            this.nearbyMobs = Companion.getNearbyEntitiesOfSameClass(this.mob);
        } else {
            this.nearbyMobs.removeIf(arg_0 -> BoidGoal.canUse$lambda$1(BoidGoal::canUse$lambda$0, arg_0));
        }
        return !this.nearbyMobs.isEmpty();
    }

    private final double getMaxDelta() {
        return (double)this.maxSpeed * 0.075;
    }

    public void m_8037_() {
        Vec3 boidVec = this.cohesion().m_82549_(this.alignment().m_82549_(this.separation().m_82549_(this.random())));
        if (boidVec.m_82553_() > this.getMaxDelta()) {
            boidVec = boidVec.m_82541_().m_82490_(this.getMaxDelta());
        }
        this.mob.m_246865_(boidVec);
        Vec3 target = this.mob.m_20182_().m_82549_(this.mob.m_20184_());
        this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(target.f_82479_, target.f_82480_ + (double)this.mob.m_20192_(), target.f_82481_));
    }

    @NotNull
    public final Vec3 random() {
        Vec3 velocity = this.mob.m_20184_();
        if (velocity.m_82553_() < (double)this.maxSpeed * 0.001) {
            double yaw = this.mob.m_217043_().m_188583_() * (double)40 - (double)20;
            double pitch = this.mob.m_217043_().m_188583_() * (double)2 - 1.0;
            Vec3 vec3 = Vec3.m_82498_((float)((float)pitch), (float)((float)yaw)).m_82490_(0.1);
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"scale(...)");
            return vec3;
        }
        Vec3 vec3 = this.mob.m_20156_().m_82490_(0.1);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"scale(...)");
        return vec3;
    }

    private final Vec3 separation() {
        Vec3 c = Vec3.f_82478_;
        for (Mob mob : this.nearbyMobs) {
            if (!(mob.m_20182_().m_82546_(this.mob.m_20182_()).m_82553_() < (double)this.separationRange)) continue;
            c = c.m_82546_(mob.m_20182_().m_82546_(this.mob.m_20182_()));
        }
        Vec3 vec3 = c.m_82490_((double)this.separationInfluence);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"scale(...)");
        return vec3;
    }

    private final Vec3 alignment() {
        Vec3 c = Vec3.f_82478_;
        for (Mob mob : this.nearbyMobs) {
            c = c.m_82549_(mob.m_20184_());
        }
        c = c.m_82490_((double)(1.0f / (float)this.nearbyMobs.size()));
        c = c.m_82546_(this.mob.m_20184_());
        Vec3 vec3 = c.m_82490_((double)this.alignmentInfluence);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"scale(...)");
        return vec3;
    }

    private final Vec3 cohesion() {
        Vec3 c = Vec3.f_82478_;
        for (Mob mob : this.nearbyMobs) {
            c = c.m_82549_(mob.m_20182_());
        }
        c = c.m_82490_((double)(1.0f / (float)this.nearbyMobs.size()));
        c = c.m_82546_(this.mob.m_20182_());
        Vec3 vec3 = c.m_82490_((double)this.cohesionInfluence);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"scale(...)");
        return vec3;
    }

    private static final boolean canUse$lambda$0(LivingEntity obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.m_21224_();
    }

    private static final boolean canUse$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Ldev/hybridlabs/aquatic/entity/ai/goal/boids/BoidGoal$Companion;", "", "<init>", "()V", "getNearbyEntitiesOfSameClass", "", "Lnet/minecraft/world/entity/Mob;", "mob", "hybrid-aquatic-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<? extends Mob> getNearbyEntitiesOfSameClass(@NotNull Mob mob) {
            Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
            Predicate<Mob> predicate = arg_0 -> Companion.getNearbyEntitiesOfSameClass$lambda$0(mob, arg_0);
            List list = mob.m_9236_().m_6443_(mob.getClass(), mob.m_20191_().m_82377_(4.0, 4.0, 4.0), predicate);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
            return list;
        }

        private static final boolean getNearbyEntitiesOfSameClass$lambda$0(Mob $mob, Mob other) {
            if (Intrinsics.areEqual((Object)other, (Object)$mob)) {
                return false;
            }
            if ($mob instanceof VariantHolder && other instanceof VariantHolder) {
                return Intrinsics.areEqual((Object)((VariantHolder)$mob).m_28554_(), (Object)((VariantHolder)other).m_28554_());
            }
            return Intrinsics.areEqual((Object)other.m_6095_(), (Object)$mob.m_6095_());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

