/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.fish;

import dev.hybridlabs.aquatic.entity.fish.HybridAquaticFishEntity;
import dev.hybridlabs.aquatic.tag.HybridAquaticEntityTags;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\u00020\u0001:\u0002-.B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\u0014\u001a\u00020\u000bH\u0014J\u0014\u0010\u0015\u001a\u00020\u000b2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\tJ\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u000bH\u0016J\b\u0010 \u001a\u00020\u000bH\u0002J\b\u0010!\u001a\u00020\u000bH\u0002J\b\u0010\"\u001a\u00020\u000bH\u0016J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016R\u001a\u0010\f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010\u00a8\u0006/"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/BlowfishEntity;", "Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticFishEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "getMaxSpawnClusterSize", "", "registerGoals", "", "inflateTicks", "getInflateTicks", "()I", "setInflateTicks", "(I)V", "deflateTicks", "getDeflateTicks", "setDeflateTicks", "defineSynchedData", "onSyncedDataUpdated", "key", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "getPuffState", "setPuffState", "state", "addAdditionalSaveData", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "tick", "handleInflation", "handleDeflation", "aiStep", "touch", "mob", "Lnet/minecraft/world/entity/Mob;", "playerTouch", "entity", "Lnet/minecraft/world/entity/player/Player;", "getDimensions", "Lnet/minecraft/world/entity/EntityDimensions;", "pose", "Lnet/minecraft/world/entity/Pose;", "InflateGoal", "Companion", "hybrid-aquatic-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nBlowfishEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlowfishEntity.kt\ndev/hybridlabs/aquatic/entity/fish/BlowfishEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1869#2,2:193\n*S KotlinDebug\n*F\n+ 1 BlowfishEntity.kt\ndev/hybridlabs/aquatic/entity/fish/BlowfishEntity\n*L\n113#1:193,2\n*E\n"})
public final class BlowfishEntity
extends HybridAquaticFishEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int inflateTicks;
    private int deflateTicks;
    @NotNull
    private static final EntityDataAccessor<Integer> PUFF_STATE;
    @NotNull
    private static final Predicate<LivingEntity> BLOW_UP_FILTER;
    @NotNull
    private static final TargetingConditions BLOW_UP_TARGET_PREDICATE;
    public static final int NOT_PUFFED = 0;
    public static final int SEMI_PUFFED = 1;
    public static final int FULLY_PUFFED = 2;

    public BlowfishEntity(@NotNull EntityType<? extends BlowfishEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Object[] objectArray = new TagKey[]{HybridAquaticEntityTags.INSTANCE.getMEDIUM_PREY(), HybridAquaticEntityTags.INSTANCE.getLARGE_PREY(), HybridAquaticEntityTags.INSTANCE.getSHARK()};
        super(entityType, world, CollectionsKt.listOf(HybridAquaticEntityTags.INSTANCE.getNONE()), CollectionsKt.listOf((Object[])objectArray));
    }

    public int m_5792_() {
        return 2;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new InflateGoal());
    }

    public final int getInflateTicks() {
        return this.inflateTicks;
    }

    public final void setInflateTicks(int n) {
        this.inflateTicks = n;
    }

    public final int getDeflateTicks() {
        return this.deflateTicks;
    }

    public final void setDeflateTicks(int n) {
        this.deflateTicks = n;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PUFF_STATE, (Object)0);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        super.m_7350_(key);
        if (Intrinsics.areEqual(key, PUFF_STATE)) {
            this.m_6210_();
        }
    }

    public final int getPuffState() {
        Object object = this.f_19804_.m_135370_(PUFF_STATE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    private final void setPuffState(int state) {
        this.f_19804_.m_135381_(PUFF_STATE, (Object)state);
        this.m_6210_();
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.m_7380_(nbt);
        nbt.m_128405_("PuffState", this.getPuffState());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.m_7378_(nbt);
        this.setPuffState(RangesKt.coerceAtMost((int)nbt.m_128451_("PuffState"), (int)2));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.hasSelfControl()) {
            if (this.inflateTicks > 0) {
                this.handleInflation();
            } else if (this.getPuffState() != 0) {
                this.handleDeflation();
            }
        }
    }

    private final void handleInflation() {
        if (this.getPuffState() == 0) {
            this.m_5496_(SoundEvents.f_12291_, this.m_6121_(), this.m_6100_());
            this.setPuffState(1);
        } else if (this.inflateTicks > 40 && this.getPuffState() == 1) {
            this.m_5496_(SoundEvents.f_12291_, this.m_6121_(), this.m_6100_());
            this.setPuffState(2);
        }
        int n = this.inflateTicks;
        this.inflateTicks = n + 1;
    }

    private final void handleDeflation() {
        if (this.deflateTicks > 60 && this.getPuffState() == 2) {
            this.m_5496_(SoundEvents.f_12290_, this.m_6121_(), this.m_6100_());
            this.setPuffState(1);
        } else if (this.deflateTicks > 100 && this.getPuffState() == 1) {
            this.m_5496_(SoundEvents.f_12290_, this.m_6121_(), this.m_6100_());
            this.setPuffState(0);
        }
        int n = this.deflateTicks;
        this.deflateTicks = n + 1;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && this.getPuffState() > 0) {
            List nearbyEntities = this.m_9236_().m_6443_(Mob.class, this.m_20191_().m_82400_(0.3), arg_0 -> BlowfishEntity.aiStep$lambda$1(arg_0 -> BlowfishEntity.aiStep$lambda$0(this, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)nearbyEntities);
            Iterable $this$forEach$iv = nearbyEntities;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Mob it = (Mob)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                this.touch(it);
            }
        }
    }

    private final void touch(Mob mob) {
        int i = this.getPuffState();
        if (mob.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)(1 + i))) {
            mob.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 60 * i, 0), (Entity)this);
            this.m_5496_(SoundEvents.f_12295_, 1.0f, 1.0f);
        }
    }

    public void m_6123_(@NotNull Player entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        int i = this.getPuffState();
        if (entity instanceof ServerPlayer && i > 0 && ((ServerPlayer)entity).m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)(1 + i))) {
            if (!this.m_20067_()) {
                ((ServerPlayer)entity).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132162_, 0.0f));
            }
            entity.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 60 * i, 0), (Entity)this);
        }
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        float scale = switch (this.getPuffState()) {
            case 0 -> 0.75f;
            case 1 -> 1.0f;
            case 2 -> 1.25f;
            default -> 1.0f;
        };
        EntityDimensions entityDimensions = super.m_6972_(pose).m_20388_(scale);
        Intrinsics.checkNotNullExpressionValue((Object)entityDimensions, (String)"scale(...)");
        return entityDimensions;
    }

    private static final boolean aiStep$lambda$0(BlowfishEntity this$0, Mob it) {
        return BLOW_UP_TARGET_PREDICATE.m_26885_((LivingEntity)this$0, (LivingEntity)it);
    }

    private static final boolean aiStep$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean BLOW_UP_FILTER$lambda$3(LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return entity instanceof Player && ((Player)entity).m_7500_() ? false : !Intrinsics.areEqual((Object)entity.m_6336_(), (Object)MobType.f_21644_);
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.m_135353_(BlowfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        PUFF_STATE = entityDataAccessor;
        BLOW_UP_FILTER = BlowfishEntity::BLOW_UP_FILTER$lambda$3;
        TargetingConditions targetingConditions = TargetingConditions.m_148353_().m_26893_().m_148355_().m_26888_(BLOW_UP_FILTER);
        Intrinsics.checkNotNullExpressionValue((Object)targetingConditions, (String)"selector(...)");
        BLOW_UP_TARGET_PREDICATE = targetingConditions;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/BlowfishEntity$Companion;", "", "<init>", "()V", "createMobAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "PUFF_STATE", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "BLOW_UP_FILTER", "Ljava/util/function/Predicate;", "Lnet/minecraft/world/entity/LivingEntity;", "BLOW_UP_TARGET_PREDICATE", "Lnet/minecraft/world/entity/ai/targeting/TargetingConditions;", "NOT_PUFFED", "SEMI_PUFFED", "FULLY_PUFFED", "hybrid-aquatic-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createMobAttributes() {
            AttributeSupplier.Builder builder = WaterAnimal.m_21183_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22277_, 4.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/BlowfishEntity$InflateGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "<init>", "(Ldev/hybridlabs/aquatic/entity/fish/BlowfishEntity;)V", "canUse", "", "start", "", "stop", "hybrid-aquatic-forge-1.20.1"})
    private final class InflateGoal
    extends Goal {
        public boolean m_8036_() {
            List nearbyEntities = BlowfishEntity.this.m_9236_().m_6443_(LivingEntity.class, BlowfishEntity.this.m_20191_().m_82400_(2.0), arg_0 -> InflateGoal.canUse$lambda$1(arg_0 -> InflateGoal.canUse$lambda$0(BlowfishEntity.this, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)nearbyEntities);
            return !((Collection)nearbyEntities).isEmpty();
        }

        public void m_8056_() {
            BlowfishEntity.this.setInflateTicks(1);
            BlowfishEntity.this.setDeflateTicks(0);
        }

        public void m_8041_() {
            BlowfishEntity.this.setInflateTicks(0);
        }

        private static final boolean canUse$lambda$0(BlowfishEntity this$0, LivingEntity it) {
            return BLOW_UP_TARGET_PREDICATE.m_26885_((LivingEntity)this$0, it);
        }

        private static final boolean canUse$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

