/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.fish;

import dev.hybridlabs.aquatic.entity.ai.goal.FishAttackGoal;
import dev.hybridlabs.aquatic.entity.cephalopod.HybridAquaticCephalopodEntity;
import dev.hybridlabs.aquatic.entity.mammal.HybridAquaticMammalEntity;
import dev.hybridlabs.aquatic.entity.shark.HybridAquaticSharkEntity;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 h2\u00020\u00012\u00020\u0002:\u0001hBO\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\t0\b\u0012\u0016\u0010\n\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0014J6\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0005\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020\u0014H\u0016J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0014H\u0016J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,H\u0014J\b\u0010-\u001a\u00020,H\u0002J\b\u0010.\u001a\u00020#H\u0016J\u0010\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u001fH\u0016J\u0010\u00106\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u001fH\u0016J\u0018\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0014J\u0010\u0010=\u001a\u00020#2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010D\u001a\u00020A2\u0006\u0010E\u001a\u00020FH\u0014J\b\u0010G\u001a\u00020AH\u0014J\u0018\u0010H\u001a\u00020\u00142\u0006\u0010E\u001a\u00020F2\u0006\u0010I\u001a\u00020#H\u0014J\b\u0010J\u001a\u00020,H\u0002J\b\u0010K\u001a\u00020\u0014H\u0014J\u0010\u0010L\u001a\u0002082\u0006\u0010M\u001a\u000208H\u0016J\u0010\u0010N\u001a\u00020#2\u0006\u0010O\u001a\u00020PH\u0016J\b\u0010\\\u001a\u00020#H\u0014J\b\u0010]\u001a\u00020,H\u0014J\b\u0010^\u001a\u00020,H\u0014J\u0010\u0010_\u001a\u00020\u00142\u0006\u0010`\u001a\u00020aH\u0016J\b\u0010b\u001a\u00020\u0011H\u0016J\u0010\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020\u0006H\u0014J\b\u0010f\u001a\u00020,H\u0016J\b\u0010g\u001a\u00020,H\u0016R$\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR$\u0010\n\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0014\u0010@\u001a\u00020AX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR$\u0010Q\u001a\u00020,2\u0006\u0010Q\u001a\u00020,8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR$\u0010V\u001a\u00020,2\u0006\u0010V\u001a\u00020,8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bW\u0010S\"\u0004\bX\u0010UR$\u0010Y\u001a\u00020,2\u0006\u0010Y\u001a\u00020,8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bZ\u0010S\"\u0004\b[\u0010U\u00a8\u0006i"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticFishEntity;", "Lnet/minecraft/world/entity/animal/WaterAnimal;", "Lsoftware/bernie/geckolib/animatable/GeoEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "prey", "", "Lnet/minecraft/tags/TagKey;", "predator", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;Ljava/util/List;Ljava/util/List;)V", "getPrey", "()Ljava/util/List;", "getPredator", "factory", "Lsoftware/bernie/geckolib/core/animatable/instance/AnimatableInstanceCache;", "kotlin.jvm.PlatformType", "registerGoals", "", "defineSynchedData", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnReason", "Lnet/minecraft/world/entity/MobSpawnType;", "entityData", "entityNbt", "Lnet/minecraft/nbt/CompoundTag;", "getMobType", "Lnet/minecraft/world/entity/MobType;", "canBreatheUnderwater", "", "isPushedByFluid", "tick", "travel", "travelVector", "Lnet/minecraft/world/phys/Vec3;", "aiStep", "handleAirSupply", "air", "", "getMaxMoistness", "shouldFlopOnLand", "addAdditionalSaveData", "nbt", "fromFishingNet", "getFromFishingNet", "()Z", "setFromFishingNet", "(Z)V", "readAdditionalSaveData", "getStandingEyeHeight", "", "pose", "Lnet/minecraft/world/entity/Pose;", "dimensions", "Lnet/minecraft/world/entity/EntityDimensions;", "removeWhenFarAway", "distanceSquared", "", "flopSound", "Lnet/minecraft/sounds/SoundEvent;", "getFlopSound", "()Lnet/minecraft/sounds/SoundEvent;", "getHurtSound", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "getDeathSound", "dropFromLootTable", "causedByPlayer", "getHandSwingDuration", "updateSwingTime", "getAttackAnim", "tickDelta", "doHurtTarget", "target", "Lnet/minecraft/world/entity/Entity;", "moistness", "getMoistness", "()I", "setMoistness", "(I)V", "size", "getSize", "setSize", "hunger", "getHunger", "setHunger", "hasSelfControl", "getMinSize", "getMaxSize", "registerControllers", "controllers", "Lsoftware/bernie/geckolib/core/animation/AnimatableManager$ControllerRegistrar;", "getAnimatableInstanceCache", "createNavigation", "Lnet/minecraft/world/entity/ai/navigation/PathNavigation;", "level", "getMaxHeadXRot", "getMaxHeadYRot", "Companion", "hybrid-aquatic-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nHybridAquaticFishEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HybridAquaticFishEntity.kt\ndev/hybridlabs/aquatic/entity/fish/HybridAquaticFishEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,385:1\n1761#2,3:386\n1761#2,3:389\n*S KotlinDebug\n*F\n+ 1 HybridAquaticFishEntity.kt\ndev/hybridlabs/aquatic/entity/fish/HybridAquaticFishEntity\n*L\n54#1:386,3\n56#1:389,3\n*E\n"})
public class HybridAquaticFishEntity
extends WaterAnimal
implements GeoEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<TagKey<EntityType<?>>> prey;
    @NotNull
    private final List<TagKey<EntityType<?>>> predator;
    private final AnimatableInstanceCache factory;
    private boolean fromFishingNet;
    @NotNull
    private final SoundEvent flopSound;
    @NotNull
    private static final EntityDataAccessor<Integer> MOISTNESS;
    @NotNull
    private static final EntityDataAccessor<Integer> FISH_SIZE;
    @NotNull
    private static final EntityDataAccessor<Integer> HUNGER;
    @NotNull
    private static final EntityDataAccessor<Boolean> ATTEMPT_ATTACK;
    @NotNull
    private static final RawAnimation FLOP_ANIMATION;
    public static final int MAX_HUNGER = 2400;
    @NotNull
    public static final String HUNGER_KEY = "Hunger";
    @NotNull
    public static final String MOISTNESS_KEY = "Moistness";
    @NotNull
    public static final String FISH_SIZE_KEY = "FishSize";

    public HybridAquaticFishEntity(@NotNull EntityType<? extends HybridAquaticFishEntity> entityType, @NotNull Level world, @NotNull List<TagKey<EntityType<?>>> prey, @NotNull List<TagKey<EntityType<?>>> predator) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(prey, (String)"prey");
        Intrinsics.checkNotNullParameter(predator, (String)"predator");
        super(entityType, world);
        this.prey = prey;
        this.predator = predator;
        this.factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)((GeoAnimatable)this));
        SoundEvent soundEvent = SoundEvents.f_12293_;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"PUFFER_FISH_FLOP");
        this.flopSound = soundEvent;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.f_21342_ = (MoveControl)new SmoothSwimmingMoveControl((Mob)this, 85, 5, 0.02f, 0.1f, false);
        this.f_21365_ = (LookControl)new SmoothSwimmingLookControl((Mob)this, 10);
        this.f_21344_ = (PathNavigation)new WaterBoundPathNavigation((Mob)this, world);
    }

    @NotNull
    public List<TagKey<EntityType<?>>> getPrey() {
        return this.prey;
    }

    @NotNull
    public List<TagKey<EntityType<?>>> getPredator() {
        return this.predator;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FishAttackGoal(this, 1.1, true));
        this.f_21345_.m_25352_(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 8.0f, 1.3, 1.5, arg_0 -> HybridAquaticFishEntity.registerGoals$lambda$1(this, arg_0)));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.3, 1.5));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, true, arg_0 -> HybridAquaticFishEntity.registerGoals$lambda$3(this, arg_0)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MOISTNESS, (Object)this.getMaxMoistness());
        this.f_19804_.m_135372_(FISH_SIZE, (Object)0);
        this.f_19804_.m_135372_(ATTEMPT_ATTACK, (Object)false);
        this.f_19804_.m_135372_(HUNGER, (Object)2400);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnReason, (String)"spawnReason");
        this.setSize(this.f_19796_.m_216332_(this.getMinSize(), this.getMaxSize()));
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @NotNull
    public MobType m_6336_() {
        MobType mobType = MobType.f_21644_;
        Intrinsics.checkNotNullExpressionValue((Object)mobType, (String)"WATER");
        return mobType;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_5842_()) {
            this.setMoistness(this.getMaxMoistness());
        } else {
            this.setMoistness(this.getMoistness() - 1);
            if (this.getMoistness() <= -20) {
                this.setMoistness(0);
                this.m_6469_(this.m_269291_().m_269483_(), 2.0f);
                this.m_146926_(0.0f);
                this.m_146922_(0.0f);
            }
        }
        if (this.getHunger() > 0) {
            this.setHunger(this.getHunger() - 1);
        }
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        Intrinsics.checkNotNullParameter((Object)travelVector, (String)"travelVector");
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(travelVector);
        }
    }

    public void m_8107_() {
        if (this.shouldFlopOnLand() && !this.m_20069_() && this.m_20096_() && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.m_6853_(false);
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
        this.m_21203_();
        super.m_8107_();
    }

    protected void m_6229_(int air) {
    }

    private final int getMaxMoistness() {
        return 600;
    }

    public boolean shouldFlopOnLand() {
        return true;
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.m_7380_(nbt);
        nbt.m_128405_(MOISTNESS_KEY, this.getMoistness());
        nbt.m_128405_(FISH_SIZE_KEY, this.getSize());
        nbt.m_128405_(HUNGER_KEY, this.getHunger());
        nbt.m_128379_("FromFishingNet", this.fromFishingNet);
    }

    public final boolean getFromFishingNet() {
        return this.fromFishingNet;
    }

    public final void setFromFishingNet(boolean bl) {
        this.fromFishingNet = bl;
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.m_7378_(nbt);
        this.setMoistness(nbt.m_128451_(MOISTNESS_KEY));
        this.setSize(nbt.m_128451_(FISH_SIZE_KEY));
        this.setHunger(nbt.m_128451_(HUNGER_KEY));
        this.fromFishingNet = nbt.m_128471_("FromFishingNet");
    }

    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions dimensions) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)dimensions, (String)"dimensions");
        return dimensions.f_20378_ * 0.5f;
    }

    public boolean m_6785_(double distanceSquared) {
        return !this.fromFishingNet && !this.m_8077_();
    }

    @NotNull
    public SoundEvent getFlopSound() {
        return this.flopSound;
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        SoundEvent soundEvent = SoundEvents.f_11761_;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"COD_HURT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent m_5592_() {
        SoundEvent soundEvent = SoundEvents.f_11759_;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"COD_DEATH");
        return soundEvent;
    }

    protected void m_7625_(@NotNull DamageSource source, boolean causedByPlayer) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Entity attacker = source.m_7640_();
        if (!(attacker instanceof HybridAquaticFishEntity || attacker instanceof HybridAquaticSharkEntity || attacker instanceof HybridAquaticCephalopodEntity || attacker instanceof HybridAquaticMammalEntity)) {
            super.m_7625_(source, causedByPlayer);
        }
    }

    private final int getHandSwingDuration() {
        return 40;
    }

    protected void m_21203_() {
        int i = this.getHandSwingDuration();
        if (this.f_20911_) {
            ++this.f_20913_;
            if (this.f_20913_ >= i) {
                this.f_20913_ = 0;
                this.f_20911_ = false;
            }
        } else {
            this.f_20913_ = 0;
        }
        this.f_20921_ = (float)this.f_20913_ / (float)i;
    }

    public float m_21324_(float tickDelta) {
        float f = this.f_20921_ - this.f_20920_;
        if (f < 0.0f) {
            f += 1.0f;
        }
        return this.f_20920_ + f * tickDelta;
    }

    public boolean m_7327_(@NotNull Entity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (super.m_7327_(target)) {
            this.m_5496_(SoundEvents.f_11945_, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public final int getMoistness() {
        Object object = this.f_19804_.m_135370_(MOISTNESS);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setMoistness(int moistness) {
        this.f_19804_.m_135381_(MOISTNESS, (Object)moistness);
    }

    public final int getSize() {
        Object object = this.f_19804_.m_135370_(FISH_SIZE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setSize(int size) {
        this.f_19804_.m_135381_(FISH_SIZE, (Object)size);
    }

    public final int getHunger() {
        Object object = this.f_19804_.m_135370_(HUNGER);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setHunger(int hunger) {
        this.f_19804_.m_135381_(HUNGER, (Object)hunger);
    }

    protected boolean hasSelfControl() {
        return true;
    }

    protected int getMinSize() {
        return -5;
    }

    protected int getMaxSize() {
        return 5;
    }

    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllers) {
        Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
        AnimationController[] animationControllerArray = new AnimationController[]{new AnimationController((GeoAnimatable)this, "Fish Controller", 4, arg_0 -> HybridAquaticFishEntity.registerControllers$lambda$4(this, arg_0))};
        controllers.add(animationControllerArray);
    }

    @NotNull
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        AnimatableInstanceCache animatableInstanceCache = this.factory;
        Intrinsics.checkNotNullExpressionValue((Object)animatableInstanceCache, (String)"factory");
        return animatableInstanceCache;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return (PathNavigation)new WaterBoundPathNavigation((Mob)this, level);
    }

    public int m_8132_() {
        return 5;
    }

    public int m_8085_() {
        return 1;
    }

    private static final boolean registerGoals$lambda$1(HybridAquaticFishEntity this$0, LivingEntity entity) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Iterable $this$any$iv = this$0.getPredator();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TagKey predatorTag = (TagKey)element$iv;
                    boolean bl2 = false;
                    if (!entity.m_6095_().m_204039_(predatorTag)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean registerGoals$lambda$3(HybridAquaticFishEntity this$0, LivingEntity entity) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Iterable $this$any$iv = this$0.getPrey();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TagKey preyType = (TagKey)element$iv;
                    boolean bl2 = false;
                    if (!entity.m_6095_().m_204039_(preyType)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl && this$0.getHunger() < 600;
    }

    private static final PlayState registerControllers$lambda$4(HybridAquaticFishEntity this$0, AnimationState state) {
        return this$0.m_20069_() && state.isMoving() ? state.setAndContinue(DefaultAnimations.SWIM) : (this$0.m_20069_() && this$0.m_20142_() && state.isMoving() ? state.setAndContinue(DefaultAnimations.RUN) : (this$0.m_20069_() && !state.isMoving() ? state.setAndContinue(DefaultAnimations.IDLE) : (this$0.getMoistness() < 595 ? state.setAndContinue(FLOP_ANIMATION) : state.setAndContinue(DefaultAnimations.IDLE))));
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.m_135353_(HybridAquaticFishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        MOISTNESS = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.m_135353_(HybridAquaticFishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        FISH_SIZE = entityDataAccessor2;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.m_135353_(HybridAquaticFishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(...)");
        HUNGER = entityDataAccessor3;
        EntityDataAccessor entityDataAccessor4 = SynchedEntityData.m_135353_(HybridAquaticFishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor4, (String)"defineId(...)");
        ATTEMPT_ATTACK = entityDataAccessor4;
        RawAnimation rawAnimation = RawAnimation.begin().thenPlay("misc.flop");
        Intrinsics.checkNotNullExpressionValue((Object)rawAnimation, (String)"thenPlay(...)");
        FLOP_ANIMATION = rawAnimation;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0019\u001a\u00020\u000e2\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J6\u0010%\u001a\u00020\u000e2\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J6\u0010&\u001a\u00020\u000e2\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J6\u0010'\u001a\u00020\u000e2\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020)R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticFishEntity$Companion;", "", "<init>", "()V", "MOISTNESS", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getMOISTNESS", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "FISH_SIZE", "getFISH_SIZE", "HUNGER", "getHUNGER", "ATTEMPT_ATTACK", "", "getATTEMPT_ATTACK", "FLOP_ANIMATION", "Lsoftware/bernie/geckolib/core/animation/RawAnimation;", "getFLOP_ANIMATION", "()Lsoftware/bernie/geckolib/core/animation/RawAnimation;", "MAX_HUNGER", "HUNGER_KEY", "", "MOISTNESS_KEY", "FISH_SIZE_KEY", "canShallowSpawn", "type", "Lnet/minecraft/world/entity/EntityType;", "Lnet/minecraft/world/entity/animal/WaterAnimal;", "world", "Lnet/minecraft/world/level/ServerLevelAccessor;", "reason", "Lnet/minecraft/world/entity/MobSpawnType;", "pos", "Lnet/minecraft/core/BlockPos;", "random", "Lnet/minecraft/util/RandomSource;", "canSpawn", "canNightSpawn", "canDeepSpawn", "getScaleAdjustment", "", "fish", "Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticFishEntity;", "adjustment", "hybrid-aquatic-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Integer> getMOISTNESS() {
            return MOISTNESS;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getFISH_SIZE() {
            return FISH_SIZE;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getHUNGER() {
            return HUNGER;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getATTEMPT_ATTACK() {
            return ATTEMPT_ATTACK;
        }

        @NotNull
        public final RawAnimation getFLOP_ANIMATION() {
            return FLOP_ANIMATION;
        }

        public final boolean canShallowSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            int topY = world.m_5736_() - 1;
            int bottomY = world.m_5736_() - 8;
            int n = pos.m_123342_();
            return (bottomY <= n ? n <= topY : false) && world.m_46801_(pos) && world.m_46861_(pos);
        }

        public final boolean canSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            return WaterAnimal.m_218282_(type, (LevelAccessor)((LevelAccessor)world), (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean canNightSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            if (world.m_6018_().m_46461_()) return false;
            int n = world.m_5736_() - 24;
            int n2 = world.m_5736_() - 12;
            int n3 = pos.m_123342_();
            if (n > n3) return false;
            if (n3 > n2) return false;
            boolean bl = true;
            if (!bl) return false;
            if (!world.m_46801_(pos)) return false;
            if (!world.m_46861_(pos)) return false;
            return true;
        }

        public final boolean canDeepSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            int n = world.m_5736_() - 128;
            int n2 = world.m_5736_() - 48;
            int n3 = pos.m_123342_();
            return (n <= n3 ? n3 <= n2 : false) && world.m_46801_(pos);
        }

        public final float getScaleAdjustment(@NotNull HybridAquaticFishEntity fish, float adjustment) {
            Intrinsics.checkNotNullParameter((Object)((Object)fish), (String)"fish");
            return 1.0f + (float)fish.getSize() * adjustment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

