/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.fish;

import dev.hybridlabs.aquatic.effect.HybridAquaticMobEffects;
import dev.hybridlabs.aquatic.entity.ai.goal.boids.BoidGoal;
import dev.hybridlabs.aquatic.entity.ai.goal.boids.StayInWaterGoal;
import dev.hybridlabs.aquatic.entity.fish.HybridAquaticSchoolingFishEntity;
import dev.hybridlabs.aquatic.tag.HybridAquaticEntityTags;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.tags.TagKey;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\u001f\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\nH\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\u001d\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u001e\u001a\u00020\u000fH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldev/hybridlabs/aquatic/entity/fish/PiranhaEntity;", "Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticSchoolingFishEntity;", "Lnet/minecraft/world/entity/NeutralMob;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "angerTime", "", "angryAt", "Ljava/util/UUID;", "getMaxSpawnClusterSize", "registerControllers", "", "controllers", "Lsoftware/bernie/geckolib/core/animation/AnimatableManager$ControllerRegistrar;", "registerGoals", "canCollideWith", "", "entity", "Lnet/minecraft/world/entity/Entity;", "doPush", "doHurtTarget", "target", "getRemainingPersistentAngerTime", "setRemainingPersistentAngerTime", "getPersistentAngerTarget", "setPersistentAngerTarget", "startPersistentAngerTimer", "Companion", "hybrid-aquatic-forge-1.20.1"})
public final class PiranhaEntity
extends HybridAquaticSchoolingFishEntity
implements NeutralMob {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int angerTime;
    @Nullable
    private UUID angryAt;
    @NotNull
    private static final IntProvider ANGER_TIME_RANGE;

    public PiranhaEntity(@NotNull EntityType<? extends PiranhaEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Object[] objectArray = new TagKey[]{HybridAquaticEntityTags.INSTANCE.getMEDIUM_PREY(), HybridAquaticEntityTags.INSTANCE.getLARGE_PREY(), HybridAquaticEntityTags.INSTANCE.getSHARK()};
        super(entityType, world, CollectionsKt.listOf(HybridAquaticEntityTags.INSTANCE.getSMALL_PREY()), CollectionsKt.listOf((Object[])objectArray), null, 0, 48, null);
    }

    @Override
    public int m_5792_() {
        return 4;
    }

    @Override
    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllers) {
        Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
        super.registerControllers(controllers);
        AnimationController[] animationControllerArray = new AnimationController[]{new AnimationController((GeoAnimatable)this, "Charge", 8, arg_0 -> PiranhaEntity.registerControllers$lambda$0(this, arg_0))};
        controllers.add(animationControllerArray);
        animationControllerArray = new AnimationController[]{DefaultAnimations.genericAttackAnimation((LivingEntity)((LivingEntity)this), (RawAnimation)DefaultAnimations.ATTACK_BITE)};
        controllers.add(animationControllerArray);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new BoidGoal((Mob)this, 0.25f, 0.5f, 0.4f, 0.05f));
        this.f_21345_.m_25352_(3, (Goal)new StayInWaterGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, true, arg_0 -> PiranhaEntity.registerGoals$lambda$1(this, arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, true, PiranhaEntity::registerGoals$lambda$2));
    }

    public boolean m_7337_(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof PiranhaEntity) {
            return false;
        }
        return super.m_7337_(entity);
    }

    protected void m_7324_(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof PiranhaEntity) {
            return;
        }
        super.m_7324_(entity);
    }

    @Override
    public boolean m_7327_(@NotNull Entity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (super.m_7327_(target)) {
            if (target instanceof LivingEntity) {
                int i = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    i = 7;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    i = 15;
                }
                if (i > 0) {
                    ((LivingEntity)target).m_147207_(new MobEffectInstance(HybridAquaticMobEffects.INSTANCE.getBLEEDING().get(), i * 20, 0), (Entity)this);
                }
            }
            return true;
        }
        return false;
    }

    public int m_6784_() {
        return this.angerTime;
    }

    public void m_7870_(int angerTime) {
        this.angerTime = angerTime;
    }

    @Nullable
    public UUID m_6120_() {
        return this.angryAt;
    }

    public void m_6925_(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME_RANGE.m_214085_(this.f_19796_));
    }

    private static final PlayState registerControllers$lambda$0(PiranhaEntity this$0, AnimationState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this$0.m_5842_() && this$0.m_20142_()) {
            return state.setAndContinue(DefaultAnimations.RUN);
        }
        return PlayState.STOP;
    }

    private static final boolean registerGoals$lambda$1(PiranhaEntity this$0, LivingEntity it) {
        return this$0.m_21674_(it);
    }

    private static final boolean registerGoals$lambda$2(LivingEntity it) {
        return it.m_21023_(HybridAquaticMobEffects.INSTANCE.getBLEEDING().get()) && !(it instanceof PiranhaEntity);
    }

    static {
        UniformInt uniformInt = TimeUtil.m_145020_((int)10, (int)30);
        Intrinsics.checkNotNullExpressionValue((Object)uniformInt, (String)"rangeOfSeconds(...)");
        ANGER_TIME_RANGE = (IntProvider)uniformInt;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/PiranhaEntity$Companion;", "", "<init>", "()V", "ANGER_TIME_RANGE", "Lnet/minecraft/util/valueproviders/IntProvider;", "getANGER_TIME_RANGE", "()Lnet/minecraft/util/valueproviders/IntProvider;", "createMobAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "hybrid-aquatic-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntProvider getANGER_TIME_RANGE() {
            return ANGER_TIME_RANGE;
        }

        @NotNull
        public final AttributeSupplier.Builder createMobAttributes() {
            AttributeSupplier.Builder builder = WaterAnimal.m_21183_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22277_, 4.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

