/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.mixin;

import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.hybridlabs.aquatic.access.CustomFishingBobberEntityData;
import dev.hybridlabs.aquatic.entity.HybridAquaticEntityTypes;
import dev.hybridlabs.aquatic.entity.miniboss.KarkinosEntity;
import dev.hybridlabs.aquatic.item.HybridAquaticItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FishingHook.class})
public abstract class FishingBobberEntityMixin
extends Entity
implements CustomFishingBobberEntityData {
    @Shadow
    private int f_37090_;
    @Unique
    private ItemStack lureItemStack = Items.f_41852_.m_7968_();

    @Shadow
    public abstract Player m_37168_();

    private FishingBobberEntityMixin(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbt(CompoundTag nbt, CallbackInfo ci) {
        this.hybrid_aquatic$setLureItem(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("lureItem")));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbt(CompoundTag nbt, CallbackInfo ci) {
        CompoundTag itemStack = new CompoundTag();
        this.hybrid_aquatic$getLureItem().m_41739_(itemStack);
        nbt.m_128365_("lureItem", (Tag)itemStack);
    }

    @Override
    public ItemStack hybrid_aquatic$getLureItem() {
        return this.lureItemStack;
    }

    @Override
    public void hybrid_aquatic$setLureItem(ItemStack item) {
        this.lureItemStack = item == null ? Items.f_41852_.m_7968_() : item;
    }

    @Inject(method={"catchingFish"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Mth;nextInt(Lnet/minecraft/util/RandomSource;II)I", ordinal=2, shift=At.Shift.AFTER)})
    private void reduceCooldownTime(BlockPos pos, CallbackInfo ci) {
        Item lureItem = this.lureItemStack.m_41720_();
        if (lureItem.equals(HybridAquaticItems.INSTANCE.getBARBED_HOOK().get()) && this.m_9236_().m_46461_()) {
            this.f_37090_ -= 75;
        } else if (lureItem.equals(HybridAquaticItems.INSTANCE.getGLOWING_HOOK().get()) && this.m_9236_().m_46462_()) {
            this.f_37090_ -= 75;
        }
    }

    @WrapOperation(method={"retrieve"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getLuck()F")})
    private float increaseLuck(Player player, Operation<Float> original) {
        if (this.lureItemStack.m_41720_().equals(HybridAquaticItems.INSTANCE.getMAGNETIC_HOOK().get())) {
            return player.m_36336_() + 27.0f;
        }
        return ((Float)original.call(new Object[]{player})).floatValue();
    }

    @ModifyReceiver(method={"retrieve"}, slice={@Slice(from=@At(value="NEW", target="Lnet/minecraft/world/level/storage/loot/LootParams$Builder;"))}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/loot/LootTable;getRandomItems(Lnet/minecraft/world/level/storage/loot/LootParams;)Lit/unimi/dsi/fastutil/objects/ObjectArrayList;")})
    private LootTable onHookReelEntity(LootTable instance, LootParams parameters) {
        if (!this.lureItemStack.m_41619_()) {
            if (this.lureItemStack.m_150930_(HybridAquaticItems.INSTANCE.getOMINOUS_HOOK().get())) {
                EntityType<KarkinosEntity> karkinosType = HybridAquaticEntityTypes.INSTANCE.getKARKINOS().get();
                this.createAndLaunchEntityAtPlayer(karkinosType);
                instance = LootTable.f_79105_;
            } else if (this.lureItemStack.m_150930_(HybridAquaticItems.INSTANCE.getCREEPERMAGNET_HOOK().get())) {
                EntityType creeperType = EntityType.f_20558_;
                this.createAndLaunchEntityAtPlayer(creeperType);
                instance = LootTable.f_79105_;
            }
            this.lureItemStack.m_41622_(1, (LivingEntity)this.m_37168_(), player -> this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f));
        }
        return instance;
    }

    @Unique
    private void createAndLaunchEntityAtPlayer(EntityType<?> entityType) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            Entity entity = entityType.m_262496_(serverWorld, this.m_20183_(), MobSpawnType.MOB_SUMMONED);
            if (entity == null) {
                return;
            }
            double modifier = 0.15;
            Vec3 vecBetween = this.m_37168_().m_20182_().m_82546_(this.m_20182_());
            Vec3 vecBetweenMod = vecBetween.m_82490_(modifier);
            double yOffset = Math.sqrt(Math.sqrt(Math.pow(vecBetween.f_82479_, 2.0) + Math.pow(vecBetween.f_82480_, 2.0) + Math.pow(vecBetween.f_82481_, 2.0))) * 0.08;
            entity.m_20334_(vecBetweenMod.f_82479_, vecBetweenMod.f_82480_ + yOffset, vecBetweenMod.f_82481_);
        }
    }

    @Inject(method={"retrieve"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/FishingHook;discard()V")})
    private void retrieveLureOnSuccess(ItemStack usedItem, CallbackInfoReturnable<Integer> cir) {
        this.retrieveLure(this.m_37168_());
    }

    @Inject(method={"shouldStopFishing"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/FishingHook;discard()V")})
    private void retrieveLureIfInvalid(Player player, CallbackInfoReturnable<Boolean> cir) {
        this.retrieveLure(player);
    }

    @Unique
    private void retrieveLure(Player player) {
        if (!this.lureItemStack.m_41619_()) {
            Vec3 pos;
            if (player == null || player.m_213877_() || !player.m_6084_()) {
                pos = this.m_20182_();
            } else {
                if (player.m_6844_(EquipmentSlot.OFFHAND).m_41619_()) {
                    player.m_8061_(EquipmentSlot.OFFHAND, this.lureItemStack);
                    if (player.m_6844_(EquipmentSlot.OFFHAND) == this.lureItemStack) {
                        return;
                    }
                }
                if (player.m_150109_().m_36054_(this.lureItemStack)) {
                    return;
                }
                pos = player.m_20182_();
            }
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, this.lureItemStack);
            itemEntity.m_20256_(Vec3.f_82478_);
            this.m_9236_().m_7967_((Entity)itemEntity);
        }
    }
}

