/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.platform;

import dev.hybridlabs.aquatic.Constants;
import dev.hybridlabs.aquatic.platform.services.DivingArmorProvider;
import dev.hybridlabs.aquatic.platform.services.EelArmorProvider;
import dev.hybridlabs.aquatic.platform.services.ManglerfishArmorProvider;
import dev.hybridlabs.aquatic.platform.services.MoonJellyfishArmorProvider;
import dev.hybridlabs.aquatic.platform.services.PlatformHelper;
import dev.hybridlabs.aquatic.platform.services.SeashellArmorProvider;
import dev.hybridlabs.aquatic.platform.services.TurtleArmorProvider;
import java.util.ServiceLoader;

public class Services {
    public static final PlatformHelper PLATFORM = Services.load(PlatformHelper.class);
    public static final EelArmorProvider EEL_ARMOR_FACTORY = Services.load(EelArmorProvider.class);
    public static final DivingArmorProvider DIVING_ARMOR_FACTORY = Services.load(DivingArmorProvider.class);
    public static final SeashellArmorProvider SEASHELL_ARMOR_FACTORY = Services.load(SeashellArmorProvider.class);
    public static final ManglerfishArmorProvider MANGLERFISH_ARMOR_FACTORY = Services.load(ManglerfishArmorProvider.class);
    public static final MoonJellyfishArmorProvider MOON_JELLYFISH_ARMOR_FACTORY = Services.load(MoonJellyfishArmorProvider.class);
    public static final TurtleArmorProvider TURTLE_ARMOR_FACTORY = Services.load(TurtleArmorProvider.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        Constants.LOG.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

