/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic;

import com.mojang.serialization.Codec;
import dev.hybridlabs.aquatic.CommonClass;
import dev.hybridlabs.aquatic.Constants;
import dev.hybridlabs.aquatic.block.PlushieBlock;
import dev.hybridlabs.aquatic.block.SeaMessage;
import dev.hybridlabs.aquatic.block.entity.HybridAquaticBlockEntityTypes;
import dev.hybridlabs.aquatic.client.model.HybridAquaticEntityModelLayers;
import dev.hybridlabs.aquatic.client.model.block.entity.plushie.BaskingSharkPlushieModel;
import dev.hybridlabs.aquatic.client.model.block.entity.plushie.BullSharkPlushieModel;
import dev.hybridlabs.aquatic.client.model.block.entity.plushie.FrilledSharkPlushieModel;
import dev.hybridlabs.aquatic.client.model.block.entity.plushie.GreatWhiteSharkPlushieModel;
import dev.hybridlabs.aquatic.client.model.block.entity.plushie.HammerheadSharkPlushieModel;
import dev.hybridlabs.aquatic.client.model.block.entity.plushie.ThresherSharkPlushieModel;
import dev.hybridlabs.aquatic.client.model.block.entity.plushie.TigerSharkPlushieModel;
import dev.hybridlabs.aquatic.client.model.block.entity.plushie.WhaleSharkPlushieModel;
import dev.hybridlabs.aquatic.client.render.block.HybridAquaticBlockRenderers;
import dev.hybridlabs.aquatic.client.render.block.entity.AnemoneBlockEntityRenderer;
import dev.hybridlabs.aquatic.client.render.block.entity.BuoyBlockEntityRenderer;
import dev.hybridlabs.aquatic.client.render.block.entity.GiantGreenAnemoneBlockEntityRenderer;
import dev.hybridlabs.aquatic.client.render.block.entity.MessageInABottleBlockEntityRenderer;
import dev.hybridlabs.aquatic.client.render.block.entity.StrawberryAnemoneBlockEntityRenderer;
import dev.hybridlabs.aquatic.entity.SpawnRestrictionRegistry;
import dev.hybridlabs.aquatic.network.HybridAquaticNetworking;
import dev.hybridlabs.aquatic.potions.HybridAquaticPotions;
import dev.hybridlabs.aquatic.registry.HybridAquaticRegistryKeys;
import dev.hybridlabs.aquatic.utils.HybridAquaticCustomTrades;
import dev.hybridlabs.aquatic.utils.HybridAquaticSpawnGroup;
import dev.hybridlabs.aquatic.world.gen.feature.DunegrassFeature;
import dev.hybridlabs.aquatic.world.gen.feature.HybridAquaticFeatures;
import dev.hybridlabs.aquatic.world.gen.structure.StructureSpawnModifier;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DataPackRegistryEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import thedarkcolour.kotlinforforge.KotlinModLoadingContext;

@Mod(value="hybrid_aquatic")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/hybridlabs/aquatic/HybridAquaticForge;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "loadSeaMessages", "", "event", "Lnet/minecraftforge/registries/DataPackRegistryEvent$NewRegistry;", "createSpawnGroups", "registerSpawnPlacements", "Lnet/minecraftforge/event/entity/SpawnPlacementRegisterEvent;", "registerModelLayers", "Lnet/minecraftforge/client/event/EntityRenderersEvent$RegisterLayerDefinitions;", "registerBlockEntityRenderers", "Lnet/minecraftforge/client/event/EntityRenderersEvent$RegisterRenderers;", "registerSkullModels", "Lnet/minecraftforge/client/event/EntityRenderersEvent$CreateSkullModels;", "onClientSetup", "Lnet/minecraftforge/fml/event/lifecycle/FMLClientSetupEvent;", "onServerSetup", "Lnet/minecraftforge/fml/event/lifecycle/FMLDedicatedServerSetupEvent;", "registerPotionsRecipes", "Lnet/minecraftforge/fml/event/lifecycle/FMLCommonSetupEvent;", "registerStructureModifiers", "hybrid-aquatic-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nHybridAquaticForge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HybridAquaticForge.kt\ndev/hybridlabs/aquatic/HybridAquaticForge\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Forge.kt\nthedarkcolour/kotlinforforge/forge/ForgeKt\n*L\n1#1,239:1\n37#2:240\n36#2,3:241\n13472#3,2:244\n39#4:246\n39#4:247\n39#4:248\n27#4:249\n27#4:250\n80#4:251\n52#4:252\n81#4:253\n39#4:254\n39#4:255\n39#4:256\n39#4:257\n39#4:258\n83#4:259\n39#4:260\n*S KotlinDebug\n*F\n+ 1 HybridAquaticForge.kt\ndev/hybridlabs/aquatic/HybridAquaticForge\n*L\n124#1:240\n124#1:241,3\n124#1:244,2\n233#1:246\n94#1:247\n95#1:248\n96#1:249\n97#1:250\n99#1:251\n99#1:252\n99#1:253\n101#1:254\n102#1:255\n103#1:256\n104#1:257\n105#1:258\n99#1:259\n109#1:260\n*E\n"})
public final class HybridAquaticForge {
    @NotNull
    public static final HybridAquaticForge INSTANCE = new HybridAquaticForge();
    @NotNull
    private static final Logger logger;

    private HybridAquaticForge() {
    }

    public final void loadSeaMessages(@NotNull DataPackRegistryEvent.NewRegistry event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.dataPackRegistry(HybridAquaticRegistryKeys.INSTANCE.getSEA_MESSAGE(), SeaMessage.Companion.getCODEC(), SeaMessage.Companion.getCODEC());
    }

    private final void createSpawnGroups() {
        Collection $this$toTypedArray$iv = (Collection)EntriesMappings.entries$0;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        HybridAquaticSpawnGroup[] $this$forEach$iv = thisCollection$iv.toArray(new HybridAquaticSpawnGroup[0]);
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            HybridAquaticSpawnGroup element$iv;
            HybridAquaticSpawnGroup it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            MobCategory.create((String)it.name, (String)it.name, (int)it.spawnCap, (boolean)it.peaceful, (boolean)it.rare, (int)it.immediateDespawnRange);
        }
    }

    private final void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        SpawnRestrictionRegistry.INSTANCE.registerSpawnRestrictions();
    }

    private final void registerModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(HybridAquaticEntityModelLayers.INSTANCE.getBASKING_SHARK_PLUSHIE(), BaskingSharkPlushieModel.Companion::createModelData);
        event.registerLayerDefinition(HybridAquaticEntityModelLayers.INSTANCE.getBULL_SHARK_PLUSHIE(), BullSharkPlushieModel.Companion::createModelData);
        event.registerLayerDefinition(HybridAquaticEntityModelLayers.INSTANCE.getFRILLED_SHARK_PLUSHIE(), FrilledSharkPlushieModel.Companion::createModelData);
        event.registerLayerDefinition(HybridAquaticEntityModelLayers.INSTANCE.getGREAT_WHITE_SHARK_PLUSHIE(), GreatWhiteSharkPlushieModel.Companion::createModelData);
        event.registerLayerDefinition(HybridAquaticEntityModelLayers.INSTANCE.getHAMMERHEAD_SHARK_PLUSHIE(), HammerheadSharkPlushieModel.Companion::createModelData);
        event.registerLayerDefinition(HybridAquaticEntityModelLayers.INSTANCE.getTHRESHER_SHARK_PLUSHIE(), ThresherSharkPlushieModel.Companion::createModelData);
        event.registerLayerDefinition(HybridAquaticEntityModelLayers.INSTANCE.getTIGER_SHARK_PLUSHIE(), TigerSharkPlushieModel.Companion::createModelData);
        event.registerLayerDefinition(HybridAquaticEntityModelLayers.INSTANCE.getWHALE_SHARK_PLUSHIE(), WhaleSharkPlushieModel.Companion::createModelData);
    }

    private final void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(HybridAquaticBlockEntityTypes.INSTANCE.getANEMONE().get(), AnemoneBlockEntityRenderer::new);
        event.registerBlockEntityRenderer(HybridAquaticBlockEntityTypes.INSTANCE.getSTRAWBERRY_ANEMONE().get(), StrawberryAnemoneBlockEntityRenderer::new);
        event.registerBlockEntityRenderer(HybridAquaticBlockEntityTypes.INSTANCE.getGIANT_GREEN_ANEMONE().get(), GiantGreenAnemoneBlockEntityRenderer::new);
        event.registerBlockEntityRenderer(HybridAquaticBlockEntityTypes.INSTANCE.getMESSAGE_IN_A_BOTTLE().get(), MessageInABottleBlockEntityRenderer::new);
        event.registerBlockEntityRenderer(HybridAquaticBlockEntityTypes.INSTANCE.getBUOY().get(), BuoyBlockEntityRenderer::new);
        HybridAquaticBlockRenderers.INSTANCE.registerRenderShapes();
    }

    private final void registerSkullModels(EntityRenderersEvent.CreateSkullModels event) {
        EntityModelSet modelLoader = event.getEntityModelSet();
        SkullBlock.Type type = PlushieBlock.Variant.BASKING_SHARK;
        ModelPart modelPart = modelLoader.m_171103_(HybridAquaticEntityModelLayers.INSTANCE.getBASKING_SHARK_PLUSHIE());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        event.registerSkullModel(type, (SkullModelBase)new BaskingSharkPlushieModel(modelPart));
        SkullBlock.Type type2 = PlushieBlock.Variant.BULL_SHARK;
        ModelPart modelPart2 = modelLoader.m_171103_(HybridAquaticEntityModelLayers.INSTANCE.getBULL_SHARK_PLUSHIE());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"bakeLayer(...)");
        event.registerSkullModel(type2, (SkullModelBase)new BullSharkPlushieModel(modelPart2));
        SkullBlock.Type type3 = PlushieBlock.Variant.FRILLED_SHARK;
        ModelPart modelPart3 = modelLoader.m_171103_(HybridAquaticEntityModelLayers.INSTANCE.getFRILLED_SHARK_PLUSHIE());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart3, (String)"bakeLayer(...)");
        event.registerSkullModel(type3, (SkullModelBase)new BullSharkPlushieModel(modelPart3));
        SkullBlock.Type type4 = PlushieBlock.Variant.GREAT_WHITE_SHARK;
        ModelPart modelPart4 = modelLoader.m_171103_(HybridAquaticEntityModelLayers.INSTANCE.getGREAT_WHITE_SHARK_PLUSHIE());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart4, (String)"bakeLayer(...)");
        event.registerSkullModel(type4, (SkullModelBase)new BullSharkPlushieModel(modelPart4));
        SkullBlock.Type type5 = PlushieBlock.Variant.HAMMERHEAD_SHARK;
        ModelPart modelPart5 = modelLoader.m_171103_(HybridAquaticEntityModelLayers.INSTANCE.getHAMMERHEAD_SHARK_PLUSHIE());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart5, (String)"bakeLayer(...)");
        event.registerSkullModel(type5, (SkullModelBase)new BullSharkPlushieModel(modelPart5));
        SkullBlock.Type type6 = PlushieBlock.Variant.THRESHER_SHARK;
        ModelPart modelPart6 = modelLoader.m_171103_(HybridAquaticEntityModelLayers.INSTANCE.getTHRESHER_SHARK_PLUSHIE());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart6, (String)"bakeLayer(...)");
        event.registerSkullModel(type6, (SkullModelBase)new BullSharkPlushieModel(modelPart6));
        SkullBlock.Type type7 = PlushieBlock.Variant.TIGER_SHARK;
        ModelPart modelPart7 = modelLoader.m_171103_(HybridAquaticEntityModelLayers.INSTANCE.getTIGER_SHARK_PLUSHIE());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart7, (String)"bakeLayer(...)");
        event.registerSkullModel(type7, (SkullModelBase)new BullSharkPlushieModel(modelPart7));
        SkullBlock.Type type8 = PlushieBlock.Variant.WHALE_SHARK;
        ModelPart modelPart8 = modelLoader.m_171103_(HybridAquaticEntityModelLayers.INSTANCE.getWHALE_SHARK_PLUSHIE());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart8, (String)"bakeLayer(...)");
        event.registerSkullModel(type8, (SkullModelBase)new BullSharkPlushieModel(modelPart8));
    }

    private final void onClientSetup(FMLClientSetupEvent event) {
        logger.info("Initializing client...");
    }

    private final void onServerSetup(FMLDedicatedServerSetupEvent event) {
        logger.info("Server starting...");
    }

    private final void registerPotionsRecipes(FMLCommonSetupEvent event) {
        event.enqueueWork(HybridAquaticForge::registerPotionsRecipes$lambda$3);
    }

    private final void registerStructureModifiers() {
        DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.STRUCTURE_MODIFIER_SERIALIZERS, (String)"hybrid-aquatic");
        Intrinsics.checkNotNullExpressionValue((Object)deferredRegister, (String)"create(...)");
        DeferredRegister structureModifiers = deferredRegister;
        boolean $i$f$getMOD_BUS = false;
        structureModifiers.register(KotlinModLoadingContext.Companion.get().getKEventBus());
        structureModifiers.register("ha_structure_spawns", StructureSpawnModifier.Companion::makeCodec);
    }

    private static final void registerPotionsRecipes$lambda$3() {
        HybridAquaticPotions.INSTANCE.registerPotionRecipes();
    }

    static {
        Logger logger = Constants.LOG;
        Intrinsics.checkNotNull((Object)logger);
        HybridAquaticForge.logger = logger;
        CommonClass.init();
        INSTANCE.createSpawnGroups();
        INSTANCE.registerStructureModifiers();
        Codec codec = ProbabilityFeatureConfiguration.f_67858_;
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"CODEC");
        HybridAquaticFeatures.INSTANCE.register("dunegrass_patch", (Feature)new DunegrassFeature((Codec<ProbabilityFeatureConfiguration>)codec));
        HybridAquaticNetworking.INSTANCE.registerPackets();
        boolean $i$f$getMOD_BUS = false;
        KotlinModLoadingContext.Companion.get().getKEventBus().addListener(INSTANCE::loadSeaMessages);
        $i$f$getMOD_BUS = false;
        KotlinModLoadingContext.Companion.get().getKEventBus().addListener(INSTANCE::registerPotionsRecipes);
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(HybridAquaticCustomTrades::registerWandererTrades);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus2 = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus2, (String)"EVENT_BUS");
        iEventBus2.addListener(HybridAquaticCustomTrades::registerCustomTrades);
        boolean $i$f$runForDist = false;
        boolean $i$f$getDIST = false;
        Dist dist = FMLEnvironment.dist;
        Intrinsics.checkNotNullExpressionValue((Object)dist, (String)"dist");
        if (dist == Dist.CLIENT) {
            boolean bl = false;
            boolean $i$f$getMOD_BUS2 = false;
            KotlinModLoadingContext.Companion.get().getKEventBus().addListener(INSTANCE::onClientSetup);
            $i$f$getMOD_BUS2 = false;
            KotlinModLoadingContext.Companion.get().getKEventBus().addListener(INSTANCE::registerModelLayers);
            $i$f$getMOD_BUS2 = false;
            KotlinModLoadingContext.Companion.get().getKEventBus().addListener(INSTANCE::registerSkullModels);
            $i$f$getMOD_BUS2 = false;
            KotlinModLoadingContext.Companion.get().getKEventBus().addListener(INSTANCE::registerBlockEntityRenderers);
            $i$f$getMOD_BUS2 = false;
            KotlinModLoadingContext.Companion.get().getKEventBus().addListener(INSTANCE::registerSpawnPlacements);
        } else {
            boolean bl = false;
            boolean $i$f$getMOD_BUS3 = false;
            KotlinModLoadingContext.Companion.get().getKEventBus().addListener(INSTANCE::onServerSetup);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<HybridAquaticSpawnGroup> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])HybridAquaticSpawnGroup.values());
        }
    }
}

