/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.ai.goal;

import dev.hybridlabs.aquatic.entity.miniboss.KarkinosEntity;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0005H\u0014J\b\u0010\u001c\u001a\u00020\u0015H\u0014J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0011H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldev/hybridlabs/aquatic/entity/ai/goal/KarkinosMeleeAttackGoal;", "Lnet/minecraft/world/entity/ai/goal/MeleeAttackGoal;", "karkinos", "Ldev/hybridlabs/aquatic/entity/miniboss/KarkinosEntity;", "speedModifier", "", "followingTargetEvenIfNotSeen", "", "<init>", "(Ldev/hybridlabs/aquatic/entity/miniboss/KarkinosEntity;DZ)V", "getKarkinos", "()Ldev/hybridlabs/aquatic/entity/miniboss/KarkinosEntity;", "ticksUntilNextPathRecalculation", "", "ticksUntilNextAttack", "attackDelayTicks", "pendingTarget", "Lnet/minecraft/world/entity/LivingEntity;", "canUse", "canContinueToUse", "start", "", "stop", "requiresUpdateEveryTick", "tick", "checkAndPerformAttack", "enemy", "distToEnemySqr", "resetAttackCooldown", "getAttackReachSqr", "attackTarget", "hybrid-aquatic-forge-1.20.1"})
public class KarkinosMeleeAttackGoal
extends MeleeAttackGoal {
    @NotNull
    private final KarkinosEntity karkinos;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private int attackDelayTicks;
    @Nullable
    private LivingEntity pendingTarget;

    public KarkinosMeleeAttackGoal(@NotNull KarkinosEntity karkinos, double speedModifier, boolean followingTargetEvenIfNotSeen) {
        Intrinsics.checkNotNullParameter((Object)((Object)karkinos), (String)"karkinos");
        super((PathfinderMob)karkinos, speedModifier, true);
        this.karkinos = karkinos;
        this.speedModifier = speedModifier;
        this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
        this.m_7021_(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.LOOK));
    }

    @NotNull
    protected final KarkinosEntity getKarkinos() {
        return this.karkinos;
    }

    public boolean m_8036_() {
        if (this.karkinos.isFlipped() || this.karkinos.isSummoning()) {
            return false;
        }
        return super.m_8036_();
    }

    public boolean m_8045_() {
        if (this.karkinos.isFlipped() || this.karkinos.isSummoning()) {
            return false;
        }
        return super.m_8045_();
    }

    public void m_8056_() {
        this.karkinos.m_6858_(true);
        super.m_8056_();
    }

    public void m_8041_() {
        this.karkinos.m_6858_(false);
        super.m_8041_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (this.karkinos.isFlipped()) {
            this.m_8041_();
            return;
        }
        if (this.attackDelayTicks > 0) {
            int n = this.attackDelayTicks;
            this.attackDelayTicks = n + -1;
            if (this.attackDelayTicks == 0 && this.pendingTarget != null && !this.karkinos.m_9236_().f_46443_) {
                ItemStack itemInUse;
                LivingEntity livingEntity = this.pendingTarget;
                Intrinsics.checkNotNull((Object)livingEntity);
                this.karkinos.m_7327_((Entity)livingEntity);
                LivingEntity target = this.pendingTarget;
                if (target instanceof Player && (itemInUse = ((Player)target).m_21211_()).m_150930_(Items.f_42740_)) {
                    ((Player)target).m_36384_(true);
                    ((Player)target).m_9236_().m_7605_((Entity)target, (byte)30);
                }
                this.m_25563_();
                this.pendingTarget = null;
            }
        }
        LivingEntity livingEntity = this.karkinos.m_5448_();
        if (!this.karkinos.m_21573_().m_26572_() && livingEntity != null) {
            this.karkinos.m_21573_().m_5624_((Entity)livingEntity, this.speedModifier);
        }
        if (livingEntity != null) {
            if (this.karkinos.m_20280_((Entity)livingEntity) < 16.0) {
                this.karkinos.m_21563_().m_24960_((Entity)livingEntity, 10.0f, 10.0f);
            }
            double d0 = this.karkinos.m_262793_(livingEntity);
            this.ticksUntilNextPathRecalculation = (int)Math.max((double)(this.ticksUntilNextPathRecalculation - 1), 0.0);
            if ((this.followingTargetEvenIfNotSeen || this.karkinos.m_21574_().m_148306_((Entity)livingEntity)) && this.ticksUntilNextPathRecalculation <= 0) {
                this.karkinos.m_21573_().m_5624_((Entity)livingEntity, this.speedModifier);
                this.ticksUntilNextPathRecalculation = 20;
            }
            this.ticksUntilNextAttack = (int)Math.max((double)(this.ticksUntilNextAttack - 1), 0.0);
            this.m_6739_(livingEntity, d0);
        }
    }

    protected void m_6739_(@NotNull LivingEntity enemy, double distToEnemySqr) {
        Intrinsics.checkNotNullParameter((Object)enemy, (String)"enemy");
        double reachSqr = this.m_6639_(enemy);
        if (distToEnemySqr <= reachSqr && this.ticksUntilNextAttack <= 0 && this.attackDelayTicks == 0) {
            this.karkinos.m_6674_(InteractionHand.MAIN_HAND);
            this.attackDelayTicks = 10;
            this.pendingTarget = enemy;
            this.ticksUntilNextAttack = this.attackDelayTicks;
        }
    }

    protected void m_25563_() {
        this.ticksUntilNextAttack = this.m_183277_(20);
    }

    protected double m_6639_(@NotNull LivingEntity attackTarget) {
        Intrinsics.checkNotNullParameter((Object)attackTarget, (String)"attackTarget");
        return this.karkinos.m_20205_() * 1.75f * this.karkinos.m_20205_() * 1.75f + attackTarget.m_20205_();
    }
}

