/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.cephalopod;

import dev.hybridlabs.aquatic.entity.fish.HybridAquaticFishEntity;
import dev.hybridlabs.aquatic.entity.mammal.HybridAquaticMammalEntity;
import dev.hybridlabs.aquatic.entity.shark.HybridAquaticSharkEntity;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 i2\u00020\u00012\u00020\u0002:\u0002hiBY\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\b\u0012\u0016\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\b0\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u001eH\u0014J6\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0005\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010!2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\fH\u0016J\b\u0010-\u001a\u00020\fH\u0016J\b\u0010.\u001a\u00020\u001eH\u0016J\u0010\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u000201H\u0014J\b\u00102\u001a\u000201H\u0002J\u0018\u00103\u001a\u00020\f2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u00020\u001eH\u0002J\b\u00109\u001a\u00020:H\u0014J\u0010\u0010;\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020)H\u0016J\u0010\u0010=\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020)H\u0016J\u0018\u0010>\u001a\u0002072\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0014J\u0010\u0010C\u001a\u00020\f2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u001e2\u0006\u0010G\u001a\u00020HH\u0016J\u0018\u0010I\u001a\u00020\u001e2\u0006\u00104\u001a\u0002052\u0006\u0010J\u001a\u00020\fH\u0014J\b\u0010K\u001a\u000201H\u0016J\b\u0010L\u001a\u00020MH\u0014J\u0010\u0010N\u001a\u00020M2\u0006\u00104\u001a\u000205H\u0014J\b\u0010O\u001a\u00020MH\u0014J\b\u0010P\u001a\u00020MH\u0002J\u0010\u0010Q\u001a\u00020R2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010a\u001a\u00020\u001e2\u0006\u0010b\u001a\u00020cH\u0016J\b\u0010d\u001a\u00020\u001bH\u0016J\b\u0010e\u001a\u000201H\u0014J\b\u0010f\u001a\u000201H\u0014R\u001e\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\r\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0015\"\u0004\b\u0019\u0010\u0017R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010S\u001a\u0002012\u0006\u0010S\u001a\u0002018B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR$\u0010X\u001a\u0002012\u0006\u0010X\u001a\u0002018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bY\u0010U\"\u0004\bZ\u0010WR$\u0010[\u001a\u0002012\u0006\u0010[\u001a\u0002018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\\\u0010U\"\u0004\b]\u0010WR$\u0010^\u001a\u00020\f2\u0006\u0010^\u001a\u00020\f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b_\u0010\u0015\"\u0004\b`\u0010\u0017R\u000e\u0010g\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticCephalopodEntity;", "Lnet/minecraft/world/entity/animal/WaterAnimal;", "Lsoftware/bernie/geckolib/animatable/GeoEntity;", "type", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "prey", "Lnet/minecraft/tags/TagKey;", "predator", "", "hasInk", "", "hasGlowInk", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;Lnet/minecraft/tags/TagKey;Ljava/util/List;ZZ)V", "getPrey", "()Lnet/minecraft/tags/TagKey;", "getPredator", "()Ljava/util/List;", "getHasInk", "()Z", "setHasInk", "(Z)V", "getHasGlowInk", "setHasGlowInk", "factory", "Lsoftware/bernie/geckolib/core/animatable/instance/AnimatableInstanceCache;", "kotlin.jvm.PlatformType", "registerGoals", "", "defineSynchedData", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnReason", "Lnet/minecraft/world/entity/MobSpawnType;", "entityData", "entityNbt", "Lnet/minecraft/nbt/CompoundTag;", "getMobType", "Lnet/minecraft/world/entity/MobType;", "canBreatheUnderwater", "isPushedByFluid", "tick", "handleAirSupply", "air", "", "getMaxMoistness", "hurt", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "squirt", "getInkParticle", "Lnet/minecraft/core/particles/SimpleParticleType;", "addAdditionalSaveData", "nbt", "readAdditionalSaveData", "getStandingEyeHeight", "pose", "Lnet/minecraft/world/entity/Pose;", "dimensions", "Lnet/minecraft/world/entity/EntityDimensions;", "removeWhenFarAway", "distanceSquared", "", "travel", "travelVector", "Lnet/minecraft/world/phys/Vec3;", "dropFromLootTable", "causedByPlayer", "getMaxSpawnClusterSize", "getAmbientSound", "Lnet/minecraft/sounds/SoundEvent;", "getHurtSound", "getDeathSound", "getSquirtSound", "createNavigation", "Lnet/minecraft/world/entity/ai/navigation/PathNavigation;", "moistness", "getMoistness", "()I", "setMoistness", "(I)V", "size", "getSize", "setSize", "hunger", "getHunger", "setHunger", "attemptAttack", "getAttemptAttack", "setAttemptAttack", "registerControllers", "controllers", "Lsoftware/bernie/geckolib/core/animation/AnimatableManager$ControllerRegistrar;", "getAnimatableInstanceCache", "getMinSize", "getMaxSize", "fromFishingNet", "CephalopodAttackGoal", "Companion", "hybrid-aquatic-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nHybridAquaticCephalopodEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HybridAquaticCephalopodEntity.kt\ndev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticCephalopodEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,416:1\n1761#2,3:417\n*S KotlinDebug\n*F\n+ 1 HybridAquaticCephalopodEntity.kt\ndev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticCephalopodEntity\n*L\n61#1:417,3\n*E\n"})
public class HybridAquaticCephalopodEntity
extends WaterAnimal
implements GeoEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TagKey<EntityType<?>> prey;
    @NotNull
    private final List<TagKey<EntityType<?>>> predator;
    private boolean hasInk;
    private boolean hasGlowInk;
    private final AnimatableInstanceCache factory;
    private boolean fromFishingNet;
    @NotNull
    private static final EntityDataAccessor<Integer> MOISTNESS;
    @NotNull
    private static final EntityDataAccessor<Integer> CEPHALOPOD_SIZE;
    @NotNull
    private static final EntityDataAccessor<Integer> HUNGER;
    @NotNull
    private static final EntityDataAccessor<Boolean> ATTEMPT_ATTACK;
    public static final int MAX_HUNGER = 2400;
    @NotNull
    public static final String HUNGER_KEY = "Hunger";
    @NotNull
    public static final String MOISTNESS_KEY = "Moistness";
    @NotNull
    public static final String CEPHALOPOD_SIZE_KEY = "CephalopodSize";

    public HybridAquaticCephalopodEntity(@NotNull EntityType<? extends HybridAquaticCephalopodEntity> type, @NotNull Level world, @NotNull TagKey<EntityType<?>> prey, @NotNull List<TagKey<EntityType<?>>> predator, boolean hasInk, boolean hasGlowInk) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(prey, (String)"prey");
        Intrinsics.checkNotNullParameter(predator, (String)"predator");
        super(type, world);
        this.prey = prey;
        this.predator = predator;
        this.hasInk = hasInk;
        this.hasGlowInk = hasGlowInk;
        this.factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)((GeoAnimatable)this));
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = (MoveControl)new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, false);
        this.f_21365_ = (LookControl)new SmoothSwimmingLookControl((Mob)this, 10);
        this.f_21344_ = (PathNavigation)new WaterBoundPathNavigation((Mob)this, world);
    }

    @NotNull
    public TagKey<EntityType<?>> getPrey() {
        return this.prey;
    }

    @NotNull
    public List<TagKey<EntityType<?>>> getPredator() {
        return this.predator;
    }

    public boolean getHasInk() {
        return this.hasInk;
    }

    public void setHasInk(boolean bl) {
        this.hasInk = bl;
    }

    public boolean getHasGlowInk() {
        return this.hasGlowInk;
    }

    public void setHasGlowInk(boolean bl) {
        this.hasGlowInk = bl;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(2, (Goal)new CephalopodAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 8.0f, 1.0, 1.0, arg_0 -> HybridAquaticCephalopodEntity.registerGoals$lambda$1(this, arg_0)));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, true, arg_0 -> HybridAquaticCephalopodEntity.registerGoals$lambda$2(this, arg_0)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MOISTNESS, (Object)this.getMaxMoistness());
        this.f_19804_.m_135372_(CEPHALOPOD_SIZE, (Object)0);
        this.f_19804_.m_135372_(ATTEMPT_ATTACK, (Object)false);
        this.f_19804_.m_135372_(HUNGER, (Object)2400);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnReason, (String)"spawnReason");
        this.setSize(this.f_19796_.m_216332_(this.getMinSize(), this.getMaxSize()));
        this.m_146926_(0.0f);
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @NotNull
    public MobType m_6336_() {
        MobType mobType = MobType.f_21644_;
        Intrinsics.checkNotNullExpressionValue((Object)mobType, (String)"WATER");
        return mobType;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20071_()) {
            this.setMoistness(this.getMaxMoistness());
        } else {
            this.setMoistness(this.getMoistness() - 1);
            if (this.getMoistness() <= -20) {
                this.setMoistness(0);
                DamageSource damageSource = this.m_269291_().m_269483_();
                Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"dryOut(...)");
                this.m_6469_(damageSource, 1.0f);
            }
            if (!this.m_5842_()) {
                this.m_146926_(0.0f);
                this.m_146922_(this.f_19859_);
                this.f_20885_ = this.f_20886_;
            }
        }
        this.m_6858_(this.m_5912_());
        if (this.getHunger() > 0) {
            this.setHunger(this.getHunger() - 1);
        }
    }

    protected void m_6229_(int air) {
    }

    private final int getMaxMoistness() {
        return 600;
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (super.m_6469_(source, amount) && this.m_21188_() != null) {
            if (!this.m_9236_().f_46443_) {
                Vec3 attackerPos;
                if (this.m_5842_() && this.getHasInk() || this.getHasGlowInk()) {
                    this.squirt();
                }
                LivingEntity livingEntity = this.m_21188_();
                Object object = attackerPos = livingEntity != null ? livingEntity.m_20182_() : null;
                if (attackerPos != null) {
                    Vec3 directionAway = this.m_20182_().m_82546_(attackerPos).m_82541_().m_82490_(10.0);
                    Vec3 targetPos = this.m_20182_().m_82520_(directionAway.f_82479_, 0.0, directionAway.f_82481_);
                    this.f_21344_.m_26519_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 1.5);
                }
            }
            return true;
        }
        return false;
    }

    private final void squirt() {
        this.m_5496_(this.getSquirtSound(), this.m_6121_(), this.m_6100_());
        Vec3 entityPosition = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        double radius = 3.0;
        List affectedEntities = this.m_9236_().m_6443_(LivingEntity.class, new AABB(entityPosition.f_82479_ - radius, entityPosition.f_82480_ - radius, entityPosition.f_82481_ - radius, entityPosition.f_82479_ + radius, entityPosition.f_82480_ + radius, entityPosition.f_82481_ + radius), arg_0 -> HybridAquaticCephalopodEntity.squirt$lambda$4(arg_0 -> HybridAquaticCephalopodEntity.squirt$lambda$3(this, arg_0), arg_0));
        for (LivingEntity entity : affectedEntities) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 100, 0));
        }
        for (int i = 0; i < 200; ++i) {
            double offsetX = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double offsetY = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double randomMultiplier = 0.5 + this.f_19796_.m_188500_() * 1.5;
            Vec3 velocity = new Vec3(offsetX, offsetY, offsetZ).m_82541_().m_82490_(randomMultiplier);
            Level level = this.m_9236_();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ((ServerLevel)level).m_8767_((ParticleOptions)this.getInkParticle(), entityPosition.f_82479_, entityPosition.f_82480_, entityPosition.f_82481_, 1, velocity.f_82479_ * 0.25, velocity.f_82480_ * 0.25, velocity.f_82481_ * 0.25, 0.1);
        }
    }

    @NotNull
    protected SimpleParticleType getInkParticle() {
        SimpleParticleType simpleParticleType;
        if (this.getHasGlowInk()) {
            SimpleParticleType simpleParticleType2 = ParticleTypes.f_175826_;
            Intrinsics.checkNotNull((Object)simpleParticleType2);
            simpleParticleType = simpleParticleType2;
        } else {
            SimpleParticleType simpleParticleType3 = ParticleTypes.f_123765_;
            Intrinsics.checkNotNull((Object)simpleParticleType3);
            simpleParticleType = simpleParticleType3;
        }
        return simpleParticleType;
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.m_7380_(nbt);
        nbt.m_128405_(MOISTNESS_KEY, this.getMoistness());
        nbt.m_128405_(CEPHALOPOD_SIZE_KEY, this.getSize());
        nbt.m_128405_(HUNGER_KEY, this.getHunger());
        nbt.m_128379_("FromFishingNet", this.fromFishingNet);
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.m_7378_(nbt);
        this.setMoistness(nbt.m_128451_(MOISTNESS_KEY));
        this.setSize(nbt.m_128451_(CEPHALOPOD_SIZE_KEY));
        this.setHunger(nbt.m_128451_(HUNGER_KEY));
        this.fromFishingNet = nbt.m_128471_("FromFishingNet");
    }

    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions dimensions) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)dimensions, (String)"dimensions");
        return dimensions.f_20378_ * 0.5f;
    }

    public boolean m_6785_(double distanceSquared) {
        return !this.fromFishingNet && !this.m_8077_();
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        Intrinsics.checkNotNullParameter((Object)travelVector, (String)"travelVector");
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(travelVector);
        }
    }

    protected void m_7625_(@NotNull DamageSource source, boolean causedByPlayer) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Entity attacker = source.m_7640_();
        if (!(attacker instanceof HybridAquaticFishEntity || attacker instanceof HybridAquaticSharkEntity || attacker instanceof HybridAquaticCephalopodEntity || attacker instanceof HybridAquaticMammalEntity)) {
            super.m_7625_(source, causedByPlayer);
        }
    }

    public int m_5792_() {
        return 1;
    }

    @NotNull
    protected SoundEvent m_7515_() {
        SoundEvent soundEvent = SoundEvents.f_12438_;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"SQUID_AMBIENT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        SoundEvent soundEvent = SoundEvents.f_12440_;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"SQUID_HURT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent m_5592_() {
        SoundEvent soundEvent = SoundEvents.f_12439_;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"SQUID_DEATH");
        return soundEvent;
    }

    private final SoundEvent getSquirtSound() {
        SoundEvent soundEvent = SoundEvents.f_12441_;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"SQUID_SQUIRT");
        return soundEvent;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return (PathNavigation)new WaterBoundPathNavigation((Mob)this, world);
    }

    private final int getMoistness() {
        Object object = this.f_19804_.m_135370_(MOISTNESS);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    private final void setMoistness(int moistness) {
        this.f_19804_.m_135381_(MOISTNESS, (Object)moistness);
    }

    public final int getSize() {
        Object object = this.f_19804_.m_135370_(CEPHALOPOD_SIZE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setSize(int size) {
        this.f_19804_.m_135381_(CEPHALOPOD_SIZE, (Object)size);
    }

    public final int getHunger() {
        Object object = this.f_19804_.m_135370_(HUNGER);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setHunger(int hunger) {
        this.f_19804_.m_135381_(HUNGER, (Object)hunger);
    }

    private final boolean getAttemptAttack() {
        Object object = this.f_19804_.m_135370_(ATTEMPT_ATTACK);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final void setAttemptAttack(boolean attemptAttack) {
        this.f_19804_.m_135381_(ATTEMPT_ATTACK, (Object)attemptAttack);
    }

    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllers) {
        Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
        AnimationController[] animationControllerArray = new AnimationController[]{new AnimationController((GeoAnimatable)this, "Swim/Idle", 10, HybridAquaticCephalopodEntity::registerControllers$lambda$5)};
        controllers.add(animationControllerArray);
        animationControllerArray = new AnimationController[]{new AnimationController((GeoAnimatable)this, "Sit", 10, arg_0 -> HybridAquaticCephalopodEntity.registerControllers$lambda$6(this, arg_0))};
        controllers.add(animationControllerArray);
    }

    @NotNull
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        AnimatableInstanceCache animatableInstanceCache = this.factory;
        Intrinsics.checkNotNullExpressionValue((Object)animatableInstanceCache, (String)"factory");
        return animatableInstanceCache;
    }

    protected int getMinSize() {
        return 0;
    }

    protected int getMaxSize() {
        return 3;
    }

    private static final boolean registerGoals$lambda$1(HybridAquaticCephalopodEntity this$0, LivingEntity entity) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Iterable $this$any$iv = this$0.getPredator();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TagKey predatorTag = (TagKey)element$iv;
                    boolean bl2 = false;
                    if (!entity.m_6095_().m_204039_(predatorTag)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean registerGoals$lambda$2(HybridAquaticCephalopodEntity this$0, LivingEntity it) {
        return this$0.getHunger() <= 1200 && it.m_6095_().m_204039_(this$0.getPrey());
    }

    private static final boolean squirt$lambda$3(HybridAquaticCephalopodEntity this$0, LivingEntity it) {
        return !Intrinsics.areEqual((Object)it, (Object)((Object)this$0)) && it.m_6084_();
    }

    private static final boolean squirt$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final PlayState registerControllers$lambda$5(AnimationState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state.setAndContinue(state.isMoving() ? DefaultAnimations.SWIM : DefaultAnimations.IDLE);
    }

    private static final PlayState registerControllers$lambda$6(HybridAquaticCephalopodEntity this$0, AnimationState state) {
        PlayState playState;
        if (this$0.m_20096_()) {
            state.setAndContinue(DefaultAnimations.SIT);
            playState = PlayState.CONTINUE;
        } else {
            playState = PlayState.STOP;
        }
        return playState;
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.m_135353_(HybridAquaticCephalopodEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        MOISTNESS = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.m_135353_(HybridAquaticCephalopodEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        CEPHALOPOD_SIZE = entityDataAccessor2;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.m_135353_(HybridAquaticCephalopodEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(...)");
        HUNGER = entityDataAccessor3;
        EntityDataAccessor entityDataAccessor4 = SynchedEntityData.m_135353_(HybridAquaticCephalopodEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor4, (String)"defineId(...)");
        ATTEMPT_ATTACK = entityDataAccessor4;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0014J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticCephalopodEntity$CephalopodAttackGoal;", "Lnet/minecraft/world/entity/ai/goal/MeleeAttackGoal;", "cephalopod", "Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticCephalopodEntity;", "<init>", "(Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticCephalopodEntity;)V", "canUse", "", "checkAndPerformAttack", "", "target", "Lnet/minecraft/world/entity/LivingEntity;", "squaredDistance", "", "getAttackReachSqr", "entity", "start", "stop", "hybrid-aquatic-forge-1.20.1"})
    public static final class CephalopodAttackGoal
    extends MeleeAttackGoal {
        @NotNull
        private final HybridAquaticCephalopodEntity cephalopod;

        public CephalopodAttackGoal(@NotNull HybridAquaticCephalopodEntity cephalopod) {
            Intrinsics.checkNotNullParameter((Object)((Object)cephalopod), (String)"cephalopod");
            super((PathfinderMob)cephalopod, 1.0, true);
            this.cephalopod = cephalopod;
        }

        public boolean m_8036_() {
            return !this.cephalopod.fromFishingNet && super.m_8036_();
        }

        protected void m_6739_(@NotNull LivingEntity target, double squaredDistance) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            double d = this.m_6639_(target);
            if (squaredDistance <= d && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)target);
                this.cephalopod.m_6858_(true);
                this.cephalopod.setAttemptAttack(true);
                if (target.m_21223_() <= 0.0f) {
                    this.cephalopod.setHunger(2400);
                }
                this.cephalopod.m_21153_(this.cephalopod.m_21233_());
            }
        }

        protected double m_6639_(@NotNull LivingEntity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return 1.25f + entity.m_20205_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.cephalopod.setAttemptAttack(false);
        }

        public void m_8041_() {
            super.m_8041_();
            this.cephalopod.setAttemptAttack(false);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0015\u001a\u00020\u000e2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J6\u0010!\u001a\u00020\u000e2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020#R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticCephalopodEntity$Companion;", "", "<init>", "()V", "MOISTNESS", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getMOISTNESS", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "CEPHALOPOD_SIZE", "getCEPHALOPOD_SIZE", "HUNGER", "getHUNGER", "ATTEMPT_ATTACK", "", "getATTEMPT_ATTACK", "MAX_HUNGER", "HUNGER_KEY", "", "MOISTNESS_KEY", "CEPHALOPOD_SIZE_KEY", "canSpawn", "type", "Lnet/minecraft/world/entity/EntityType;", "Lnet/minecraft/world/entity/animal/WaterAnimal;", "world", "Lnet/minecraft/world/level/ServerLevelAccessor;", "reason", "Lnet/minecraft/world/entity/MobSpawnType;", "pos", "Lnet/minecraft/core/BlockPos;", "random", "Lnet/minecraft/util/RandomSource;", "canDeepSpawn", "getScaleAdjustment", "", "cephalopod", "Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticCephalopodEntity;", "adjustment", "hybrid-aquatic-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Integer> getMOISTNESS() {
            return MOISTNESS;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getCEPHALOPOD_SIZE() {
            return CEPHALOPOD_SIZE;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getHUNGER() {
            return HUNGER;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getATTEMPT_ATTACK() {
            return ATTEMPT_ATTACK;
        }

        public final boolean canSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            int topY = world.m_5736_() - 4;
            int bottomY = world.m_5736_() - 24;
            int n = pos.m_123342_();
            return (bottomY <= n ? n <= topY : false) && world.m_46801_(pos) && world.m_46861_(pos) && !Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random);
        }

        public final boolean canDeepSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            int topY = world.m_5736_() - 48;
            int bottomY = world.m_5736_() - 128;
            int n = pos.m_123342_();
            return (bottomY <= n ? n <= topY : false) && world.m_46801_(pos) && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random);
        }

        public final float getScaleAdjustment(@NotNull HybridAquaticCephalopodEntity cephalopod, float adjustment) {
            Intrinsics.checkNotNullParameter((Object)((Object)cephalopod), (String)"cephalopod");
            return 1.0f + (float)cephalopod.getSize() * adjustment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

