/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.miniboss;

import dev.hybridlabs.aquatic.entity.HybridAquaticEntityTypes;
import dev.hybridlabs.aquatic.entity.ai.goal.KarkinosMeleeAttackGoal;
import dev.hybridlabs.aquatic.entity.ai.goal.KarkinosSummonGoal;
import dev.hybridlabs.aquatic.entity.miniboss.HybridAquaticMinibossEntity;
import dev.hybridlabs.aquatic.entity.miniboss.KarcinogenEntity;
import dev.hybridlabs.aquatic.entity.miniboss.KarcinomaEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 C2\u00020\u0001:\u0002CDB\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\tH\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0014J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020\u0019H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0006\u0010%\u001a\u00020\u0014J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0014H\u0002J\u0006\u0010(\u001a\u00020\u0014J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u0014H\u0002J\u0006\u0010+\u001a\u00020\u0019J\u0006\u0010,\u001a\u00020\u0019J\b\u0010-\u001a\u00020\u0019H\u0002J\b\u0010.\u001a\u00020\u0019H\u0002J\b\u0010/\u001a\u00020\u0019H\u0014J\u0010\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u00192\u0006\u00101\u001a\u000202H\u0016J\b\u00104\u001a\u00020\u0019H\u0016J\b\u00105\u001a\u00020\u0019H\u0016J\u0018\u00106\u001a\u00020\u00142\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0012H\u0016J\u0012\u0010:\u001a\u00020\u00192\b\u0010;\u001a\u0004\u0018\u00010<H\u0016J\u0010\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020A2\u0006\u00107\u001a\u000208H\u0014J\b\u0010B\u001a\u00020AH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Ldev/hybridlabs/aquatic/entity/miniboss/KarkinosEntity;", "Ldev/hybridlabs/aquatic/entity/miniboss/HybridAquaticMinibossEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "flippedTimer", "", "flippedCooldown", "summonTimer", "summonCooldown", "getSummonCooldown", "()I", "setSummonCooldown", "(I)V", "maxUpStep", "", "isAffectedByFluids", "", "isPushedByFluid", "bossBar", "Lnet/minecraft/server/level/ServerBossEvent;", "registerGoals", "", "getHandSwingDuration", "updateSwingTime", "getAttackAnim", "tickDelta", "startSeenByPlayer", "player", "Lnet/minecraft/server/level/ServerPlayer;", "stopSeenByPlayer", "checkDespawn", "getMobType", "Lnet/minecraft/world/entity/MobType;", "isFlipped", "setFlipped", "flipped", "isSummoning", "setSummoning", "summon", "startSummoning", "stopSummoning", "summonKarcinogens", "summonKarcinomas", "defineSynchedData", "addAdditionalSaveData", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "tick", "aiStep", "hurt", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "setCustomName", "name", "Lnet/minecraft/network/chat/Component;", "registerControllers", "controllers", "Lsoftware/bernie/geckolib/core/animation/AnimatableManager$ControllerRegistrar;", "getHurtSound", "Lnet/minecraft/sounds/SoundEvent;", "getDeathSound", "Companion", "KarkinosMoveControl", "hybrid-aquatic-forge-1.20.1"})
public final class KarkinosEntity
extends HybridAquaticMinibossEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int flippedTimer;
    private int flippedCooldown;
    private int summonTimer;
    private int summonCooldown;
    @NotNull
    private ServerBossEvent bossBar;
    @NotNull
    private static final RawAnimation FLIP_ANIMATION;
    @NotNull
    private static final RawAnimation SUMMON_ANIMATION;
    @NotNull
    private static final EntityDataAccessor<Boolean> FLIPPED;
    @NotNull
    private static final EntityDataAccessor<Boolean> SUMMONING;

    public KarkinosEntity(@NotNull EntityType<? extends HybridAquaticMinibossEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new KarkinosMoveControl(this);
        this.f_21344_ = (PathNavigation)new GroundPathNavigation((Mob)this, world);
        this.f_21365_ = new LookControl((Mob)this);
        this.bossBar = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_20);
    }

    public final int getSummonCooldown() {
        return this.summonCooldown;
    }

    public final void setSummonCooldown(int n) {
        this.summonCooldown = n;
    }

    public float m_274421_() {
        return 1.5f;
    }

    protected boolean m_6129_() {
        return false;
    }

    @Override
    public boolean m_6063_() {
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new KarkinosSummonGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new KarkinosMeleeAttackGoal(this, 0.5, true));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 16.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, true, null));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, 10, true, true, null));
    }

    private final int getHandSwingDuration() {
        return 40;
    }

    protected void m_21203_() {
        int i = this.getHandSwingDuration();
        if (this.f_20911_) {
            ++this.f_20913_;
            if (this.f_20913_ >= i) {
                this.f_20913_ = 0;
                this.f_20911_ = false;
            }
        } else {
            this.f_20913_ = 0;
        }
        this.f_20921_ = (float)this.f_20913_ / (float)i;
    }

    public float m_21324_(float tickDelta) {
        float f = this.f_20921_ - this.f_20920_;
        if (f < 0.0f) {
            f += 1.0f;
        }
        return this.f_20920_ + f * tickDelta;
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.m_6457_(player);
        this.bossBar.m_6543_(player);
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.m_6452_(player);
        this.bossBar.m_6539_(player);
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    @NotNull
    public MobType m_6336_() {
        MobType mobType = MobType.f_21644_;
        Intrinsics.checkNotNullExpressionValue((Object)mobType, (String)"WATER");
        return mobType;
    }

    public final boolean isFlipped() {
        Object object = this.f_19804_.m_135370_(FLIPPED);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final void setFlipped(boolean flipped) {
        if (flipped && this.m_21223_() <= this.m_21233_() / 2.0f) {
            return;
        }
        this.f_19804_.m_135381_(FLIPPED, (Object)flipped);
    }

    public final boolean isSummoning() {
        Object object = this.f_19804_.m_135370_(SUMMONING);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final void setSummoning(boolean summon) {
        this.f_19804_.m_135381_(SUMMONING, (Object)summon);
    }

    public final void startSummoning() {
        this.setSummoning(true);
        this.m_5496_(SoundEvents.f_11867_, 1.0f, 1.0f);
        this.summonTimer = 30;
        this.summonCooldown = 240;
        this.f_21344_.m_26573_();
    }

    public final void stopSummoning() {
        this.setSummoning(false);
        this.summonTimer = 0;
        this.summonCooldown = 300;
    }

    private final void summonKarcinogens() {
        RandomSource random = this.f_19796_;
        int count = 3;
        for (int i = 0; i < count; ++i) {
            double offsetX = (random.m_188500_() - 0.5) * 6.0;
            double offsetZ = (random.m_188500_() - 0.5) * 6.0;
            BlockPos spawnPos = this.m_20183_().m_7918_((int)offsetX, 0, (int)offsetZ);
            KarcinogenEntity karcinogen = (KarcinogenEntity)HybridAquaticEntityTypes.INSTANCE.getKARCINOGEN().get().m_20615_(this.m_9236_());
            if (karcinogen == null) continue;
            karcinogen.m_7678_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, random.m_188501_() * 360.0f, 0.0f);
            karcinogen.setOwner((Mob)this);
            karcinogen.setLimitedLife(200);
            this.m_9236_().m_7967_((Entity)karcinogen);
        }
    }

    private final void summonKarcinomas() {
        RandomSource random = this.f_19796_;
        int count = 3;
        for (int i = 0; i < count; ++i) {
            double offsetX = (random.m_188500_() - 0.5) * 6.0;
            double offsetZ = (random.m_188500_() - 0.5) * 6.0;
            BlockPos spawnPos = this.m_20183_().m_7918_((int)offsetX, 0, (int)offsetZ);
            KarcinomaEntity karcinoma = (KarcinomaEntity)HybridAquaticEntityTypes.INSTANCE.getKARCINOMA().get().m_20615_(this.m_9236_());
            if (karcinoma == null) continue;
            karcinoma.m_7678_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, random.m_188501_() * 360.0f, 0.0f);
            karcinoma.setOwner((Mob)this);
            karcinoma.setLimitedLife(400);
            this.m_9236_().m_7967_((Entity)karcinoma);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLIPPED, (Object)false);
        this.f_19804_.m_135372_(SUMMONING, (Object)false);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.m_128379_("Flipped", this.isFlipped());
        nbt.m_128379_("Summoning", this.isSummoning());
        nbt.m_128405_("SummonTimer", this.summonTimer);
        nbt.m_128405_("SummonCooldown", this.summonCooldown);
        super.m_7380_(nbt);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        if (this.m_8077_()) {
            this.bossBar.m_6456_(this.m_5446_());
        }
        this.setFlipped(nbt.m_128471_("Flipped"));
        this.setSummoning(nbt.m_128471_("Summoning"));
        this.summonTimer = nbt.m_128451_("SummonTimer");
        this.summonCooldown = nbt.m_128451_("SummonCooldown");
        super.m_7378_(nbt);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20069_() && !this.m_20096_()) {
            this.m_20282_(false);
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.1, 0.0));
            this.f_21344_.m_26573_();
        }
    }

    @Override
    public void m_8107_() {
        int n;
        if (!this.m_9236_().f_46443_ && this.m_21515_()) {
            if (this.isFlipped()) {
                this.flippedTimer += -1;
                if (this.flippedTimer <= 0) {
                    this.setFlipped(false);
                } else {
                    this.m_20256_(this.m_20184_().m_82542_(0.0, 0.0, 0.0));
                    this.f_20885_ = 0.0f;
                }
            }
            if (this.flippedCooldown > 0) {
                n = this.flippedCooldown;
                this.flippedCooldown = n + -1;
            }
        }
        if (this.summonCooldown > 0) {
            n = this.summonCooldown;
            this.summonCooldown = n + -1;
        }
        if (this.isSummoning()) {
            n = this.summonTimer;
            this.summonTimer = n + -1;
            if (this.summonTimer == 0) {
                if (this.m_5842_()) {
                    this.summonKarcinomas();
                    this.summonKarcinogens();
                } else {
                    this.summonKarcinogens();
                }
                this.stopSummoning();
            }
        }
        this.bossBar.m_142711_(this.m_21223_() / this.m_21233_());
        super.m_8107_();
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        boolean result = super.m_6469_(source, amount);
        if (result && !this.m_9236_().f_46443_ && source.m_7640_() instanceof Player && !this.isFlipped() && this.flippedCooldown <= 0 && this.m_21223_() > this.m_21233_() / 2.0f) {
            boolean hasFlipEnchant;
            Entity entity = source.m_7640_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)entity;
            ItemStack weapon = player.m_21205_();
            boolean bl = hasFlipEnchant = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44979_, (ItemStack)weapon) > 1 || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44957_, (ItemStack)weapon) > 1;
            if (hasFlipEnchant) {
                this.flippedTimer = this.f_19796_.m_216339_(60, 100);
                this.flippedCooldown = 200;
                this.setFlipped(true);
            }
        }
        return result;
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossBar.m_6456_(this.m_5446_());
    }

    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllers) {
        Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
        AnimationController[] animationControllerArray = new AnimationController[]{new AnimationController((GeoAnimatable)this, "flip_controller", 8, arg_0 -> KarkinosEntity.registerControllers$lambda$0(this, arg_0))};
        controllers.add(animationControllerArray);
        animationControllerArray = new AnimationController[]{new AnimationController((GeoAnimatable)this, "summon_controller", 4, arg_0 -> KarkinosEntity.registerControllers$lambda$1(this, arg_0))};
        controllers.add(animationControllerArray);
        animationControllerArray = new AnimationController[]{DefaultAnimations.genericWalkRunIdleController((Entity)((Entity)this))};
        controllers.add(animationControllerArray);
        animationControllerArray = new AnimationController[]{DefaultAnimations.genericAttackAnimation((LivingEntity)((LivingEntity)this), (RawAnimation)DefaultAnimations.ATTACK_SWING)};
        controllers.add(animationControllerArray);
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        SoundEvent soundEvent = SoundEvents.f_12534_;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"TURTLE_EGG_CRACK");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent m_5592_() {
        SoundEvent soundEvent = SoundEvents.f_12533_;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"TURTLE_EGG_BREAK");
        return soundEvent;
    }

    private static final PlayState registerControllers$lambda$0(KarkinosEntity this$0, AnimationState state) {
        PlayState playState;
        if (this$0.isFlipped()) {
            state.setAndContinue(FLIP_ANIMATION);
            playState = PlayState.CONTINUE;
        } else {
            playState = PlayState.STOP;
        }
        return playState;
    }

    private static final PlayState registerControllers$lambda$1(KarkinosEntity this$0, AnimationState state) {
        PlayState playState;
        if (this$0.isSummoning()) {
            state.setAndContinue(SUMMON_ANIMATION);
            playState = PlayState.CONTINUE;
        } else {
            playState = PlayState.STOP;
        }
        return playState;
    }

    static {
        RawAnimation rawAnimation = RawAnimation.begin().thenPlay("misc.flip");
        Intrinsics.checkNotNullExpressionValue((Object)rawAnimation, (String)"thenPlay(...)");
        FLIP_ANIMATION = rawAnimation;
        RawAnimation rawAnimation2 = RawAnimation.begin().thenPlay("misc.summon");
        Intrinsics.checkNotNullExpressionValue((Object)rawAnimation2, (String)"thenPlay(...)");
        SUMMON_ANIMATION = rawAnimation2;
        EntityDataAccessor entityDataAccessor = SynchedEntityData.m_135353_(KarkinosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        FLIPPED = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.m_135353_(KarkinosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        SUMMONING = entityDataAccessor2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0013"}, d2={"Ldev/hybridlabs/aquatic/entity/miniboss/KarkinosEntity$Companion;", "", "<init>", "()V", "FLIP_ANIMATION", "Lsoftware/bernie/geckolib/core/animation/RawAnimation;", "getFLIP_ANIMATION", "()Lsoftware/bernie/geckolib/core/animation/RawAnimation;", "SUMMON_ANIMATION", "getSUMMON_ANIMATION", "createMobAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "FLIPPED", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getFLIPPED", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "SUMMONING", "getSUMMONING", "hybrid-aquatic-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RawAnimation getFLIP_ANIMATION() {
            return FLIP_ANIMATION;
        }

        @NotNull
        public final RawAnimation getSUMMON_ANIMATION() {
            return SUMMON_ANIMATION;
        }

        @NotNull
        public final AttributeSupplier.Builder createMobAttributes() {
            AttributeSupplier.Builder builder = Monster.m_21183_().m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 1.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getFLIPPED() {
            return FLIPPED;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getSUMMONING() {
            return SUMMONING;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldev/hybridlabs/aquatic/entity/miniboss/KarkinosEntity$KarkinosMoveControl;", "Lnet/minecraft/world/entity/ai/control/MoveControl;", "karkinos", "Ldev/hybridlabs/aquatic/entity/miniboss/KarkinosEntity;", "<init>", "(Ldev/hybridlabs/aquatic/entity/miniboss/KarkinosEntity;)V", "tick", "", "hybrid-aquatic-forge-1.20.1"})
    public static final class KarkinosMoveControl
    extends MoveControl {
        @NotNull
        private final KarkinosEntity karkinos;

        public KarkinosMoveControl(@NotNull KarkinosEntity karkinos) {
            Intrinsics.checkNotNullParameter((Object)((Object)karkinos), (String)"karkinos");
            super((Mob)karkinos);
            this.karkinos = karkinos;
        }

        public void m_8126_() {
            if (!this.karkinos.isFlipped() && !this.karkinos.isSummoning()) {
                super.m_8126_();
            }
        }
    }
}

