/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.item;

import dev.hybridlabs.aquatic.tag.HybridAquaticEntityTags;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0016"}, d2={"Ldev/hybridlabs/aquatic/item/FishingNetItem;", "Lnet/minecraft/world/item/Item;", "settings", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "interactLivingEntity", "Lnet/minecraft/world/InteractionResult;", "stack", "Lnet/minecraft/world/item/ItemStack;", "user", "Lnet/minecraft/world/entity/player/Player;", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "hand", "Lnet/minecraft/world/InteractionHand;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "level", "Lnet/minecraft/world/level/Level;", "player", "Companion", "hybrid-aquatic-forge-1.20.1"})
public final class FishingNetItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ENTITY_KEY = "storedEntity";

    public FishingNetItem(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, @NotNull Player user, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        boolean validFishForNet = entity.m_6095_().m_204039_(HybridAquaticEntityTags.INSTANCE.getCAN_USE_FISHING_NET_ON());
        if (!Companion.alreadyHasFish(stack) && validFishForNet) {
            Companion.writeEntityToNet((Entity)entity, user, hand);
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.m_6880_(stack, user, entity, hand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"interactLivingEntity(...)");
        return interactionResult;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            Optional<EntityType<?>> optionalEntity;
            CompoundTag nbtCopy;
            CompoundTag compoundTag = stack.m_41783_();
            Object object = nbtCopy = compoundTag != null ? compoundTag.m_6426_() : null;
            if (nbtCopy != null && (optionalEntity = Companion.getEntityFromNBT(nbtCopy)).isPresent()) {
                BlockHitResult hitResult = Item.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
                if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
                    InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19098_((Object)stack);
                    Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
                    return interactionResultHolder;
                }
                BlockPos pos = hitResult.m_82425_();
                Direction clickedFace = hitResult.m_82434_();
                BlockPos spawnPos = pos.m_121945_(clickedFace);
                FluidState fluidState = level.m_6425_(pos);
                if (fluidState.m_192917_((Fluid)Fluids.f_76193_)) {
                    spawnPos = pos;
                }
                EntityType<?> entityType = optionalEntity.get();
                Intrinsics.checkNotNullExpressionValue(entityType, (String)"get(...)");
                EntityType<?> entityType2 = entityType;
                Entity entity = entityType2.m_20615_(level);
                if (entity == null) {
                    InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19100_((Object)stack);
                    Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                    return interactionResultHolder;
                }
                Entity entity2 = entity;
                CompoundTag compoundTag2 = stack.m_41783_();
                if (compoundTag2 == null) {
                    InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19100_((Object)stack);
                    Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                    return interactionResultHolder;
                }
                CompoundTag tag = compoundTag2;
                CompoundTag entityData = tag.m_128469_(ENTITY_KEY);
                entity2.m_20258_(entityData);
                entity2.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 0.1, (double)spawnPos.m_123343_() + 0.5, level.f_46441_.m_188501_() * 360.0f, 0.0f);
                ((ServerLevel)level).m_7967_(entity2);
                CompoundTag compoundTag3 = stack.m_41783_();
                if (compoundTag3 != null) {
                    compoundTag3.m_128473_(ENTITY_KEY);
                }
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19090_((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
                return interactionResultHolder;
            }
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.m_19098_((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
        return interactionResultHolder;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/hybridlabs/aquatic/item/FishingNetItem$Companion;", "", "<init>", "()V", "ENTITY_KEY", "", "writeEntityToNet", "", "entity", "Lnet/minecraft/world/entity/Entity;", "user", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "getEntityFromNBT", "Ljava/util/Optional;", "Lnet/minecraft/world/entity/EntityType;", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "alreadyHasFish", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "hybrid-aquatic-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void writeEntityToNet(@NotNull Entity entity, @NotNull Player user, @NotNull InteractionHand hand) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
            CompoundTag entityCompound = new CompoundTag();
            entity.m_20223_(entityCompound);
            entityCompound.m_128379_("PersistenceRequired", true);
            entityCompound.m_128379_("FromFishingNet", true);
            ItemStack itemStack = user.m_21120_(hand);
            itemStack.m_41784_().m_128365_(FishingNetItem.ENTITY_KEY, (Tag)entityCompound);
        }

        @NotNull
        public final Optional<EntityType<?>> getEntityFromNBT(@NotNull CompoundTag nbt) {
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            CompoundTag storedNBT = nbt.m_128469_(FishingNetItem.ENTITY_KEY);
            Optional optional = EntityType.m_20637_((CompoundTag)storedNBT);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"by(...)");
            return optional;
        }

        public final boolean alreadyHasFish(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            CompoundTag compoundTag = stack.m_41783_();
            if (compoundTag == null || (compoundTag = compoundTag.m_6426_()) == null) {
                return false;
            }
            CompoundTag nbtCopy = compoundTag;
            CompoundTag compoundTag2 = nbtCopy.m_128469_(FishingNetItem.ENTITY_KEY);
            if (compoundTag2 == null) {
                return false;
            }
            CompoundTag entityNBT = compoundTag2;
            return !entityNBT.m_128456_();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

