/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.mixin;

import com.google.common.collect.ImmutableList;
import dev.hybridlabs.aquatic.access.CustomPlayerEntityData;
import dev.hybridlabs.aquatic.effect.HybridAquaticMobEffects;
import dev.hybridlabs.aquatic.entity.shark.HybridAquaticSharkEntity;
import dev.hybridlabs.aquatic.item.HybridAquaticItems;
import dev.hybridlabs.aquatic.item.HybridAquaticToolMaterials;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends Entity
implements CustomPlayerEntityData {
    @Unique
    private int haHurtTime = 0;
    @Unique
    private boolean isWearingDivingBoots;
    @Unique
    int coralRepairTick = 0;

    public PlayerEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract boolean m_6069_();

    @Override
    public void hybrid_aquatic$setHurtTime(int value) {
        this.haHurtTime = value;
    }

    @Override
    public int hybrid_aquatic$getHurtTime() {
        return this.haHurtTime;
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbt(CompoundTag nbt, CallbackInfo ci) {
        this.hybrid_aquatic$setHurtTime(nbt.m_128451_("haHurtTime"));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbt(CompoundTag nbt, CallbackInfo ci) {
        nbt.m_128405_("haHurtTime", this.hybrid_aquatic$getHurtTime());
    }

    @Inject(method={"isAffectedByFluids"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideShouldSwimInFluids(CallbackInfoReturnable<Boolean> ci) {
        if (this.isWearingDivingBoots && !this.m_6069_() && this.m_5842_()) {
            ci.setReturnValue((Object)false);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;level()Lnet/minecraft/world/level/Level;", ordinal=0, shift=At.Shift.BEFORE)})
    private void setCustomHurtTimeOnDamage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity foundEntity;
        Player object = (Player)this;
        if (object.m_20069_() && (foundEntity = object.m_9236_().m_45963_(HybridAquaticSharkEntity.class, TargetingConditions.m_148353_().m_26883_(32.0).m_26888_(Entity::m_5842_), (LivingEntity)object, object.m_20185_(), object.m_20188_(), object.m_20189_(), object.m_20191_().m_82400_(16.0))) != null) {
            this.hybrid_aquatic$setHurtTime(200);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tickDownCustomHurtTime(CallbackInfo ci) {
        int cHurtTime = this.hybrid_aquatic$getHurtTime();
        if (cHurtTime > 0) {
            this.hybrid_aquatic$setHurtTime(cHurtTime - 1);
        }
        this.updateDivingHelmet();
        this.updateDivingBoots();
        this.updateTurtleChestplate();
        this.repairCoralTools();
    }

    @Unique
    private void updateDivingHelmet() {
        Player player = (Player)this;
        ItemStack itemStack = player.m_6844_(EquipmentSlot.HEAD);
        if (itemStack.m_150930_(HybridAquaticItems.INSTANCE.getDIVING_HELMET().get())) {
            if (!player.m_204029_(FluidTags.f_13131_)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 600, 0, false, false, false));
            } else {
                player.m_7292_(new MobEffectInstance(HybridAquaticMobEffects.INSTANCE.getCLARITY().get(), 600, 0, false, false, false));
            }
        }
    }

    @Unique
    private void updateDivingBoots() {
        Player player = (Player)this;
        ItemStack itemStack = player.m_6844_(EquipmentSlot.FEET);
        this.isWearingDivingBoots = itemStack.m_150930_(HybridAquaticItems.INSTANCE.getDIVING_BOOTS().get());
    }

    @Unique
    private void updateTurtleChestplate() {
        Player player = (Player)this;
        ItemStack itemStack = player.m_6844_(EquipmentSlot.CHEST);
        if (itemStack.m_150930_(HybridAquaticItems.INSTANCE.getTURTLE_CHESTPLATE().get())) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 0, false, false, true));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 0, false, false, true));
        }
    }

    @Unique
    private void repairCoralTools() {
        Player player = (Player)this;
        Inventory inventory = player.m_150109_();
        if (player.m_204029_(FluidTags.f_13131_)) {
            if (this.coralRepairTick > 5) {
                ImmutableList combinedInventory = ImmutableList.of((Object)inventory.f_35974_, (Object)inventory.f_35976_);
                ArrayList<ItemStack> coralItems = new ArrayList<ItemStack>();
                for (List list : combinedInventory) {
                    for (ItemStack itemStack : list) {
                        TieredItem tool;
                        Item item = itemStack.m_41720_();
                        if (!(item instanceof TieredItem) || (tool = (TieredItem)item).m_43314_() != HybridAquaticToolMaterials.CORAL || !itemStack.m_41768_()) continue;
                        coralItems.add(itemStack);
                    }
                }
                if (!coralItems.isEmpty()) {
                    ItemStack item = (ItemStack)coralItems.get(player.m_217043_().m_188503_(coralItems.size()));
                    item.m_41721_(item.m_41773_() - 1);
                    inventory.m_6596_();
                }
                this.coralRepairTick = 0;
            }
            ++this.coralRepairTick;
        }
    }
}

