/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.network;

import dev.hybridlabs.aquatic.CommonClass;
import dev.hybridlabs.aquatic.access.CustomFishingBobberEntityData;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.game.ServerPacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001dJ\u001e\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Ldev/hybridlabs/aquatic/network/HybridAquaticNetworking;", "", "<init>", "()V", "PROTOCOL_VERSION", "", "CHANNEL", "Lnet/minecraftforge/network/simple/SimpleChannel;", "getCHANNEL", "()Lnet/minecraftforge/network/simple/SimpleChannel;", "messageId", "", "getMessageId", "()I", "setMessageId", "(I)V", "registerPackets", "", "sendHookPacket", "entityId", "entityData", "Lnet/minecraft/world/item/ItemStack;", "sendClientHookPacket", "player", "Lnet/minecraft/server/level/ServerPlayer;", "handle", "msg", "Ldev/hybridlabs/aquatic/network/HybridAquaticNetworking$HookPacket;", "ctx", "Ljava/util/function/Supplier;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "handleHookPacket", "packet", "HookPacket", "hybrid-aquatic-forge-1.20.1"})
public final class HybridAquaticNetworking {
    @NotNull
    public static final HybridAquaticNetworking INSTANCE = new HybridAquaticNetworking();
    @NotNull
    private static final String PROTOCOL_VERSION = "1";
    @NotNull
    private static final SimpleChannel CHANNEL;
    private static int messageId;

    private HybridAquaticNetworking() {
    }

    @NotNull
    public final SimpleChannel getCHANNEL() {
        return CHANNEL;
    }

    public final int getMessageId() {
        return messageId;
    }

    public final void setMessageId(int n) {
        messageId = n;
    }

    public final void registerPackets() {
        int n = messageId;
        messageId = n + 1;
        CHANNEL.registerMessage(n, HookPacket.class, HybridAquaticNetworking::registerPackets$lambda$3, HybridAquaticNetworking::registerPackets$lambda$4, HybridAquaticNetworking::registerPackets$lambda$5);
    }

    public final void sendHookPacket(int entityId, @NotNull ItemStack entityData) {
        Intrinsics.checkNotNullParameter((Object)entityData, (String)"entityData");
        CHANNEL.sendToServer((Object)new HookPacket(entityId, entityData));
    }

    public final void sendClientHookPacket(@Nullable ServerPlayer player, int entityId, @NotNull ItemStack entityData) {
        Intrinsics.checkNotNullParameter((Object)entityData, (String)"entityData");
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> HybridAquaticNetworking.sendClientHookPacket$lambda$6(player)), (Object)new HookPacket(entityId, entityData));
    }

    public final void handle(@NotNull HookPacket msg, @NotNull Supplier<NetworkEvent.Context> ctx) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        NetworkEvent.Context context = ctx.get();
        Intrinsics.checkNotNull((Object)context);
        context.enqueueWork(() -> HybridAquaticNetworking.handle$lambda$7(msg, ctx));
        NetworkEvent.Context context2 = ctx.get();
        Intrinsics.checkNotNull((Object)context2);
        context2.setPacketHandled(true);
    }

    public final void handleHookPacket(@NotNull HookPacket packet, @NotNull Supplier<NetworkEvent.Context> ctx) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        NetworkEvent.Context context = ctx.get();
        Intrinsics.checkNotNull((Object)context);
        PacketListener listener = context.getNetworkManager().m_129538_();
        if (listener instanceof ServerPacketListener) {
            NetworkEvent.Context context2 = ctx.get();
            Intrinsics.checkNotNull((Object)context2);
            context2.enqueueWork(() -> HybridAquaticNetworking.handleHookPacket$lambda$8(ctx, packet));
        } else if (listener instanceof ClientPacketListener) {
            NetworkEvent.Context context3 = ctx.get();
            Intrinsics.checkNotNull((Object)context3);
            context3.enqueueWork(() -> HybridAquaticNetworking.handleHookPacket$lambda$9(packet));
        }
    }

    private static final String CHANNEL$lambda$0() {
        return PROTOCOL_VERSION;
    }

    private static final boolean CHANNEL$lambda$1(String anObject) {
        return Intrinsics.areEqual((Object)PROTOCOL_VERSION, (Object)anObject);
    }

    private static final boolean CHANNEL$lambda$2(String anObject) {
        return Intrinsics.areEqual((Object)PROTOCOL_VERSION, (Object)anObject);
    }

    private static final void registerPackets$lambda$3(HookPacket obj, FriendlyByteBuf buffer) {
        HookPacket hookPacket = obj;
        Intrinsics.checkNotNull((Object)hookPacket);
        FriendlyByteBuf friendlyByteBuf = buffer;
        Intrinsics.checkNotNull((Object)friendlyByteBuf);
        hookPacket.encoder(friendlyByteBuf);
    }

    private static final HookPacket registerPackets$lambda$4(FriendlyByteBuf buffer) {
        FriendlyByteBuf friendlyByteBuf = buffer;
        Intrinsics.checkNotNull((Object)friendlyByteBuf);
        return new HookPacket(friendlyByteBuf);
    }

    private static final void registerPackets$lambda$5(HookPacket obj, Supplier ctx) {
        HookPacket hookPacket = obj;
        Intrinsics.checkNotNull((Object)hookPacket);
        Supplier supplier = ctx;
        Intrinsics.checkNotNull((Object)supplier);
        hookPacket.handle(supplier);
    }

    private static final ServerPlayer sendClientHookPacket$lambda$6(ServerPlayer $player) {
        return $player;
    }

    private static final void handle$lambda$7(HookPacket $msg, Supplier $ctx) {
        INSTANCE.handleHookPacket($msg, $ctx);
    }

    private static final void handleHookPacket$lambda$8(Supplier $ctx, HookPacket $packet) {
        Entity foundEntity;
        Object t = $ctx.get();
        Intrinsics.checkNotNull(t);
        ServerPlayer sender = ((NetworkEvent.Context)t).getSender();
        ServerPlayer serverPlayer = sender;
        Entity entity = serverPlayer != null && (serverPlayer = serverPlayer.m_9236_()) != null ? serverPlayer.m_6815_($packet.getEntityId()) : (foundEntity = null);
        if (foundEntity instanceof FishingHook) {
            CustomFishingBobberEntityData additionalBobberData = (CustomFishingBobberEntityData)foundEntity;
            ItemStack itemStack = additionalBobberData.hybrid_aquatic$getLureItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"hybrid_aquatic$getLureItem(...)");
            ItemStack item = itemStack;
            INSTANCE.sendClientHookPacket(sender, foundEntity.m_19879_(), item);
        }
    }

    private static final void handleHookPacket$lambda$9(HookPacket $packet) {
        Minecraft client = Minecraft.m_91087_();
        ClientLevel clientLevel = client.f_91073_;
        Entity foundEntity = clientLevel != null ? clientLevel.m_6815_($packet.getEntityId()) : null;
        ItemStack itemStack = $packet.getEntityData();
        if (foundEntity != null && foundEntity instanceof FishingHook) {
            CustomFishingBobberEntityData additionalBobberData = (CustomFishingBobberEntityData)foundEntity;
            additionalBobberData.hybrid_aquatic$setLureItem(itemStack);
        }
    }

    static {
        SimpleChannel simpleChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)CommonClass.locate("main"), HybridAquaticNetworking::CHANNEL$lambda$0, HybridAquaticNetworking::CHANNEL$lambda$1, HybridAquaticNetworking::CHANNEL$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)simpleChannel, (String)"newSimpleChannel(...)");
        CHANNEL = simpleChannel;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0015\u001a\u00020\u00142\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Ldev/hybridlabs/aquatic/network/HybridAquaticNetworking$HookPacket;", "", "entityId", "", "entityData", "Lnet/minecraft/world/item/ItemStack;", "<init>", "(ILnet/minecraft/world/item/ItemStack;)V", "buffer", "Lnet/minecraft/network/FriendlyByteBuf;", "(Lnet/minecraft/network/FriendlyByteBuf;)V", "getEntityId", "()I", "setEntityId", "(I)V", "getEntityData", "()Lnet/minecraft/world/item/ItemStack;", "setEntityData", "(Lnet/minecraft/world/item/ItemStack;)V", "encoder", "", "handle", "ctx", "Ljava/util/function/Supplier;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "hybrid-aquatic-forge-1.20.1"})
    public static final class HookPacket {
        private int entityId;
        @NotNull
        private ItemStack entityData;

        public final int getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(int n) {
            this.entityId = n;
        }

        @NotNull
        public final ItemStack getEntityData() {
            return this.entityData;
        }

        public final void setEntityData(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
            this.entityData = itemStack;
        }

        public HookPacket(int entityId, @NotNull ItemStack entityData) {
            Intrinsics.checkNotNullParameter((Object)entityData, (String)"entityData");
            this.entityId = entityId;
            this.entityData = entityData;
        }

        public HookPacket(@NotNull FriendlyByteBuf buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            this.entityId = buffer.readInt();
            ItemStack itemStack = buffer.m_130267_();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"readItem(...)");
            this.entityData = itemStack;
        }

        public final void encoder(@NotNull FriendlyByteBuf buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            buffer.writeInt(this.entityId);
            buffer.m_130055_(this.entityData);
        }

        public final void handle(@NotNull Supplier<NetworkEvent.Context> ctx) {
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            NetworkEvent.Context context = ctx.get();
            Intrinsics.checkNotNull((Object)context);
            context.enqueueWork(() -> HookPacket.handle$lambda$0(this, ctx));
            NetworkEvent.Context context2 = ctx.get();
            Intrinsics.checkNotNull((Object)context2);
            context2.setPacketHandled(true);
        }

        private static final void handle$lambda$0(HookPacket this$0, Supplier $ctx) {
            INSTANCE.handle(this$0, $ctx);
        }
    }
}

