/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.world.gen.feature;

import com.mojang.serialization.Codec;
import dev.hybridlabs.aquatic.block.ThermalVentBlock;
import dev.hybridlabs.aquatic.block.TubeWormBlock;
import dev.hybridlabs.aquatic.entity.HybridAquaticEntityTypes;
import dev.hybridlabs.aquatic.entity.crustacean.YetiCrabEntity;
import dev.hybridlabs.aquatic.tag.HybridAquaticBiomeTags;
import dev.hybridlabs.aquatic.world.gen.feature.VentPatchFeatureConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001+B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016J8\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J0\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J0\u0010\u001d\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001bH\u0002J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J@\u0010&\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u0015H\u0002J \u0010*\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0002\u00a8\u0006,"}, d2={"Ldev/hybridlabs/aquatic/world/gen/feature/VentPatchFeature;", "Lnet/minecraft/world/level/levelgen/feature/Feature;", "Ldev/hybridlabs/aquatic/world/gen/feature/VentPatchFeatureConfig;", "codec", "Lcom/mojang/serialization/Codec;", "<init>", "(Lcom/mojang/serialization/Codec;)V", "place", "", "context", "Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;", "generateSingleVent", "world", "Lnet/minecraft/world/level/LevelAccessor;", "rootPos", "Lnet/minecraft/core/BlockPos;", "random", "Lnet/minecraft/util/RandomSource;", "heightMultiplier", "", "baseProvider", "Lnet/minecraft/world/level/levelgen/feature/stateproviders/BlockStateProvider;", "ventProvider", "spawnYetiCrabsAroundVent", "", "Lnet/minecraft/world/level/ServerLevelAccessor;", "count", "", "radius", "generateHydrothermalVent", "pos", "cycle", "height", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "getHydrothermalVentThickness", "Lnet/minecraft/world/level/block/state/properties/DripstoneThickness;", "calculateVentHeight", "generateTubeWormPatch", "wormCountProvider", "Lnet/minecraft/util/valueproviders/IntProvider;", "stateProvider", "isValidPosition", "Companion", "hybrid-aquatic-forge-1.20.1"})
public final class VentPatchFeature
extends Feature<VentPatchFeatureConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int MAX_VENT_HEIGHT = 5;
    public static final int MIN_VENT_HEIGHT = 2;
    public static final int MIN_VENT_CLEARANCE = 2;

    public VentPatchFeature(@NotNull Codec<VentPatchFeatureConfig> codec) {
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        super(codec);
    }

    public boolean m_142674_(@NotNull FeaturePlaceContext<VentPatchFeatureConfig> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        boolean generated = false;
        WorldGenLevel world = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        VentPatchFeatureConfig ventPatchFeatureConfig = (VentPatchFeatureConfig)context.m_159778_();
        BlockStateProvider baseProvider = ventPatchFeatureConfig.component1();
        BlockStateProvider ventProvider = ventPatchFeatureConfig.component2();
        BlockStateProvider wormProvider = ventPatchFeatureConfig.component3();
        IntProvider countProvider = ventPatchFeatureConfig.component4();
        IntProvider radiusProvider = ventPatchFeatureConfig.component5();
        IntProvider wormCountProvider = ventPatchFeatureConfig.component6();
        IntProvider wormRadiusProvider = ventPatchFeatureConfig.component7();
        IntProvider wormCountPerBlockProvider = ventPatchFeatureConfig.component8();
        int count = countProvider.m_214085_(random);
        for (int i = 0; i < count; ++i) {
            int it = i;
            boolean bl = false;
            int radius = radiusProvider.m_214085_(random);
            int offsetX = random.m_188503_(radius * 2 + 1) - radius;
            int offsetZ = random.m_188503_(radius * 2 + 1) - radius;
            BlockPos candidatePos = origin.m_7918_(offsetX, 0, offsetZ);
            double distanceFromCenter = Math.sqrt(offsetX * offsetX + offsetZ * offsetZ);
            double heightMultiplier = 1.0 - RangesKt.coerceIn((double)(distanceFromCenter / (double)radius), (double)0.0, (double)1.0);
            Intrinsics.checkNotNull((Object)world);
            LevelAccessor levelAccessor = (LevelAccessor)world;
            Intrinsics.checkNotNull((Object)candidatePos);
            Intrinsics.checkNotNull((Object)random);
            if (!this.generateSingleVent(levelAccessor, candidatePos, random, heightMultiplier, baseProvider, ventProvider)) continue;
            int wormCount = wormCountProvider.m_214085_(random);
            int wormRadius = wormRadiusProvider.m_214085_(random);
            this.generateTubeWormPatch((LevelAccessor)world, candidatePos, random, wormCount, wormCountPerBlockProvider, wormRadius, wormProvider);
            Holder biome = world.m_204166_(candidatePos);
            if (biome.m_203656_(HybridAquaticBiomeTags.INSTANCE.getARCTIC_OCEANS())) {
                this.spawnYetiCrabsAroundVent((ServerLevelAccessor)world, candidatePos, random, 1, 3);
            }
            generated = true;
        }
        return generated;
    }

    private final boolean generateSingleVent(LevelAccessor world, BlockPos rootPos, RandomSource random, double heightMultiplier, BlockStateProvider baseProvider, BlockStateProvider ventProvider) {
        if (!world.m_46801_(rootPos)) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = rootPos.m_122032_();
        BlockState state = ventProvider.m_213972_(random, (BlockPos)mutablePos);
        Intrinsics.checkNotNull((Object)mutablePos);
        BlockPos blockPos = (BlockPos)mutablePos;
        Intrinsics.checkNotNull((Object)state);
        if (!this.isValidPosition(world, blockPos, state)) {
            return false;
        }
        int baseThickness = 1 + random.m_188503_(3);
        int minHeight = baseThickness + 5 + 2;
        mutablePos.m_122193_(new Vec3i(0, minHeight, 0));
        while (mutablePos.m_123342_() > rootPos.m_123342_()) {
            if (!world.m_46801_((BlockPos)mutablePos)) {
                return false;
            }
            mutablePos.m_122173_(Direction.DOWN);
        }
        int n = 0;
        while (n < baseThickness) {
            int it = n++;
            boolean bl = false;
            BlockState state2 = baseProvider.m_213972_(random, (BlockPos)mutablePos);
            world.m_7731_((BlockPos)mutablePos, state2, 2);
            mutablePos.m_122173_(Direction.UP);
        }
        int ventHeight = this.calculateVentHeight(heightMultiplier);
        int n2 = 0;
        while (n2 < ventHeight) {
            int cycle = n2++;
            boolean bl = false;
            this.generateHydrothermalVent(world, (BlockPos)mutablePos, cycle, ventHeight, state);
            mutablePos.m_122173_(Direction.UP);
        }
        return true;
    }

    private final void spawnYetiCrabsAroundVent(ServerLevelAccessor world, BlockPos rootPos, RandomSource random, int count, int radius) {
        for (int i = 0; i < count; ++i) {
            YetiCrabEntity yetiCrabEntity;
            int offsetZ;
            int it = i;
            boolean bl = false;
            int offsetX = random.m_188503_(radius * 2 + 1) - radius;
            BlockPos spawnPos = rootPos.m_7918_(offsetX, 0, offsetZ = random.m_188503_(radius * 2 + 1) - radius);
            if (!world.m_46801_(spawnPos) || (YetiCrabEntity)HybridAquaticEntityTypes.INSTANCE.getYETI_CRAB().get().m_20615_((Level)world.m_6018_()) == null) continue;
            yetiCrabEntity.m_20035_(spawnPos, random.m_188501_() * 360.0f, 0.0f);
            yetiCrabEntity.m_21530_();
            DifficultyInstance difficultyInstance = world.m_6436_(spawnPos);
            Intrinsics.checkNotNullExpressionValue((Object)difficultyInstance, (String)"getCurrentDifficultyAt(...)");
            yetiCrabEntity.m_6518_(world, difficultyInstance, MobSpawnType.STRUCTURE, null, null);
            world.m_7967_((Entity)yetiCrabEntity);
        }
    }

    private final void generateHydrothermalVent(LevelAccessor world, BlockPos pos, int cycle, int height, BlockState state) {
        DripstoneThickness thickness = this.getHydrothermalVentThickness(cycle, height);
        world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_46801_(pos)))).m_61124_((Property)ThermalVentBlock.Companion.getTHICKNESS(), (Comparable)thickness), 2);
    }

    private final DripstoneThickness getHydrothermalVentThickness(int cycle, int height) {
        if (cycle == 0) {
            return DripstoneThickness.BASE;
        }
        if (cycle == height - 1) {
            return DripstoneThickness.TIP;
        }
        return DripstoneThickness.MIDDLE;
    }

    private final int calculateVentHeight(double heightMultiplier) {
        return Math.max(2, (int)((double)2 + (double)3 * heightMultiplier));
    }

    private final void generateTubeWormPatch(LevelAccessor world, BlockPos pos, RandomSource random, int count, IntProvider wormCountProvider, int radius, BlockStateProvider stateProvider) {
        for (int i = 0; i < count; ++i) {
            int it = i;
            boolean bl = false;
            BlockPos offset = new BlockPos(random.m_188503_(radius * 2) - radius, random.m_188503_(radius * 2) - radius, random.m_188503_(radius * 2) - radius);
            BlockPos.MutableBlockPos tubeWormPos = pos.m_121955_((Vec3i)offset).m_122032_();
            int n = 3;
            for (int j = 0; j < n; ++j) {
                int it2 = j;
                boolean bl2 = false;
                BlockState testState = world.m_8055_((BlockPos)tubeWormPos);
                if (!Intrinsics.areEqual((Object)testState.m_60734_(), (Object)Blocks.f_49990_)) {
                    tubeWormPos.m_122173_(Direction.UP);
                    continue;
                }
                if (testState.m_60783_((BlockGetter)world, (BlockPos)tubeWormPos, Direction.UP)) continue;
                tubeWormPos.m_122173_(Direction.DOWN);
            }
            BlockState state = stateProvider.m_213972_(random, (BlockPos)tubeWormPos);
            Intrinsics.checkNotNull((Object)tubeWormPos);
            BlockPos blockPos = (BlockPos)tubeWormPos;
            Intrinsics.checkNotNull((Object)state);
            if (!this.isValidPosition(world, blockPos, state)) continue;
            int wormCount = wormCountProvider.m_214085_(random);
            world.m_7731_((BlockPos)tubeWormPos, (BlockState)state.m_61124_((Property)TubeWormBlock.Companion.getWORMS(), (Comparable)Integer.valueOf(wormCount)), 2);
        }
    }

    private final boolean isValidPosition(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockState existingState = world.m_8055_(pos);
        if (!existingState.m_247087_()) {
            return false;
        }
        return state.m_60710_((LevelReader)world, pos);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldev/hybridlabs/aquatic/world/gen/feature/VentPatchFeature$Companion;", "", "<init>", "()V", "MAX_VENT_HEIGHT", "", "MIN_VENT_HEIGHT", "MIN_VENT_CLEARANCE", "hybrid-aquatic-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

