/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.world.gen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hybridlabs.aquatic.CommonClass;
import dev.hybridlabs.aquatic.world.gen.structure.SpawnModifier;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.world.ModifiableStructureInfo;
import net.minecraftforge.common.world.StructureModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Ldev/hybridlabs/aquatic/world/gen/structure/StructureSpawnModifier;", "Lnet/minecraftforge/common/world/StructureModifier;", "spawnModifier", "Ldev/hybridlabs/aquatic/world/gen/structure/SpawnModifier;", "<init>", "(Ldev/hybridlabs/aquatic/world/gen/structure/SpawnModifier;)V", "getSpawnModifier", "()Ldev/hybridlabs/aquatic/world/gen/structure/SpawnModifier;", "modify", "", "structure", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/levelgen/structure/Structure;", "phase", "Lnet/minecraftforge/common/world/StructureModifier$Phase;", "builder", "Lnet/minecraftforge/common/world/ModifiableStructureInfo$StructureInfo$Builder;", "codec", "Lcom/mojang/serialization/Codec;", "Companion", "hybrid-aquatic-forge-1.20.1"})
public final class StructureSpawnModifier
implements StructureModifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SpawnModifier spawnModifier;
    @Nullable
    private static final RegistryObject<Codec<? extends StructureModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)CommonClass.locate("ha_structure_spawns"), (ResourceKey)ForgeRegistries.Keys.STRUCTURE_MODIFIER_SERIALIZERS, (String)"hybrid-aquatic");

    public StructureSpawnModifier(@NotNull SpawnModifier spawnModifier) {
        Intrinsics.checkNotNullParameter((Object)spawnModifier, (String)"spawnModifier");
        this.spawnModifier = spawnModifier;
    }

    @NotNull
    public final SpawnModifier getSpawnModifier() {
        return this.spawnModifier;
    }

    public void modify(@Nullable Holder<Structure> structure, @Nullable StructureModifier.Phase phase, @NotNull ModifiableStructureInfo.StructureInfo.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (phase == StructureModifier.Phase.ADD) {
            Holder<Structure> holder = structure;
            Intrinsics.checkNotNull(holder);
            Object t = holder.m_203543_().get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            ResourceKey key = (ResourceKey)t;
            if (Intrinsics.areEqual(this.spawnModifier.getStructure(), (Object)key)) {
                for (Map.Entry<String, List<MobSpawnSettings.SpawnerData>> entry : this.spawnModifier.getSpawns().entrySet()) {
                    String categoryName = entry.getKey();
                    List<MobSpawnSettings.SpawnerData> spawns = entry.getValue();
                    MobCategory category = MobCategory.byName((String)categoryName);
                    for (MobSpawnSettings.SpawnerData spawn : spawns) {
                        builder.getStructureSettings().getOrAddSpawnOverrides(category).addSpawn(spawn);
                    }
                }
            }
        }
    }

    @Nullable
    public Codec<? extends StructureModifier> codec() {
        RegistryObject<Codec<? extends StructureModifier>> registryObject = SERIALIZER;
        return registryObject != null ? (Codec)registryObject.get() : null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\u0006R%\u0010\u0004\u001a\u0016\u0012\u0010\u0012\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Ldev/hybridlabs/aquatic/world/gen/structure/StructureSpawnModifier$Companion;", "", "<init>", "()V", "SERIALIZER", "Lnet/minecraftforge/registries/RegistryObject;", "Lcom/mojang/serialization/Codec;", "Lnet/minecraftforge/common/world/StructureModifier;", "getSERIALIZER", "()Lnet/minecraftforge/registries/RegistryObject;", "makeCodec", "Ldev/hybridlabs/aquatic/world/gen/structure/StructureSpawnModifier;", "hybrid-aquatic-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final RegistryObject<Codec<? extends StructureModifier>> getSERIALIZER() {
            return SERIALIZER;
        }

        @Nullable
        public final Codec<StructureSpawnModifier> makeCodec() {
            return RecordCodecBuilder.create(Companion::makeCodec$lambda$1);
        }

        private static final SpawnModifier makeCodec$lambda$1$lambda$0(StructureSpawnModifier modifier) {
            return modifier.getSpawnModifier();
        }

        private static final App makeCodec$lambda$1(RecordCodecBuilder.Instance instance) {
            return instance.group((App)SpawnModifier.Companion.getCODEC().fieldOf("modifier").forGetter(Companion::makeCodec$lambda$1$lambda$0)).apply((Applicative)instance, StructureSpawnModifier::new);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

