/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic;

import com.mojang.serialization.Codec;
import dev.hybridlabs.aquatic.CommonClass;
import dev.hybridlabs.aquatic.Constants;
import dev.hybridlabs.aquatic.block.PlushieBlock;
import dev.hybridlabs.aquatic.block.SeaMessage;
import dev.hybridlabs.aquatic.block.entity.HybridAquaticBlockEntityTypes;
import dev.hybridlabs.aquatic.client.model.HybridAquaticEntityModelLayers;
import dev.hybridlabs.aquatic.client.model.block.entity.plushie.BaskingSharkPlushieModel;
import dev.hybridlabs.aquatic.client.model.block.entity.plushie.BullSharkPlushieModel;
import dev.hybridlabs.aquatic.client.model.block.entity.plushie.FrilledSharkPlushieModel;
import dev.hybridlabs.aquatic.client.model.block.entity.plushie.GreatWhiteSharkPlushieModel;
import dev.hybridlabs.aquatic.client.model.block.entity.plushie.HammerheadSharkPlushieModel;
import dev.hybridlabs.aquatic.client.model.block.entity.plushie.ThresherSharkPlushieModel;
import dev.hybridlabs.aquatic.client.model.block.entity.plushie.TigerSharkPlushieModel;
import dev.hybridlabs.aquatic.client.model.block.entity.plushie.WhaleSharkPlushieModel;
import dev.hybridlabs.aquatic.client.render.block.HybridAquaticBlockRenderers;
import dev.hybridlabs.aquatic.client.render.block.entity.AnemoneBlockEntityRenderer;
import dev.hybridlabs.aquatic.client.render.block.entity.BuoyBlockEntityRenderer;
import dev.hybridlabs.aquatic.client.render.block.entity.GiantGreenAnemoneBlockEntityRenderer;
import dev.hybridlabs.aquatic.client.render.block.entity.MessageInABottleBlockEntityRenderer;
import dev.hybridlabs.aquatic.client.render.block.entity.StrawberryAnemoneBlockEntityRenderer;
import dev.hybridlabs.aquatic.entity.SpawnRestrictionRegistry;
import dev.hybridlabs.aquatic.network.HybridAquaticNetworkingForge;
import dev.hybridlabs.aquatic.potions.HybridAquaticPotions;
import dev.hybridlabs.aquatic.registry.HybridAquaticRegistryKeys;
import dev.hybridlabs.aquatic.utils.HybridAquaticCustomTrades;
import dev.hybridlabs.aquatic.world.gen.feature.DunegrassFeature;
import dev.hybridlabs.aquatic.world.gen.feature.HybridAquaticFeatures;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import thedarkcolour.kotlinforforge.neoforge.KotlinModLoadingContext;

@Mod(value="hybrid_aquatic")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0017H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/hybridlabs/aquatic/HybridAquaticForge;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "loadSeaMessages", "", "event", "Lnet/neoforged/neoforge/registries/DataPackRegistryEvent$NewRegistry;", "registerSpawnPlacements", "Lnet/neoforged/neoforge/event/entity/RegisterSpawnPlacementsEvent;", "registerModelLayers", "Lnet/neoforged/neoforge/client/event/EntityRenderersEvent$RegisterLayerDefinitions;", "registerBlockEntityRenderers", "Lnet/neoforged/neoforge/client/event/EntityRenderersEvent$RegisterRenderers;", "registerSkullModels", "Lnet/neoforged/neoforge/client/event/EntityRenderersEvent$CreateSkullModels;", "onClientSetup", "Lnet/neoforged/fml/event/lifecycle/FMLClientSetupEvent;", "onServerSetup", "Lnet/neoforged/fml/event/lifecycle/FMLDedicatedServerSetupEvent;", "registerBrewingRecipes", "Lnet/neoforged/neoforge/event/brewing/RegisterBrewingRecipesEvent;", "hybrid-aquatic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nHybridAquaticForge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HybridAquaticForge.kt\ndev/hybridlabs/aquatic/HybridAquaticForge\n+ 2 Forge.kt\nthedarkcolour/kotlinforforge/neoforge/forge/ForgeKt\n*L\n1#1,216:1\n24#2:217\n24#2:218\n17#2:219\n17#2:220\n17#2:221\n65#2:222\n37#2:223\n66#2:224\n24#2:225\n24#2:226\n24#2:227\n24#2:228\n24#2:229\n68#2:230\n24#2:231\n*S KotlinDebug\n*F\n+ 1 HybridAquaticForge.kt\ndev/hybridlabs/aquatic/HybridAquaticForge\n*L\n81#1:217\n85#1:218\n86#1:219\n87#1:220\n88#1:221\n90#1:222\n90#1:223\n90#1:224\n92#1:225\n93#1:226\n94#1:227\n95#1:228\n96#1:229\n90#1:230\n100#1:231\n*E\n"})
public final class HybridAquaticForge {
    @NotNull
    public static final HybridAquaticForge INSTANCE = new HybridAquaticForge();
    @NotNull
    private static final Logger logger;

    private HybridAquaticForge() {
    }

    public final void loadSeaMessages(@NotNull DataPackRegistryEvent.NewRegistry event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.dataPackRegistry(HybridAquaticRegistryKeys.INSTANCE.getSEA_MESSAGE(), SeaMessage.Companion.getCODEC(), SeaMessage.Companion.getCODEC());
    }

    private final void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        SpawnRestrictionRegistry.INSTANCE.registerSpawnRestrictions();
    }

    private final void registerModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(HybridAquaticEntityModelLayers.INSTANCE.getBASKING_SHARK_PLUSHIE(), BaskingSharkPlushieModel.Companion::createModelData);
        event.registerLayerDefinition(HybridAquaticEntityModelLayers.INSTANCE.getBULL_SHARK_PLUSHIE(), BullSharkPlushieModel.Companion::createModelData);
        event.registerLayerDefinition(HybridAquaticEntityModelLayers.INSTANCE.getFRILLED_SHARK_PLUSHIE(), FrilledSharkPlushieModel.Companion::createModelData);
        event.registerLayerDefinition(HybridAquaticEntityModelLayers.INSTANCE.getGREAT_WHITE_SHARK_PLUSHIE(), GreatWhiteSharkPlushieModel.Companion::createModelData);
        event.registerLayerDefinition(HybridAquaticEntityModelLayers.INSTANCE.getHAMMERHEAD_SHARK_PLUSHIE(), HammerheadSharkPlushieModel.Companion::createModelData);
        event.registerLayerDefinition(HybridAquaticEntityModelLayers.INSTANCE.getTHRESHER_SHARK_PLUSHIE(), ThresherSharkPlushieModel.Companion::createModelData);
        event.registerLayerDefinition(HybridAquaticEntityModelLayers.INSTANCE.getTIGER_SHARK_PLUSHIE(), TigerSharkPlushieModel.Companion::createModelData);
        event.registerLayerDefinition(HybridAquaticEntityModelLayers.INSTANCE.getWHALE_SHARK_PLUSHIE(), WhaleSharkPlushieModel.Companion::createModelData);
    }

    private final void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(HybridAquaticBlockEntityTypes.INSTANCE.getANEMONE().get(), AnemoneBlockEntityRenderer::new);
        event.registerBlockEntityRenderer(HybridAquaticBlockEntityTypes.INSTANCE.getSTRAWBERRY_ANEMONE().get(), StrawberryAnemoneBlockEntityRenderer::new);
        event.registerBlockEntityRenderer(HybridAquaticBlockEntityTypes.INSTANCE.getGIANT_GREEN_ANEMONE().get(), GiantGreenAnemoneBlockEntityRenderer::new);
        event.registerBlockEntityRenderer(HybridAquaticBlockEntityTypes.INSTANCE.getMESSAGE_IN_A_BOTTLE().get(), MessageInABottleBlockEntityRenderer::new);
        event.registerBlockEntityRenderer(HybridAquaticBlockEntityTypes.INSTANCE.getBUOY().get(), BuoyBlockEntityRenderer::new);
        HybridAquaticBlockRenderers.INSTANCE.registerRenderShapes();
    }

    private final void registerSkullModels(EntityRenderersEvent.CreateSkullModels event) {
        EntityModelSet modelLoader = event.getEntityModelSet();
        SkullBlock.Type type = PlushieBlock.Variant.BASKING_SHARK;
        ModelPart modelPart = modelLoader.bakeLayer(HybridAquaticEntityModelLayers.INSTANCE.getBASKING_SHARK_PLUSHIE());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        event.registerSkullModel(type, (SkullModelBase)new BaskingSharkPlushieModel(modelPart));
        SkullBlock.Type type2 = PlushieBlock.Variant.BULL_SHARK;
        ModelPart modelPart2 = modelLoader.bakeLayer(HybridAquaticEntityModelLayers.INSTANCE.getBULL_SHARK_PLUSHIE());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"bakeLayer(...)");
        event.registerSkullModel(type2, (SkullModelBase)new BullSharkPlushieModel(modelPart2));
        SkullBlock.Type type3 = PlushieBlock.Variant.FRILLED_SHARK;
        ModelPart modelPart3 = modelLoader.bakeLayer(HybridAquaticEntityModelLayers.INSTANCE.getFRILLED_SHARK_PLUSHIE());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart3, (String)"bakeLayer(...)");
        event.registerSkullModel(type3, (SkullModelBase)new BullSharkPlushieModel(modelPart3));
        SkullBlock.Type type4 = PlushieBlock.Variant.GREAT_WHITE_SHARK;
        ModelPart modelPart4 = modelLoader.bakeLayer(HybridAquaticEntityModelLayers.INSTANCE.getGREAT_WHITE_SHARK_PLUSHIE());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart4, (String)"bakeLayer(...)");
        event.registerSkullModel(type4, (SkullModelBase)new BullSharkPlushieModel(modelPart4));
        SkullBlock.Type type5 = PlushieBlock.Variant.HAMMERHEAD_SHARK;
        ModelPart modelPart5 = modelLoader.bakeLayer(HybridAquaticEntityModelLayers.INSTANCE.getHAMMERHEAD_SHARK_PLUSHIE());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart5, (String)"bakeLayer(...)");
        event.registerSkullModel(type5, (SkullModelBase)new BullSharkPlushieModel(modelPart5));
        SkullBlock.Type type6 = PlushieBlock.Variant.THRESHER_SHARK;
        ModelPart modelPart6 = modelLoader.bakeLayer(HybridAquaticEntityModelLayers.INSTANCE.getTHRESHER_SHARK_PLUSHIE());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart6, (String)"bakeLayer(...)");
        event.registerSkullModel(type6, (SkullModelBase)new BullSharkPlushieModel(modelPart6));
        SkullBlock.Type type7 = PlushieBlock.Variant.TIGER_SHARK;
        ModelPart modelPart7 = modelLoader.bakeLayer(HybridAquaticEntityModelLayers.INSTANCE.getTIGER_SHARK_PLUSHIE());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart7, (String)"bakeLayer(...)");
        event.registerSkullModel(type7, (SkullModelBase)new BullSharkPlushieModel(modelPart7));
        SkullBlock.Type type8 = PlushieBlock.Variant.WHALE_SHARK;
        ModelPart modelPart8 = modelLoader.bakeLayer(HybridAquaticEntityModelLayers.INSTANCE.getWHALE_SHARK_PLUSHIE());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart8, (String)"bakeLayer(...)");
        event.registerSkullModel(type8, (SkullModelBase)new BullSharkPlushieModel(modelPart8));
    }

    private final void onClientSetup(FMLClientSetupEvent event) {
        logger.info("Initializing client...");
    }

    private final void onServerSetup(FMLDedicatedServerSetupEvent event) {
        logger.info("Server starting...");
    }

    @SubscribeEvent
    public final void registerBrewingRecipes(@NotNull RegisterBrewingRecipesEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (HybridAquaticPotions.PotionRecipe recipe : HybridAquaticPotions.INSTANCE.getRecipes().get()) {
            event.getBuilder().addMix(recipe.getInputPotion(), recipe.getAddition(), recipe.getOutputPotion());
        }
    }

    static {
        Logger logger = Constants.LOG;
        Intrinsics.checkNotNull((Object)logger);
        HybridAquaticForge.logger = logger;
        CommonClass.init();
        Codec codec = ProbabilityFeatureConfiguration.CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"CODEC");
        HybridAquaticFeatures.INSTANCE.register("dunegrass_patch", (Feature)new DunegrassFeature((Codec<ProbabilityFeatureConfiguration>)codec));
        boolean $i$f$getMOD_BUS = false;
        KotlinModLoadingContext.Companion.get().getKEventBus().addListener(HybridAquaticNetworkingForge.INSTANCE::register);
        $i$f$getMOD_BUS = false;
        KotlinModLoadingContext.Companion.get().getKEventBus().addListener(INSTANCE::loadSeaMessages);
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(HybridAquaticCustomTrades::registerWandererTrades);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus2 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus2, (String)"EVENT_BUS");
        iEventBus2.addListener(HybridAquaticCustomTrades::registerCustomTrades);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus3 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus3, (String)"EVENT_BUS");
        iEventBus3.addListener(INSTANCE::registerBrewingRecipes);
        boolean $i$f$runForDist = false;
        boolean $i$f$getDIST = false;
        Dist dist = FMLEnvironment.dist;
        Intrinsics.checkNotNullExpressionValue((Object)dist, (String)"dist");
        if (dist == Dist.CLIENT) {
            boolean bl = false;
            boolean $i$f$getMOD_BUS2 = false;
            KotlinModLoadingContext.Companion.get().getKEventBus().addListener(INSTANCE::onClientSetup);
            $i$f$getMOD_BUS2 = false;
            KotlinModLoadingContext.Companion.get().getKEventBus().addListener(INSTANCE::registerModelLayers);
            $i$f$getMOD_BUS2 = false;
            KotlinModLoadingContext.Companion.get().getKEventBus().addListener(INSTANCE::registerSkullModels);
            $i$f$getMOD_BUS2 = false;
            KotlinModLoadingContext.Companion.get().getKEventBus().addListener(INSTANCE::registerBlockEntityRenderers);
            $i$f$getMOD_BUS2 = false;
            KotlinModLoadingContext.Companion.get().getKEventBus().addListener(INSTANCE::registerSpawnPlacements);
        } else {
            boolean bl = false;
            boolean $i$f$getMOD_BUS3 = false;
            KotlinModLoadingContext.Companion.get().getKEventBus().addListener(INSTANCE::onServerSetup);
        }
    }
}

