/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.block;

import dev.hybridlabs.aquatic.item.HybridAquaticItems;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 62\u00020\u00012\u00020\u0002:\u000267B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J(\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0012\u0010 \u001a\u0004\u0018\u00010\r2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\f\u001a\u00020\rH\u0014J\u001c\u0010%\u001a\u00020\u00162\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0'H\u0014J0\u0010(\u001a\u00020)2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020*2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014J(\u0010/\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020*2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u00100\u001a\u000201H\u0016J(\u00102\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020*2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u00103\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u00104\u001a\u000205H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Ldev/hybridlabs/aquatic/block/GiantClamBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/SimpleWaterloggedBlock;", "emitsParticles", "", "settings", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(ZLnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "pearlTimer", "", "isPathfindable", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "type", "Lnet/minecraft/world/level/pathfinder/PathComputationType;", "canSurvive", "world", "Lnet/minecraft/world/level/LevelReader;", "pos", "Lnet/minecraft/core/BlockPos;", "tick", "", "Lnet/minecraft/server/level/ServerLevel;", "random", "Lnet/minecraft/util/RandomSource;", "getCollisionShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "getShape", "getStateForPlacement", "ctx", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "getFluidState", "Lnet/minecraft/world/level/material/FluidState;", "createBlockStateDefinition", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hit", "Lnet/minecraft/world/phys/BlockHitResult;", "stepOn", "entity", "Lnet/minecraft/world/entity/Entity;", "animateTick", "rotate", "rotation", "Lnet/minecraft/world/level/block/Rotation;", "Companion", "GiantClamState", "hybrid-aquatic-neoforge-1.21.1"})
public final class GiantClamBlock
extends Block
implements SimpleWaterloggedBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean emitsParticles;
    private int pearlTimer;
    @NotNull
    private static final DirectionProperty FACING;
    @NotNull
    private static final EnumProperty<GiantClamState> STATE;
    @NotNull
    private static final BooleanProperty WATERLOGGED;
    @NotNull
    private static final VoxelShape SHAPE;
    @NotNull
    private static final VoxelShape COLLISION_SHAPE;

    public GiantClamBlock(boolean emitsParticles, @NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.emitsParticles = emitsParticles;
        this.pearlTimer = 6000;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)STATE, (Comparable)((Object)GiantClamState.OPEN)));
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return false;
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockPos supportingPos = pos.below();
        BlockState supportingState = world.getBlockState(supportingPos);
        return supportingState.isFaceSturdy((BlockGetter)world, supportingPos, Direction.UP);
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Boolean waterlogged = (Boolean)state.getValue((Property)WATERLOGGED);
        GiantClamState currentState = (GiantClamState)((Object)state.getValue((Property)STATE));
        if (!waterlogged.booleanValue() && currentState != GiantClamState.DEAD) {
            world.setBlock(pos, (BlockState)state.setValue((Property)STATE, (Comparable)((Object)GiantClamState.DEAD)), 3);
            return;
        }
        if (currentState != GiantClamState.DEAD && this.pearlTimer > 0) {
            GiantClamState newState;
            int n = this.pearlTimer;
            this.pearlTimer = n + -1;
            GiantClamState giantClamState = newState = this.pearlTimer > 0 ? GiantClamState.CLOSED : GiantClamState.OPEN;
            if (newState != currentState) {
                world.setBlock(pos, (BlockState)state.setValue((Property)STATE, (Comparable)((Object)newState)), 2);
            }
            if (this.pearlTimer > 0) {
                world.scheduleTick(pos, (Block)this, 20);
            }
        }
    }

    @NotNull
    protected VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return COLLISION_SHAPE;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        boolean waterlogged = ctx.getLevel().getFluidState(ctx.getClickedPos()).is((Fluid)Fluids.WATER);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).setValue((Property)STATE, (Comparable)((Object)(waterlogged ? GiantClamState.CLOSED : GiantClamState.DEAD)))).setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getClockWise());
    }

    @NotNull
    protected FluidState getFluidState(@NotNull BlockState state) {
        FluidState fluidState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            FluidState fluidState2 = Fluids.WATER.getSource(false);
            fluidState = fluidState2;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState2, (String)"getSource(...)");
        } else {
            FluidState fluidState3 = super.getFluidState(state);
            fluidState = fluidState3;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState3, (String)"getFluidState(...)");
        }
        return fluidState;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{STATE, WATERLOGGED, FACING};
        builder.add(propertyArray);
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        if (!world.isClientSide) {
            GiantClamState currentState = (GiantClamState)((Object)state.getValue((Property)STATE));
            if (currentState == GiantClamState.OPEN) {
                this.pearlTimer = 6000;
                world.setBlock(pos, (BlockState)state.setValue((Property)STATE, (Comparable)((Object)GiantClamState.CLOSED)), 3);
                float randomValue = world.random.nextFloat();
                ItemStack itemToDrop = (double)randomValue < 0.7 ? new ItemStack((ItemLike)HybridAquaticItems.INSTANCE.getPEARL().get()) : ((double)randomValue < 0.95 ? new ItemStack((ItemLike)HybridAquaticItems.INSTANCE.getBLACK_PEARL().get()) : new ItemStack((ItemLike)Items.ENDER_PEARL));
                Block.popResource((Level)world, (BlockPos)pos, (ItemStack)itemToDrop);
            } else {
                return InteractionResult.PASS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void stepOn(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (world.isClientSide) {
            return;
        }
        GiantClamState currentState = (GiantClamState)((Object)state.getValue((Property)STATE));
        if (currentState == GiantClamState.OPEN) {
            world.setBlock(pos, (BlockState)state.setValue((Property)STATE, (Comparable)((Object)GiantClamState.CLOSED)), 3);
            this.pearlTimer = 6000;
            if (!entity.isSteppingCarefully() && entity instanceof LivingEntity) {
                ((LivingEntity)entity).hurt(world.damageSources().inWall(), 4.0f);
            }
        }
        super.stepOn(world, pos, state, entity);
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        int n;
        int i;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (state.getValue((Property)STATE) == GiantClamState.OPEN && this.emitsParticles && random.nextInt(5) == 0 && (i = 0) <= (n = random.nextInt(1))) {
            while (true) {
                world.addParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (double)random.nextFloat() / 2.0, 0.0, (double)random.nextFloat() / 2.0);
                if (i == n) break;
                ++i;
            }
        }
    }

    @NotNull
    protected BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        Property property = (Property)FACING;
        Comparable comparable = state.getValue((Property)FACING);
        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type net.minecraft.core.Direction");
        Object object = state.setValue(property, (Comparable)rotation.rotate((Direction)comparable));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
        return (BlockState)object;
    }

    static {
        DirectionProperty directionProperty = HorizontalDirectionalBlock.FACING;
        Intrinsics.checkNotNullExpressionValue((Object)directionProperty, (String)"FACING");
        FACING = directionProperty;
        GiantClamState[] giantClamStateArray = new GiantClamState[]{GiantClamState.OPEN, GiantClamState.CLOSED, GiantClamState.DEAD};
        EnumProperty enumProperty = EnumProperty.create((String)"state", GiantClamState.class, (Enum[])giantClamStateArray);
        Intrinsics.checkNotNullExpressionValue((Object)enumProperty, (String)"create(...)");
        STATE = enumProperty;
        BooleanProperty booleanProperty = BlockStateProperties.WATERLOGGED;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"WATERLOGGED");
        WATERLOGGED = booleanProperty;
        VoxelShape voxelShape = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        SHAPE = voxelShape;
        VoxelShape voxelShape2 = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"box(...)");
        COLLISION_SHAPE = voxelShape2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/hybridlabs/aquatic/block/GiantClamBlock$Companion;", "", "<init>", "()V", "FACING", "Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "getFACING", "()Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "STATE", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "Ldev/hybridlabs/aquatic/block/GiantClamBlock$GiantClamState;", "getSTATE", "()Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "WATERLOGGED", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getWATERLOGGED", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "COLLISION_SHAPE", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DirectionProperty getFACING() {
            return FACING;
        }

        @NotNull
        public final EnumProperty<GiantClamState> getSTATE() {
            return STATE;
        }

        @NotNull
        public final BooleanProperty getWATERLOGGED() {
            return WATERLOGGED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\n"}, d2={"Ldev/hybridlabs/aquatic/block/GiantClamBlock$GiantClamState;", "Lnet/minecraft/util/StringRepresentable;", "", "<init>", "(Ljava/lang/String;I)V", "OPEN", "CLOSED", "DEAD", "getSerializedName", "", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class GiantClamState
    extends Enum<GiantClamState>
    implements StringRepresentable {
        public static final /* enum */ GiantClamState OPEN = new GiantClamState();
        public static final /* enum */ GiantClamState CLOSED = new GiantClamState();
        public static final /* enum */ GiantClamState DEAD = new GiantClamState();
        private static final /* synthetic */ GiantClamState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public String getSerializedName() {
            String string = this.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return string;
        }

        public static GiantClamState[] values() {
            return (GiantClamState[])$VALUES.clone();
        }

        public static GiantClamState valueOf(String value) {
            return Enum.valueOf(GiantClamState.class, value);
        }

        @NotNull
        public static EnumEntries<GiantClamState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = giantClamStateArray = new GiantClamState[]{GiantClamState.OPEN, GiantClamState.CLOSED, GiantClamState.DEAD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

