/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.block;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 02\u00020\u00012\u00020\u0002:\u00010B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nH\u0014J8\u0010\u001b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000eH\u0014J(\u0010!\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0014J(\u0010&\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020'2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)H\u0014J\u001c\u0010*\u001a\u00020\"2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0,H\u0014J\u0018\u0010-\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010.\u001a\u00020/H\u0014\u00a8\u00061"}, d2={"Ldev/hybridlabs/aquatic/block/GlowingPlanktonBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/SimpleWaterloggedBlock;", "settings", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "canSurvive", "", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "world", "Lnet/minecraft/world/level/LevelReader;", "pos", "Lnet/minecraft/core/BlockPos;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "getStateForPlacement", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "getFluidState", "Lnet/minecraft/world/level/material/FluidState;", "propagatesSkylightDown", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "updateShape", "direction", "Lnet/minecraft/core/Direction;", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "entityInside", "", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "tick", "Lnet/minecraft/server/level/ServerLevel;", "random", "Lnet/minecraft/util/RandomSource;", "createBlockStateDefinition", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "isPathfindable", "type", "Lnet/minecraft/world/level/pathfinder/PathComputationType;", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class GlowingPlanktonBlock
extends Block
implements SimpleWaterloggedBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final BooleanProperty LIT;
    @NotNull
    private static final IntegerProperty LIGHT_LEVEL;
    @NotNull
    private static final VoxelShape SHAPE;

    public GlowingPlanktonBlock(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings.lightLevel(GlowingPlanktonBlock::_init_$lambda$0));
        Object object = ((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
        this.registerDefaultState((BlockState)object);
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        FluidState fluidStateAbove = world.getFluidState(pos.above());
        if (!fluidStateAbove.is(Fluids.EMPTY)) {
            return false;
        }
        BlockState stateBelow = world.getBlockState(pos.below());
        if (Intrinsics.areEqual((Object)stateBelow.getBlock(), (Object)((Object)this))) {
            return false;
        }
        FluidState fluidState = world.getFluidState(pos);
        return Intrinsics.areEqual((Object)fluidState, (Object)Fluids.WATER.getSource(false));
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        FluidState fluidState = world.getFluidState(pos);
        if (Intrinsics.areEqual((Object)fluidState, (Object)Fluids.WATER.getSource(false))) {
            BlockState blockState2 = super.getStateForPlacement(context);
            blockState = blockState2 != null ? (BlockState)blockState2.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)) : null;
        } else {
            blockState = null;
        }
        return blockState;
    }

    @NotNull
    protected FluidState getFluidState(@NotNull BlockState state) {
        FluidState fluidState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            FluidState fluidState2 = Fluids.WATER.getSource(false);
            fluidState = fluidState2;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState2, (String)"getSource(...)");
        } else {
            FluidState fluidState3 = super.getFluidState(state);
            fluidState = fluidState3;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState3, (String)"getFluidState(...)");
        }
        return fluidState;
    }

    protected boolean propagatesSkylightDown(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return true;
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.INVISIBLE;
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            BlockState blockState = Blocks.AIR.defaultBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
            return blockState;
        }
        BlockState blockState = super.updateShape(state, direction, neighborState, world, pos, neighborPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"updateShape(...)");
        return blockState;
    }

    protected void entityInside(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (world instanceof ServerLevel && !((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            world.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(7)));
            world.scheduleTick(pos, (Block)this, 20);
            double radius = 1.5;
            int particleCount = 5;
            RandomSource random = world.random;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = random.nextDouble() * (double)2 * radius - radius;
                double offsetY = random.nextDouble() * 0.25;
                double offsetZ = random.nextDouble() * (double)2 * radius - radius;
                double particleX = entity.getX() + offsetX;
                double particleY = entity.getY() + offsetY;
                double particleZ = entity.getZ() + offsetZ;
                ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.GLOW, particleX, particleY, particleZ, particleCount, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Integer lightLevel = (Integer)state.getValue((Property)LIGHT_LEVEL);
        if (lightLevel > 0) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(lightLevel - 1)));
            world.scheduleTick(pos, (Block)this, 20);
        } else if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.WATERLOGGED, LIT, LIGHT_LEVEL};
        builder.add(propertyArray);
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return true;
    }

    private static final int _init_$lambda$0(BlockState state) {
        Comparable comparable = state.getValue((Property)LIGHT_LEVEL);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        return ((Number)((Object)comparable)).intValue();
    }

    static {
        BooleanProperty booleanProperty = BooleanProperty.create((String)"lit");
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"create(...)");
        LIT = booleanProperty;
        IntegerProperty integerProperty = IntegerProperty.create((String)"light_level", (int)0, (int)7);
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty, (String)"create(...)");
        LIGHT_LEVEL = integerProperty;
        VoxelShape voxelShape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        SHAPE = voxelShape;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/hybridlabs/aquatic/block/GlowingPlanktonBlock$Companion;", "", "<init>", "()V", "LIT", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getLIT", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "LIGHT_LEVEL", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getLIGHT_LEVEL", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BooleanProperty getLIT() {
            return LIT;
        }

        @NotNull
        public final IntegerProperty getLIGHT_LEVEL() {
            return LIGHT_LEVEL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

