/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.block.entity;

import dev.hybridlabs.aquatic.block.entity.HybridAquaticBlockEntityTypes;
import dev.hybridlabs.aquatic.entity.fish.ClownfishEntity;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u0012J\b\u0010\u001d\u001a\u00020\u0012H\u0002J&\u0010\u001e\u001a\u00020\u001f\"\u000e\b\u0000\u0010 *\u0004\u0018\u00010\u0001*\u00020\u00022\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\"H\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\nH\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u00102\u0006\u0010,\u001a\u00020-H\u0014J\u0018\u00100\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u00102\u0006\u0010,\u001a\u00020-H\u0014J\b\u00101\u001a\u000202H\u0016R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Ldev/hybridlabs/aquatic/block/entity/AnemoneBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lsoftware/bernie/geckolib/animatable/GeoAnimatable;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "factory", "Lsoftware/bernie/geckolib/animatable/instance/AnimatableInstanceCache;", "kotlin.jvm.PlatformType", "hideTimer", "", "cooldownTimer", "hiddenClownfish", "Lnet/minecraft/nbt/CompoundTag;", "tick", "", "world", "Lnet/minecraft/world/level/Level;", "hideClownfish", "", "clownfish", "Ldev/hybridlabs/aquatic/entity/fish/ClownfishEntity;", "releaseClownfish", "releasePosition", "Lnet/minecraft/world/phys/Vec3;", "emergencyReleaseHiddenClownfish", "resetHiddenClownfish", "predicate", "Lsoftware/bernie/geckolib/animation/PlayState;", "E", "event", "Lsoftware/bernie/geckolib/animation/AnimationState;", "registerControllers", "controllerRegistrar", "Lsoftware/bernie/geckolib/animation/AnimatableManager$ControllerRegistrar;", "getAnimatableInstanceCache", "getTick", "", "o", "", "getUpdateTag", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "nbt", "loadAdditional", "getUpdatePacket", "Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nAnemoneBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnemoneBlockEntity.kt\ndev/hybridlabs/aquatic/block/entity/AnemoneBlockEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
public final class AnemoneBlockEntity
extends BlockEntity
implements GeoAnimatable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final AnimatableInstanceCache factory;
    private int hideTimer;
    private int cooldownTimer;
    @Nullable
    private CompoundTag hiddenClownfish;
    private static final int HIDE_DURATION = 200;
    private static final int COOLDOWN_DURATION = 40;
    @NotNull
    private static final RawAnimation SWAY_ANIMATION;
    @NotNull
    private static final List<String> IRRELEVANT_NBT_KEYS;

    public AnemoneBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(HybridAquaticBlockEntityTypes.INSTANCE.getANEMONE().get(), pos, state);
        this.factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    }

    public final void tick(@NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (world.isClientSide) {
            return;
        }
        CompoundTag clownfish = this.hiddenClownfish;
        if (clownfish != null) {
            if (this.hideTimer > 0) {
                int n = this.hideTimer;
                this.hideTimer = n + -1;
                if (this.hideTimer <= 0) {
                    Vec3 vec3 = Vec3.atCenterOf((Vec3i)((Vec3i)this.worldPosition)).add(0.0, 1.0, 0.0);
                    Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
                    this.releaseClownfish(vec3);
                    this.resetHiddenClownfish();
                }
                this.setChanged();
            }
        } else if (this.cooldownTimer > 0) {
            int n = this.cooldownTimer;
            this.cooldownTimer = n + -1;
            this.setChanged();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hideClownfish(@NotNull ClownfishEntity clownfish) {
        void p0;
        CompoundTag compoundTag;
        Intrinsics.checkNotNullParameter((Object)((Object)clownfish), (String)"clownfish");
        if (this.cooldownTimer > 0) {
            return false;
        }
        if (this.hiddenClownfish != null) {
            return false;
        }
        clownfish.stopRiding();
        clownfish.ejectPassengers();
        CompoundTag compoundTag2 = compoundTag = new CompoundTag();
        AnemoneBlockEntity anemoneBlockEntity = this;
        boolean bl = false;
        clownfish.addAdditionalSaveData((CompoundTag)p0);
        anemoneBlockEntity.hiddenClownfish = compoundTag;
        this.hideTimer = 200;
        this.setChanged();
        return true;
    }

    private final boolean releaseClownfish(Vec3 releasePosition) {
        Level level = this.level;
        if (level == null) {
            return false;
        }
        Level world = level;
        CompoundTag compoundTag = this.hiddenClownfish;
        if (compoundTag == null) {
            return false;
        }
        CompoundTag hiddenNbt = compoundTag;
        CompoundTag nbt = hiddenNbt.copy();
        Intrinsics.checkNotNull((Object)nbt);
        Companion.removeIrrelevantNbtKeys(nbt);
        Entity clownfish = EntityType.loadEntityRecursive((CompoundTag)nbt, (Level)world, Function.identity());
        if (!(clownfish instanceof ClownfishEntity)) {
            return false;
        }
        ((ClownfishEntity)clownfish).moveTo(releasePosition.x, releasePosition.y, releasePosition.z, 0.0f, 0.0f);
        Level level2 = this.level;
        Intrinsics.checkNotNull((Object)level2);
        level2.addFreshEntity(clownfish);
        return true;
    }

    public final void emergencyReleaseHiddenClownfish() {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)((Vec3i)this.worldPosition));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"atCenterOf(...)");
        this.releaseClownfish(vec3);
    }

    private final void resetHiddenClownfish() {
        this.hiddenClownfish = null;
        this.hideTimer = 0;
        this.cooldownTimer = 40;
    }

    private final <E extends BlockEntity> PlayState predicate(AnimationState<E> event) {
        PlayState playState;
        if (this.level != null) {
            event.getController().setAnimation(SWAY_ANIMATION);
            playState = PlayState.CONTINUE;
        } else {
            playState = PlayState.STOP;
        }
        return playState;
    }

    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllerRegistrar) {
        Intrinsics.checkNotNullParameter((Object)controllerRegistrar, (String)"controllerRegistrar");
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    @NotNull
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        AnimatableInstanceCache animatableInstanceCache = this.factory;
        Intrinsics.checkNotNullExpressionValue((Object)animatableInstanceCache, (String)"factory");
        return animatableInstanceCache;
    }

    public double getTick(@NotNull Object o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        return RenderUtil.getCurrentTick();
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag compoundTag = this.saveWithoutMetadata(registries);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag compoundTag = this.hiddenClownfish;
        if (compoundTag != null) {
            CompoundTag clownfishNbt = compoundTag;
            boolean bl = false;
            nbt.put("clownfish", (Tag)clownfishNbt);
        }
        nbt.putInt("hide_timer", this.hideTimer);
        nbt.putInt("cooldown_timer", this.cooldownTimer);
    }

    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        if (nbt.contains("clownfish", 10)) {
            CompoundTag clownfishNbt;
            this.hiddenClownfish = clownfishNbt = nbt.getCompound("clownfish");
        }
        this.hideTimer = nbt.getInt("hide_timer");
        this.cooldownTimer = nbt.getInt("cooldown_timer");
    }

    @NotNull
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return clientboundBlockEntityDataPacket;
    }

    static {
        RawAnimation rawAnimation = RawAnimation.begin().then("sway", Animation.LoopType.LOOP);
        Intrinsics.checkNotNullExpressionValue((Object)rawAnimation, (String)"then(...)");
        SWAY_ANIMATION = rawAnimation;
        Object[] objectArray = new String[]{"Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "Passengers", "Leash", "UUID"};
        IRRELEVANT_NBT_KEYS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ldev/hybridlabs/aquatic/block/entity/AnemoneBlockEntity$Companion;", "", "<init>", "()V", "HIDE_DURATION", "", "COOLDOWN_DURATION", "SWAY_ANIMATION", "Lsoftware/bernie/geckolib/animation/RawAnimation;", "getSWAY_ANIMATION", "()Lsoftware/bernie/geckolib/animation/RawAnimation;", "IRRELEVANT_NBT_KEYS", "", "", "tick", "", "world", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Ldev/hybridlabs/aquatic/block/entity/AnemoneBlockEntity;", "removeIrrelevantNbtKeys", "compound", "Lnet/minecraft/nbt/CompoundTag;", "hybrid-aquatic-neoforge-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nAnemoneBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnemoneBlockEntity.kt\ndev/hybridlabs/aquatic/block/entity/AnemoneBlockEntity$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n1869#2,2:197\n*S KotlinDebug\n*F\n+ 1 AnemoneBlockEntity.kt\ndev/hybridlabs/aquatic/block/entity/AnemoneBlockEntity$Companion\n*L\n192#1:197,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RawAnimation getSWAY_ANIMATION() {
            return SWAY_ANIMATION;
        }

        public final void tick(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull AnemoneBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            blockEntity.tick(world);
        }

        public final void removeIrrelevantNbtKeys(@NotNull CompoundTag compound) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Iterable $this$forEach$iv = IRRELEVANT_NBT_KEYS;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String p0 = (String)element$iv;
                boolean bl = false;
                compound.remove(p0);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

