/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.client.model.entity.fish;

import dev.hybridlabs.aquatic.CommonClass;
import dev.hybridlabs.aquatic.client.model.entity.fish.HybridAquaticFishEntityModel;
import dev.hybridlabs.aquatic.entity.fish.HybridAquaticFishEntity;
import dev.hybridlabs.aquatic.entity.fish.MackerelEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J&\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Ldev/hybridlabs/aquatic/client/model/entity/fish/MackerelEntityModel;", "Ldev/hybridlabs/aquatic/client/model/entity/fish/HybridAquaticFishEntityModel;", "Ldev/hybridlabs/aquatic/entity/fish/MackerelEntity;", "<init>", "()V", "getModelResource", "Lnet/minecraft/resources/ResourceLocation;", "animatable", "getAnimationResource", "setCustomAnimations", "", "instanceId", "", "animationState", "Lsoftware/bernie/geckolib/animation/AnimationState;", "hybrid-aquatic-neoforge-1.21.1"})
public final class MackerelEntityModel
extends HybridAquaticFishEntityModel<MackerelEntity> {
    public MackerelEntityModel() {
        super("mackerel");
    }

    @Override
    @NotNull
    public ResourceLocation getModelResource(@NotNull MackerelEntity animatable) {
        Intrinsics.checkNotNullParameter((Object)((Object)animatable), (String)"animatable");
        int fish = animatable.getFishCount();
        String modelPath = switch (fish) {
            case 1 -> "geo/fish/mackerel/mackerel.geo.json";
            case 2 -> "geo/fish/mackerel/mackerel_two.geo.json";
            case 3 -> "geo/fish/mackerel/mackerel_three.geo.json";
            default -> "geo/fish/mackerel/mackerel.geo.json";
        };
        ResourceLocation resourceLocation = CommonClass.locate(modelPath);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"locate(...)");
        return resourceLocation;
    }

    @Override
    @NotNull
    public ResourceLocation getAnimationResource(@NotNull MackerelEntity animatable) {
        Intrinsics.checkNotNullParameter((Object)((Object)animatable), (String)"animatable");
        int fish = animatable.getFishCount();
        String animationPath = switch (fish) {
            case 1 -> "animations/mackerel.animation.json";
            case 2 -> "animations/mackerel_two.animation.json";
            case 3 -> "animations/mackerel_three.animation.json";
            default -> "animations/mackerel.animation.json";
        };
        ResourceLocation resourceLocation = CommonClass.locate(animationPath);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"locate(...)");
        return resourceLocation;
    }

    @Override
    public void setCustomAnimations(@NotNull MackerelEntity animatable, long instanceId, @NotNull AnimationState<MackerelEntity> animationState) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)animatable), (String)"animatable");
            Intrinsics.checkNotNullParameter(animationState, (String)"animationState");
            super.setCustomAnimations((HybridAquaticFishEntity)animatable, instanceId, animationState);
            float deltaTime = Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
            GeoBone body = this.getAnimationProcessor().getBone("body");
            GeoBone body2 = this.getAnimationProcessor().getBone("body2");
            GeoBone body3 = this.getAnimationProcessor().getBone("body3");
            float xRot = Mth.clamp((float)Mth.lerp((float)deltaTime, (float)animatable.getXRot(), (float)animatable.xRotO), (float)-45.0f, (float)45.0f);
            body.setRotX(xRot * ((float)(-Math.PI) / 180));
            GeoBone geoBone = body2;
            if (geoBone != null) {
                geoBone.setRotX(xRot * ((float)(-Math.PI) / 180));
            }
            GeoBone geoBone2 = body3;
            if (geoBone2 == null) break block1;
            geoBone2.setRotX(xRot * ((float)(-Math.PI) / 180));
        }
    }
}

