/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.hybridlabs.aquatic.config.HybridAquaticConfig;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u00140\u0013J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Ldev/hybridlabs/aquatic/config/HybridAquaticConfigHandler;", "", "file", "Ljava/io/File;", "defaultConfig", "Ldev/hybridlabs/aquatic/config/HybridAquaticConfig;", "<init>", "(Ljava/io/File;Ldev/hybridlabs/aquatic/config/HybridAquaticConfig;)V", "getFile", "()Ljava/io/File;", "getDefaultConfig", "()Ldev/hybridlabs/aquatic/config/HybridAquaticConfig;", "backupFile", "getBackupFile", "config", "getConfig", "setConfig", "(Ldev/hybridlabs/aquatic/config/HybridAquaticConfig;)V", "read", "Lcom/mojang/serialization/DataResult;", "Lcom/mojang/datafixers/util/Pair;", "Lcom/google/gson/JsonElement;", "load", "", "save", "backup", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nHybridAquaticConfigHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HybridAquaticConfigHandler.kt\ndev/hybridlabs/aquatic/config/HybridAquaticConfigHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class HybridAquaticConfigHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @NotNull
    private final HybridAquaticConfig defaultConfig;
    @NotNull
    private final File backupFile;
    @NotNull
    private HybridAquaticConfig config;
    @NotNull
    private static final Gson GSON;

    public HybridAquaticConfigHandler(@NotNull File file, @NotNull HybridAquaticConfig defaultConfig) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)defaultConfig, (String)"defaultConfig");
        this.file = file;
        this.defaultConfig = defaultConfig;
        File file2 = this.file.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
        this.backupFile = FilesKt.resolve((File)file2, (String)(this.file.getName() + "-backup"));
        this.config = this.defaultConfig;
    }

    public /* synthetic */ HybridAquaticConfigHandler(File file, HybridAquaticConfig hybridAquaticConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            hybridAquaticConfig = new HybridAquaticConfig(0, null, false, 7, null);
        }
        this(file, hybridAquaticConfig);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final HybridAquaticConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    @NotNull
    public final File getBackupFile() {
        return this.backupFile;
    }

    @NotNull
    public final HybridAquaticConfig getConfig() {
        return this.config;
    }

    public final void setConfig(@NotNull HybridAquaticConfig hybridAquaticConfig) {
        Intrinsics.checkNotNullParameter((Object)hybridAquaticConfig, (String)"<set-?>");
        this.config = hybridAquaticConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DataResult<Pair<HybridAquaticConfig, JsonElement>> read() {
        JsonElement jsonElement;
        Object object = this.file;
        Object object2 = Charsets.UTF_8;
        object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2);
        object2 = null;
        try {
            Reader p0 = (Reader)object;
            boolean bl = false;
            jsonElement = JsonParser.parseReader((Reader)p0);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        JsonElement json = jsonElement;
        DataResult dataResult = HybridAquaticConfig.Companion.getCODEC().decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"decode(...)");
        return dataResult;
    }

    public final boolean load() {
        DataResult<Pair<HybridAquaticConfig, JsonElement>> dataResult = this.read();
        Optional result = dataResult.result();
        if (!result.isPresent()) {
            return false;
        }
        Object object = ((Pair)result.get()).getFirst();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getFirst(...)");
        this.config = (HybridAquaticConfig)object;
        return true;
    }

    public final boolean save() {
        DataResult dataResult = HybridAquaticConfig.Companion.getCODEC().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.config);
        Optional result = dataResult.result();
        if (!result.isPresent()) {
            return false;
        }
        Object t = result.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        JsonElement json = (JsonElement)t;
        String text = GSON.toJson(json);
        Intrinsics.checkNotNull((Object)text);
        FilesKt.writeText$default((File)this.file, (String)text, null, (int)2, null);
        return true;
    }

    public final boolean backup() {
        Object object;
        Object object2 = this;
        try {
            HybridAquaticConfigHandler $this$backup_u24lambda_u240 = object2;
            boolean bl = false;
            FilesKt.writeBytes((File)$this$backup_u24lambda_u240.backupFile, (byte[])FilesKt.readBytes((File)$this$backup_u24lambda_u240.file));
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Result.isFailure-impl((Object)object2) ? null : object2) != null;
    }

    static {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        GSON = gson;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/hybridlabs/aquatic/config/HybridAquaticConfigHandler$Companion;", "", "<init>", "()V", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson getGSON() {
            return GSON;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

