/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.effect;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Ldev/hybridlabs/aquatic/effect/CorrosionMobEffect;", "Lnet/minecraft/world/effect/MobEffect;", "<init>", "()V", "applyEffectTick", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "amplifier", "", "shouldApplyEffectTickThisTick", "duration", "corrodeTool", "", "damage", "corrodeArmor", "hybrid-aquatic-neoforge-1.21.1"})
public final class CorrosionMobEffect
extends MobEffect {
    public CorrosionMobEffect() {
        super(MobEffectCategory.HARMFUL, 10326326);
    }

    public boolean applyEffectTick(@NotNull LivingEntity entity, int amplifier) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity.level().isClientSide) {
            return false;
        }
        int damage = amplifier + 1;
        this.corrodeTool(entity, damage);
        this.corrodeArmor(entity, damage);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 20 == 0;
    }

    private final void corrodeTool(LivingEntity entity, int damage) {
        ItemStack offHandStack;
        ItemStack mainHandStack = entity.getMainHandItem();
        if (mainHandStack.isDamageableItem()) {
            mainHandStack.hurtAndBreak(damage, entity, entity.getEquipmentSlotForItem(mainHandStack));
        }
        if ((offHandStack = entity.getOffhandItem()).isDamageableItem()) {
            mainHandStack.hurtAndBreak(1, entity, entity.getEquipmentSlotForItem(mainHandStack));
        }
    }

    private final void corrodeArmor(LivingEntity entity, int damage) {
        for (EquipmentSlot slot : EntriesMappings.entries$0) {
            ItemStack armorStack = entity.getItemBySlot(slot);
            if (!armorStack.isDamageableItem()) continue;
            armorStack.hurtAndBreak(damage, entity, entity.getEquipmentSlotForItem(armorStack));
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EquipmentSlot> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EquipmentSlot.values()));
        }
    }
}

