/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.ai.goal;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\tH\u0016J(\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J(\u0010\u0011\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\b\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/hybridlabs/aquatic/entity/ai/goal/HybridAquaticJumpGoal;", "Lnet/minecraft/world/entity/ai/goal/JumpGoal;", "mob", "Lnet/minecraft/world/entity/PathfinderMob;", "chance", "", "<init>", "(Lnet/minecraft/world/entity/PathfinderMob;I)V", "inWater", "", "canUse", "isWaterAt", "pos", "Lnet/minecraft/core/BlockPos;", "offsetX", "offsetZ", "multiplier", "isAirAbove", "canContinueToUse", "isInterruptable", "start", "", "stop", "tick", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class HybridAquaticJumpGoal
extends JumpGoal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PathfinderMob mob;
    private final int chance;
    private boolean inWater;
    @NotNull
    private static final int[] OFFSET_MULTIPLIERS;

    public HybridAquaticJumpGoal(@NotNull PathfinderMob mob, int chance) {
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        this.mob = mob;
        this.chance = JumpGoal.reducedTickDelay((int)chance);
    }

    public boolean canUse() {
        boolean bl;
        if (this.mob.getRandom().nextInt(this.chance) != 0) {
            bl = false;
        } else {
            Direction direction = this.mob.getMotionDirection();
            int i = direction.getStepX();
            int j = direction.getStepZ();
            BlockPos blockPos = this.mob.blockPosition();
            for (int k : OFFSET_MULTIPLIERS) {
                Intrinsics.checkNotNull((Object)blockPos);
                if (this.isWaterAt(blockPos, i, j, k) && this.isAirAbove(blockPos, i, j, k)) continue;
                return false;
            }
            bl = true;
        }
        return bl;
    }

    private final boolean isWaterAt(BlockPos pos, int offsetX, int offsetZ, int multiplier) {
        BlockPos blockPos = pos.offset(offsetX * multiplier, 0, offsetZ * multiplier);
        return this.mob.level().getFluidState(blockPos).is(FluidTags.WATER) && !this.mob.level().getBlockState(blockPos).blocksMotion();
    }

    private final boolean isAirAbove(BlockPos pos, int offsetX, int offsetZ, int multiplier) {
        return this.mob.level().getBlockState(pos.offset(offsetX * multiplier, 1, offsetZ * multiplier)).isAir() && this.mob.level().getBlockState(pos.offset(offsetX * multiplier, 2, offsetZ * multiplier)).isAir();
    }

    public boolean canContinueToUse() {
        double d = this.mob.getDeltaMovement().y;
        return !(d * d < (double)0.03f && !(this.mob.getXRot() == 0.0f) && Math.abs(this.mob.getXRot()) < 10.0f && this.mob.isInWater() || this.mob.onGround());
    }

    public boolean isInterruptable() {
        return false;
    }

    public void start() {
        Direction direction = this.mob.getMotionDirection();
        this.mob.setDeltaMovement(this.mob.getDeltaMovement().add((double)direction.getStepX() * 0.6, 0.7, (double)direction.getStepZ() * 0.6));
        this.mob.getNavigation().stop();
    }

    public void stop() {
        this.mob.setXRot(0.0f);
    }

    public void tick() {
        boolean bl = this.inWater;
        if (!bl) {
            FluidState fluidState = this.mob.level().getFluidState(this.mob.blockPosition());
            this.inWater = fluidState.is(FluidTags.WATER);
        }
        if (this.inWater && !bl) {
            this.mob.playSound(SoundEvents.DOLPHIN_JUMP, 1.0f, 1.0f);
        }
        Vec3 vec3d = this.mob.getDeltaMovement();
        if (vec3d.y * vec3d.y < (double)0.03f && !(this.mob.getXRot() == 0.0f)) {
            this.mob.setXRot(Mth.rotLerp((float)0.2f, (float)this.mob.getXRot(), (float)0.0f));
        } else if (vec3d.length() > (double)1.0E-5f) {
            double d = vec3d.length();
            double e = Math.atan2(-vec3d.y, d) * 57.2957763671875;
            this.mob.setXRot((float)e);
        }
    }

    static {
        int[] nArray = new int[]{0, 1, 4, 5, 6, 7};
        OFFSET_MULTIPLIERS = nArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/hybridlabs/aquatic/entity/ai/goal/HybridAquaticJumpGoal$Companion;", "", "<init>", "()V", "OFFSET_MULTIPLIERS", "", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

