/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.ai.goal;

import dev.hybridlabs.aquatic.effect.HybridAquaticMobEffects;
import dev.hybridlabs.aquatic.entity.shark.HybridAquaticSharkEntity;
import dev.hybridlabs.aquatic.item.HybridAquaticItems;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0011H\u0014J\b\u0010\u001a\u001a\u00020\u0014H\u0014J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0011H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/hybridlabs/aquatic/entity/ai/goal/SharkAttackGoal;", "Lnet/minecraft/world/entity/ai/goal/MeleeAttackGoal;", "shark", "Ldev/hybridlabs/aquatic/entity/shark/HybridAquaticSharkEntity;", "speedMultiplier", "", "followingTargetEvenIfNotSeen", "", "<init>", "(Ldev/hybridlabs/aquatic/entity/shark/HybridAquaticSharkEntity;DZ)V", "getShark", "()Ldev/hybridlabs/aquatic/entity/shark/HybridAquaticSharkEntity;", "ticksUntilNextPathRecalculation", "", "ticksUntilNextAttack", "attackDelayTicks", "pendingTarget", "Lnet/minecraft/world/entity/LivingEntity;", "canUse", "start", "", "stop", "requiresUpdateEveryTick", "tick", "checkAndPerformAttack", "enemy", "resetAttackCooldown", "canPerformAttack", "attackTarget", "hybrid-aquatic-neoforge-1.21.1"})
public class SharkAttackGoal
extends MeleeAttackGoal {
    @NotNull
    private final HybridAquaticSharkEntity shark;
    private final double speedMultiplier;
    private final boolean followingTargetEvenIfNotSeen;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private int attackDelayTicks;
    @Nullable
    private LivingEntity pendingTarget;

    public SharkAttackGoal(@NotNull HybridAquaticSharkEntity shark, double speedMultiplier, boolean followingTargetEvenIfNotSeen) {
        Intrinsics.checkNotNullParameter((Object)((Object)shark), (String)"shark");
        super((PathfinderMob)shark, speedMultiplier, true);
        this.shark = shark;
        this.speedMultiplier = speedMultiplier;
        this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
        this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.LOOK));
    }

    public /* synthetic */ SharkAttackGoal(HybridAquaticSharkEntity hybridAquaticSharkEntity, double d, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        this(hybridAquaticSharkEntity, d, bl);
    }

    @NotNull
    protected final HybridAquaticSharkEntity getShark() {
        return this.shark;
    }

    public boolean canUse() {
        if (this.shark.getFromFishingNet()) {
            return false;
        }
        return super.canUse();
    }

    public void start() {
        this.shark.setSprinting(true);
        super.start();
    }

    public void stop() {
        this.shark.setSprinting(false);
        super.stop();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.attackDelayTicks > 0) {
            int n = this.attackDelayTicks;
            this.attackDelayTicks = n + -1;
            if (this.attackDelayTicks == 0 && this.pendingTarget != null && !this.shark.level().isClientSide) {
                ItemStack itemInUse;
                LivingEntity livingEntity = this.pendingTarget;
                Intrinsics.checkNotNull((Object)livingEntity);
                this.shark.doHurtTarget((Entity)livingEntity);
                LivingEntity target = this.pendingTarget;
                if (target instanceof Player && (itemInUse = ((Player)target).getUseItem()).is(Items.SHIELD)) {
                    ((Player)target).disableShield();
                    ((Player)target).level().broadcastEntityEvent((Entity)target, (byte)30);
                }
                this.resetAttackCooldown();
                this.pendingTarget = null;
            }
        }
        LivingEntity livingEntity = this.shark.getTarget();
        if (!this.shark.getNavigation().isInProgress() && livingEntity != null) {
            this.shark.getNavigation().moveTo((Entity)livingEntity, this.speedMultiplier);
        }
        if (livingEntity != null) {
            if (this.shark.distanceToSqr((Entity)livingEntity) < 16.0) {
                this.shark.getLookControl().setLookAt((Entity)livingEntity, 10.0f, 10.0f);
            }
            this.ticksUntilNextPathRecalculation = (int)Math.max((double)(this.ticksUntilNextPathRecalculation - 1), 0.0);
            if ((this.followingTargetEvenIfNotSeen || this.shark.getSensing().hasLineOfSight((Entity)livingEntity)) && this.ticksUntilNextPathRecalculation <= 0) {
                this.shark.getNavigation().moveTo((Entity)livingEntity, this.speedMultiplier);
                this.ticksUntilNextPathRecalculation = 20;
            }
            this.ticksUntilNextAttack = (int)Math.max((double)(this.ticksUntilNextAttack - 1), 0.0);
            this.checkAndPerformAttack(livingEntity);
        }
    }

    protected void checkAndPerformAttack(@NotNull LivingEntity enemy) {
        Intrinsics.checkNotNullParameter((Object)enemy, (String)"enemy");
        if (this.canPerformAttack(enemy) && this.ticksUntilNextAttack <= 0 && this.attackDelayTicks == 0) {
            boolean hasShield;
            this.shark.swing(InteractionHand.MAIN_HAND);
            this.shark.doHurtTarget((Entity)enemy);
            enemy.addEffect(new MobEffectInstance(HybridAquaticMobEffects.INSTANCE.getBLEEDING().asHolder(), 200, 0), (Entity)this.shark);
            if (enemy.getHealth() <= 0.0f) {
                this.shark.setHunger(2400);
            }
            this.shark.setHealth(this.shark.getMaxHealth());
            boolean bl = hasShield = enemy.getMainHandItem().is(Items.SHIELD) || enemy.getOffhandItem().is(Items.SHIELD);
            if (hasShield && enemy.isBlocking()) {
                this.shark.spawnAtLocation((ItemLike)HybridAquaticItems.INSTANCE.getSHARK_TOOTH().get());
            }
            this.resetAttackCooldown();
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(20);
    }

    protected boolean canPerformAttack(@NotNull LivingEntity attackTarget) {
        Intrinsics.checkNotNullParameter((Object)attackTarget, (String)"attackTarget");
        return this.shark.distanceToSqr((Entity)attackTarget) <= (double)(this.shark.getBbWidth() * 1.75f * this.shark.getBbWidth() * 1.75f + attackTarget.getBbWidth());
    }
}

