/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.ai.goal.boids;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/hybridlabs/aquatic/entity/ai/goal/boids/HeightBoundsGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "mob", "Lnet/minecraft/world/entity/Mob;", "minHeight", "", "maxHeight", "<init>", "(Lnet/minecraft/world/entity/Mob;FF)V", "canUse", "", "tick", "", "bounds", "Lnet/minecraft/world/phys/Vec3;", "hybrid-aquatic-neoforge-1.21.1"})
public final class HeightBoundsGoal
extends Goal {
    @NotNull
    private final Mob mob;
    private final float minHeight;
    private final float maxHeight;

    public HeightBoundsGoal(@NotNull Mob mob, float minHeight, float maxHeight) {
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        this.mob = mob;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    public boolean canUse() {
        return this.mob.getY() > (double)this.maxHeight || this.mob.getY() < (double)this.maxHeight;
    }

    public void tick() {
        this.mob.addDeltaMovement(this.bounds());
    }

    private final Vec3 bounds() {
        double amount = 0.1;
        float dY = Mth.abs((float)((float)this.mob.getDeltaMovement().y));
        if ((double)dY > amount) {
            amount = dY;
        }
        if (this.mob.getY() > (double)this.maxHeight) {
            return new Vec3(0.0, -amount, 0.0);
        }
        if (this.mob.getY() < (double)this.minHeight) {
            return new Vec3(0.0, amount, 0.0);
        }
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        return vec3;
    }
}

