/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.cephalopod;

import dev.hybridlabs.aquatic.entity.fish.HybridAquaticFishEntity;
import dev.hybridlabs.aquatic.entity.mammal.HybridAquaticMammalEntity;
import dev.hybridlabs.aquatic.entity.shark.HybridAquaticSharkEntity;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 e2\u00020\u00012\u00020\u0002:\u0002deBY\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\b\u0012\u0016\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\b0\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0014J,\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0005\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010#H\u0016J\b\u0010*\u001a\u00020\fH\u0016J\b\u0010+\u001a\u00020\u001eH\u0016J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.H\u0014J\b\u0010/\u001a\u00020.H\u0002J\u0018\u00100\u001a\u00020\f2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u00020\u001eH\u0002J\b\u00106\u001a\u000207H\u0014J\u0010\u00108\u001a\u00020\u001e2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u001e2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020AH\u0016J\u0018\u0010B\u001a\u00020\u001e2\u0006\u00101\u001a\u0002022\u0006\u0010C\u001a\u00020\fH\u0014J\b\u0010D\u001a\u00020.H\u0016J\b\u0010E\u001a\u00020FH\u0014J\u0010\u0010G\u001a\u00020F2\u0006\u00101\u001a\u000202H\u0014J\b\u0010H\u001a\u00020FH\u0014J\b\u0010I\u001a\u00020FH\u0002J\u0010\u0010J\u001a\u00020K2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010L\u001a\u00020\f2\u0006\u0010M\u001a\u00020NH\u0016J\u0010\u0010]\u001a\u00020\u001e2\u0006\u0010^\u001a\u00020_H\u0016J\b\u0010`\u001a\u00020\u001bH\u0016J\b\u0010a\u001a\u00020.H\u0014J\b\u0010b\u001a\u00020.H\u0014R\u001e\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\r\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0015\"\u0004\b\u0019\u0010\u0017R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010O\u001a\u00020.2\u0006\u0010O\u001a\u00020.8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010SR$\u0010T\u001a\u00020.2\u0006\u0010T\u001a\u00020.8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bU\u0010Q\"\u0004\bV\u0010SR$\u0010W\u001a\u00020.2\u0006\u0010W\u001a\u00020.8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bX\u0010Q\"\u0004\bY\u0010SR$\u0010Z\u001a\u00020\f2\u0006\u0010Z\u001a\u00020\f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b[\u0010\u0015\"\u0004\b\\\u0010\u0017R\u000e\u0010c\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticCephalopodEntity;", "Lnet/minecraft/world/entity/animal/WaterAnimal;", "Lsoftware/bernie/geckolib/animatable/GeoEntity;", "type", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "prey", "Lnet/minecraft/tags/TagKey;", "predator", "", "hasInk", "", "hasGlowInk", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;Lnet/minecraft/tags/TagKey;Ljava/util/List;ZZ)V", "getPrey", "()Lnet/minecraft/tags/TagKey;", "getPredator", "()Ljava/util/List;", "getHasInk", "()Z", "setHasInk", "(Z)V", "getHasGlowInk", "setHasGlowInk", "factory", "Lsoftware/bernie/geckolib/animatable/instance/AnimatableInstanceCache;", "kotlin.jvm.PlatformType", "registerGoals", "", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnReason", "Lnet/minecraft/world/entity/MobSpawnType;", "entityData", "isPushedByFluid", "tick", "handleAirSupply", "air", "", "getMaxMoistness", "hurt", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "squirt", "getInkParticle", "Lnet/minecraft/core/particles/SimpleParticleType;", "addAdditionalSaveData", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "removeWhenFarAway", "distanceSquared", "", "travel", "travelVector", "Lnet/minecraft/world/phys/Vec3;", "dropFromLootTable", "causedByPlayer", "getMaxSpawnClusterSize", "getAmbientSound", "Lnet/minecraft/sounds/SoundEvent;", "getHurtSound", "getDeathSound", "getSquirtSound", "createNavigation", "Lnet/minecraft/world/entity/ai/navigation/PathNavigation;", "isWithinMeleeAttackRange", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "moistness", "getMoistness", "()I", "setMoistness", "(I)V", "size", "getSize", "setSize", "hunger", "getHunger", "setHunger", "attemptAttack", "getAttemptAttack", "setAttemptAttack", "registerControllers", "controllers", "Lsoftware/bernie/geckolib/animation/AnimatableManager$ControllerRegistrar;", "getAnimatableInstanceCache", "getMinSize", "getMaxSize", "fromFishingNet", "CephalopodAttackGoal", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nHybridAquaticCephalopodEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HybridAquaticCephalopodEntity.kt\ndev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticCephalopodEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,405:1\n1761#2,3:406\n*S KotlinDebug\n*F\n+ 1 HybridAquaticCephalopodEntity.kt\ndev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticCephalopodEntity\n*L\n61#1:406,3\n*E\n"})
public class HybridAquaticCephalopodEntity
extends WaterAnimal
implements GeoEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TagKey<EntityType<?>> prey;
    @NotNull
    private final List<TagKey<EntityType<?>>> predator;
    private boolean hasInk;
    private boolean hasGlowInk;
    private final AnimatableInstanceCache factory;
    private boolean fromFishingNet;
    @NotNull
    private static final EntityDataAccessor<Integer> MOISTNESS;
    @NotNull
    private static final EntityDataAccessor<Integer> CEPHALOPOD_SIZE;
    @NotNull
    private static final EntityDataAccessor<Integer> HUNGER;
    @NotNull
    private static final EntityDataAccessor<Boolean> ATTEMPT_ATTACK;
    public static final int MAX_HUNGER = 2400;
    @NotNull
    public static final String HUNGER_KEY = "Hunger";
    @NotNull
    public static final String MOISTNESS_KEY = "Moistness";
    @NotNull
    public static final String CEPHALOPOD_SIZE_KEY = "CephalopodSize";

    public HybridAquaticCephalopodEntity(@NotNull EntityType<? extends HybridAquaticCephalopodEntity> type, @NotNull Level world, @NotNull TagKey<EntityType<?>> prey, @NotNull List<TagKey<EntityType<?>>> predator, boolean hasInk, boolean hasGlowInk) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(prey, (String)"prey");
        Intrinsics.checkNotNullParameter(predator, (String)"predator");
        super(type, world);
        this.prey = prey;
        this.predator = predator;
        this.hasInk = hasInk;
        this.hasGlowInk = hasGlowInk;
        this.factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)((GeoAnimatable)this));
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = (MoveControl)new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, false);
        this.lookControl = (LookControl)new SmoothSwimmingLookControl((Mob)this, 10);
        this.navigation = (PathNavigation)new WaterBoundPathNavigation((Mob)this, world);
    }

    @NotNull
    public TagKey<EntityType<?>> getPrey() {
        return this.prey;
    }

    @NotNull
    public List<TagKey<EntityType<?>>> getPredator() {
        return this.predator;
    }

    public boolean getHasInk() {
        return this.hasInk;
    }

    public void setHasInk(boolean bl) {
        this.hasInk = bl;
    }

    public boolean getHasGlowInk() {
        return this.hasGlowInk;
    }

    public void setHasGlowInk(boolean bl) {
        this.hasGlowInk = bl;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.goalSelector.addGoal(2, (Goal)new CephalopodAttackGoal(this));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 8.0f, 1.0, 1.0, arg_0 -> HybridAquaticCephalopodEntity.registerGoals$lambda$0(this, arg_0)));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, true, arg_0 -> HybridAquaticCephalopodEntity.registerGoals$lambda$1(this, arg_0)));
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(MOISTNESS, (Object)this.getMaxMoistness());
        builder.define(CEPHALOPOD_SIZE, (Object)0);
        builder.define(ATTEMPT_ATTACK, (Object)false);
        builder.define(HUNGER, (Object)2400);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnReason, (String)"spawnReason");
        this.setSize(this.random.nextIntBetweenInclusive(this.getMinSize(), this.getMaxSize()));
        this.setXRot(0.0f);
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void tick() {
        super.tick();
        if (this.isInWaterRainOrBubble()) {
            this.setMoistness(this.getMaxMoistness());
        } else {
            this.setMoistness(this.getMoistness() - 1);
            if (this.getMoistness() <= -20) {
                this.setMoistness(0);
                DamageSource damageSource = this.damageSources().dryOut();
                Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"dryOut(...)");
                this.hurt(damageSource, 1.0f);
            }
            if (!this.isUnderWater()) {
                this.setXRot(0.0f);
                this.setYRot(this.yRotO);
                this.yHeadRot = this.yHeadRotO;
            }
        }
        this.setSprinting(this.isAggressive());
        if (this.getHunger() > 0) {
            this.setHunger(this.getHunger() - 1);
        }
    }

    protected void handleAirSupply(int air) {
    }

    private final int getMaxMoistness() {
        return 600;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (super.hurt(source, amount) && this.getLastHurtByMob() != null) {
            if (!this.level().isClientSide) {
                Vec3 attackerPos;
                if (this.isUnderWater() && this.getHasInk() || this.getHasGlowInk()) {
                    this.squirt();
                }
                LivingEntity livingEntity = this.getLastHurtByMob();
                Object object = attackerPos = livingEntity != null ? livingEntity.position() : null;
                if (attackerPos != null) {
                    Vec3 directionAway = this.position().subtract(attackerPos).normalize().scale(10.0);
                    Vec3 targetPos = this.position().add(directionAway.x, 0.0, directionAway.z);
                    this.navigation.moveTo(targetPos.x, targetPos.y, targetPos.z, 1.5);
                }
            }
            return true;
        }
        return false;
    }

    private final void squirt() {
        this.playSound(this.getSquirtSound(), this.getSoundVolume(), this.getVoicePitch());
        Vec3 entityPosition = new Vec3(this.getX(), this.getY(), this.getZ());
        double radius = 3.0;
        List affectedEntities = this.level().getEntitiesOfClass(LivingEntity.class, new AABB(entityPosition.x - radius, entityPosition.y - radius, entityPosition.z - radius, entityPosition.x + radius, entityPosition.y + radius, entityPosition.z + radius), arg_0 -> HybridAquaticCephalopodEntity.squirt$lambda$1(arg_0 -> HybridAquaticCephalopodEntity.squirt$lambda$0(this, arg_0), arg_0));
        for (LivingEntity entity : affectedEntities) {
            entity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100, 0));
            entity.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 100, 0));
        }
        for (int i = 0; i < 200; ++i) {
            double offsetX = (this.random.nextDouble() - 0.5) * 2.0;
            double offsetY = (this.random.nextDouble() - 0.5) * 2.0;
            double offsetZ = (this.random.nextDouble() - 0.5) * 2.0;
            double randomMultiplier = 0.5 + this.random.nextDouble() * 1.5;
            Vec3 velocity = new Vec3(offsetX, offsetY, offsetZ).normalize().scale(randomMultiplier);
            Level level = this.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ((ServerLevel)level).sendParticles((ParticleOptions)this.getInkParticle(), entityPosition.x, entityPosition.y, entityPosition.z, 1, velocity.x * 0.25, velocity.y * 0.25, velocity.z * 0.25, 0.1);
        }
    }

    @NotNull
    protected SimpleParticleType getInkParticle() {
        SimpleParticleType simpleParticleType;
        if (this.getHasGlowInk()) {
            SimpleParticleType simpleParticleType2 = ParticleTypes.GLOW_SQUID_INK;
            Intrinsics.checkNotNull((Object)simpleParticleType2);
            simpleParticleType = simpleParticleType2;
        } else {
            SimpleParticleType simpleParticleType3 = ParticleTypes.SQUID_INK;
            Intrinsics.checkNotNull((Object)simpleParticleType3);
            simpleParticleType = simpleParticleType3;
        }
        return simpleParticleType;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.addAdditionalSaveData(nbt);
        nbt.putInt(MOISTNESS_KEY, this.getMoistness());
        nbt.putInt(CEPHALOPOD_SIZE_KEY, this.getSize());
        nbt.putInt(HUNGER_KEY, this.getHunger());
        nbt.putBoolean("FromFishingNet", this.fromFishingNet);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.readAdditionalSaveData(nbt);
        this.setMoistness(nbt.getInt(MOISTNESS_KEY));
        this.setSize(nbt.getInt(CEPHALOPOD_SIZE_KEY));
        this.setHunger(nbt.getInt(HUNGER_KEY));
        this.fromFishingNet = nbt.getBoolean("FromFishingNet");
    }

    public boolean removeWhenFarAway(double distanceSquared) {
        return !this.fromFishingNet && !this.hasCustomName();
    }

    public void travel(@NotNull Vec3 travelVector) {
        Intrinsics.checkNotNullParameter((Object)travelVector, (String)"travelVector");
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(travelVector);
        }
    }

    protected void dropFromLootTable(@NotNull DamageSource source, boolean causedByPlayer) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Entity attacker = source.getDirectEntity();
        if (!(attacker instanceof HybridAquaticFishEntity || attacker instanceof HybridAquaticSharkEntity || attacker instanceof HybridAquaticCephalopodEntity || attacker instanceof HybridAquaticMammalEntity)) {
            super.dropFromLootTable(source, causedByPlayer);
        }
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    @NotNull
    protected SoundEvent getAmbientSound() {
        SoundEvent soundEvent = SoundEvents.SQUID_AMBIENT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"SQUID_AMBIENT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        SoundEvent soundEvent = SoundEvents.SQUID_HURT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"SQUID_HURT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        SoundEvent soundEvent = SoundEvents.SQUID_DEATH;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"SQUID_DEATH");
        return soundEvent;
    }

    private final SoundEvent getSquirtSound() {
        SoundEvent soundEvent = SoundEvents.SQUID_SQUIRT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"SQUID_SQUIRT");
        return soundEvent;
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return (PathNavigation)new WaterBoundPathNavigation((Mob)this, world);
    }

    public boolean isWithinMeleeAttackRange(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return (double)(1.25f + entity.getBbWidth()) <= this.distanceToSqr((Entity)entity);
    }

    private final int getMoistness() {
        Object object = this.entityData.get(MOISTNESS);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    private final void setMoistness(int moistness) {
        this.entityData.set(MOISTNESS, (Object)moistness);
    }

    public final int getSize() {
        Object object = this.entityData.get(CEPHALOPOD_SIZE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setSize(int size) {
        this.entityData.set(CEPHALOPOD_SIZE, (Object)size);
    }

    public final int getHunger() {
        Object object = this.entityData.get(HUNGER);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setHunger(int hunger) {
        this.entityData.set(HUNGER, (Object)hunger);
    }

    private final boolean getAttemptAttack() {
        Object object = this.entityData.get(ATTEMPT_ATTACK);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final void setAttemptAttack(boolean attemptAttack) {
        this.entityData.set(ATTEMPT_ATTACK, (Object)attemptAttack);
    }

    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllers) {
        Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
        controllers.add(new AnimationController((GeoAnimatable)this, "Swim/Idle", 10, HybridAquaticCephalopodEntity::registerControllers$lambda$0));
        controllers.add(new AnimationController((GeoAnimatable)this, "Sit", 10, arg_0 -> HybridAquaticCephalopodEntity.registerControllers$lambda$1(this, arg_0)));
    }

    @NotNull
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        AnimatableInstanceCache animatableInstanceCache = this.factory;
        Intrinsics.checkNotNullExpressionValue((Object)animatableInstanceCache, (String)"factory");
        return animatableInstanceCache;
    }

    protected int getMinSize() {
        return 0;
    }

    protected int getMaxSize() {
        return 3;
    }

    private static final boolean registerGoals$lambda$0(HybridAquaticCephalopodEntity this$0, LivingEntity entity) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Iterable $this$any$iv = this$0.getPredator();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TagKey predatorTag = (TagKey)element$iv;
                    boolean bl2 = false;
                    if (!entity.getType().is(predatorTag)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean registerGoals$lambda$1(HybridAquaticCephalopodEntity this$0, LivingEntity it) {
        return this$0.getHunger() <= 1200 && it.getType().is(this$0.getPrey());
    }

    private static final boolean squirt$lambda$0(HybridAquaticCephalopodEntity this$0, LivingEntity it) {
        return !Intrinsics.areEqual((Object)it, (Object)((Object)this$0)) && it.isAlive();
    }

    private static final boolean squirt$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final PlayState registerControllers$lambda$0(AnimationState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state.setAndContinue(state.isMoving() ? DefaultAnimations.SWIM : DefaultAnimations.IDLE);
    }

    private static final PlayState registerControllers$lambda$1(HybridAquaticCephalopodEntity this$0, AnimationState state) {
        PlayState playState;
        if (this$0.onGround()) {
            state.setAndContinue(DefaultAnimations.SIT);
            playState = PlayState.CONTINUE;
        } else {
            playState = PlayState.STOP;
        }
        return playState;
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(HybridAquaticCephalopodEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        MOISTNESS = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(HybridAquaticCephalopodEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        CEPHALOPOD_SIZE = entityDataAccessor2;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.defineId(HybridAquaticCephalopodEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(...)");
        HUNGER = entityDataAccessor3;
        EntityDataAccessor entityDataAccessor4 = SynchedEntityData.defineId(HybridAquaticCephalopodEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor4, (String)"defineId(...)");
        ATTEMPT_ATTACK = entityDataAccessor4;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticCephalopodEntity$CephalopodAttackGoal;", "Lnet/minecraft/world/entity/ai/goal/MeleeAttackGoal;", "cephalopod", "Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticCephalopodEntity;", "<init>", "(Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticCephalopodEntity;)V", "canUse", "", "checkAndPerformAttack", "", "target", "Lnet/minecraft/world/entity/LivingEntity;", "start", "stop", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class CephalopodAttackGoal
    extends MeleeAttackGoal {
        @NotNull
        private final HybridAquaticCephalopodEntity cephalopod;

        public CephalopodAttackGoal(@NotNull HybridAquaticCephalopodEntity cephalopod) {
            Intrinsics.checkNotNullParameter((Object)((Object)cephalopod), (String)"cephalopod");
            super((PathfinderMob)cephalopod, 1.0, true);
            this.cephalopod = cephalopod;
        }

        public boolean canUse() {
            return !this.cephalopod.fromFishingNet && super.canUse();
        }

        protected void checkAndPerformAttack(@NotNull LivingEntity target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (this.canPerformAttack(target)) {
                this.resetAttackCooldown();
                this.mob.doHurtTarget((Entity)target);
                this.cephalopod.setSprinting(true);
                this.cephalopod.setAttemptAttack(true);
                if (target.getHealth() <= 0.0f) {
                    this.cephalopod.setHunger(2400);
                }
                this.cephalopod.setHealth(this.cephalopod.getMaxHealth());
            }
        }

        public void start() {
            super.start();
            this.cephalopod.setAttemptAttack(false);
        }

        public void stop() {
            super.stop();
            this.cephalopod.setAttemptAttack(false);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0015\u001a\u00020\u000e2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J6\u0010!\u001a\u00020\u000e2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020#R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticCephalopodEntity$Companion;", "", "<init>", "()V", "MOISTNESS", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getMOISTNESS", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "CEPHALOPOD_SIZE", "getCEPHALOPOD_SIZE", "HUNGER", "getHUNGER", "ATTEMPT_ATTACK", "", "getATTEMPT_ATTACK", "MAX_HUNGER", "HUNGER_KEY", "", "MOISTNESS_KEY", "CEPHALOPOD_SIZE_KEY", "canSpawn", "type", "Lnet/minecraft/world/entity/EntityType;", "Lnet/minecraft/world/entity/animal/WaterAnimal;", "world", "Lnet/minecraft/world/level/ServerLevelAccessor;", "reason", "Lnet/minecraft/world/entity/MobSpawnType;", "pos", "Lnet/minecraft/core/BlockPos;", "random", "Lnet/minecraft/util/RandomSource;", "canDeepSpawn", "getScaleAdjustment", "", "cephalopod", "Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticCephalopodEntity;", "adjustment", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Integer> getMOISTNESS() {
            return MOISTNESS;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getCEPHALOPOD_SIZE() {
            return CEPHALOPOD_SIZE;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getHUNGER() {
            return HUNGER;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getATTEMPT_ATTACK() {
            return ATTEMPT_ATTACK;
        }

        public final boolean canSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            int topY = world.getSeaLevel() - 4;
            int bottomY = world.getSeaLevel() - 24;
            int n = pos.getY();
            return (bottomY <= n ? n <= topY : false) && world.isWaterAt(pos) && world.canSeeSkyFromBelowWater(pos) && !Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random);
        }

        public final boolean canDeepSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            int topY = world.getSeaLevel() - 48;
            int bottomY = world.getSeaLevel() - 128;
            int n = pos.getY();
            return (bottomY <= n ? n <= topY : false) && world.isWaterAt(pos) && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random);
        }

        public final float getScaleAdjustment(@NotNull HybridAquaticCephalopodEntity cephalopod, float adjustment) {
            Intrinsics.checkNotNullParameter((Object)((Object)cephalopod), (String)"cephalopod");
            return 1.0f + (float)cephalopod.getSize() * adjustment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

