/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.crustacean;

import dev.hybridlabs.aquatic.entity.ai.control.WallClimbNavigation;
import dev.hybridlabs.aquatic.entity.cephalopod.HybridAquaticCephalopodEntity;
import dev.hybridlabs.aquatic.entity.crustacean.GiantIsopodEntity;
import dev.hybridlabs.aquatic.entity.crustacean.HermitCrabEntity;
import dev.hybridlabs.aquatic.entity.fish.HybridAquaticFishEntity;
import dev.hybridlabs.aquatic.entity.mammal.HybridAquaticMammalEntity;
import dev.hybridlabs.aquatic.entity.shark.HybridAquaticSharkEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 V2\u00020\u00012\u00020\u0002:\u0001VB'\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001f\u001a\u00020 H\u0014J,\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0005\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010)\u001a\u00020 H\u0016J\b\u0010*\u001a\u00020\u0016H\u0016J\b\u0010+\u001a\u00020\u0016H\u0016J\u0018\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\bH\u0016J\b\u0010/\u001a\u00020\bH\u0002J\b\u00100\u001a\u00020\bH\u0014J\b\u00101\u001a\u00020\bH\u0016J\b\u00102\u001a\u00020 H\u0002J\b\u00103\u001a\u00020 H\u0016J\u0006\u00104\u001a\u00020\bJ\b\u00105\u001a\u00020\bH\u0016J\b\u00106\u001a\u00020\bH\u0002J\u0010\u00107\u001a\u00020 2\u0006\u00106\u001a\u00020\bH\u0002J\u0018\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020 2\u0006\u0010>\u001a\u00020\u0016H\u0014J\b\u0010?\u001a\u00020\u0016H\u0014J\b\u0010@\u001a\u00020\u0016H\u0014J\u0010\u0010A\u001a\u00020 2\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020 2\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010E\u001a\u00020 2\u0006\u0010F\u001a\u00020GH\u0014J\b\u0010H\u001a\u00020<H\u0014J\u0010\u0010I\u001a\u00020J2\u0006\u00109\u001a\u00020:H\u0014J\b\u0010K\u001a\u00020JH\u0014J\u0018\u0010L\u001a\u00020 2\u0006\u00109\u001a\u00020:2\u0006\u0010M\u001a\u00020\bH\u0014J\b\u0010N\u001a\u00020\u0016H\u0016J\u0010\u0010O\u001a\u00020\b2\u0006\u0010P\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020 2\u0006\u0010S\u001a\u00020TH\u0016J\b\u0010U\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006W"}, d2={"Ldev/hybridlabs/aquatic/entity/crustacean/HybridAquaticCrustaceanEntity;", "Lnet/minecraft/world/entity/animal/WaterAnimal;", "Lsoftware/bernie/geckolib/animatable/GeoEntity;", "type", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "canDance", "", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;Z)V", "getCanDance", "()Z", "factory", "Lsoftware/bernie/geckolib/animatable/instance/AnimatableInstanceCache;", "kotlin.jvm.PlatformType", "fromFishingNet", "songPlaying", "songSource", "Lnet/minecraft/core/BlockPos;", "isHiding", "hidingTimer", "", "lastDamageTime", "", "climbingTicks", "size", "getSize", "()I", "setSize", "(I)V", "registerGoals", "", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnReason", "Lnet/minecraft/world/entity/MobSpawnType;", "entityData", "aiStep", "getMaxHeadXRot", "getMaxHeadYRot", "setRecordPlayingNearby", "songPosition", "playing", "isSongPlaying", "isAffectedByFluids", "isPushedByFluid", "startHiding", "tick", "isMoving", "onClimbable", "isClimbingWall", "setClimbingWall", "hurt", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "handleAirSupply", "air", "getMinSize", "getMaxSize", "addAdditionalSaveData", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "nextStep", "getHurtSound", "Lnet/minecraft/sounds/SoundEvent;", "getDeathSound", "dropFromLootTable", "causedByPlayer", "getMaxSpawnClusterSize", "removeWhenFarAway", "distanceSquared", "", "registerControllers", "controllerRegistrar", "Lsoftware/bernie/geckolib/animation/AnimatableManager$ControllerRegistrar;", "getAnimatableInstanceCache", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public class HybridAquaticCrustaceanEntity
extends WaterAnimal
implements GeoEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean canDance;
    private final AnimatableInstanceCache factory;
    private boolean fromFishingNet;
    private boolean songPlaying;
    @Nullable
    private BlockPos songSource;
    private boolean isHiding;
    private int hidingTimer;
    private long lastDamageTime;
    private int climbingTicks;
    @NotNull
    private static final EntityDataAccessor<Integer> CRUSTACEAN_SIZE;
    @NotNull
    private static final EntityDataAccessor<Boolean> ATTEMPT_ATTACK;
    @NotNull
    private static final EntityDataAccessor<Boolean> CLIMBING;
    @NotNull
    private static final RawAnimation DANCE_ANIMATION;
    @NotNull
    private static final RawAnimation HIDE_ANIMATION;
    @NotNull
    public static final String CRUSTACEAN_SIZE_KEY = "CrustaceanSize";

    public HybridAquaticCrustaceanEntity(@NotNull EntityType<? extends HybridAquaticCrustaceanEntity> type, @NotNull Level world, boolean canDance) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(type, world);
        this.canDance = canDance;
        this.factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)((GeoAnimatable)this));
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.moveControl = new MoveControl((Mob)this);
        this.navigation = (PathNavigation)new WallClimbNavigation((Mob)this, world);
    }

    public boolean getCanDance() {
        return this.canDance;
    }

    public final int getSize() {
        Object object = this.entityData.get(CRUSTACEAN_SIZE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setSize(int size) {
        this.entityData.set(CRUSTACEAN_SIZE, (Object)size);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.4));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnReason, (String)"spawnReason");
        this.setSize(this.random.nextIntBetweenInclusive(this.getMinSize(), this.getMaxSize()));
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public void aiStep() {
        block3: {
            block2: {
                if (this.songSource == null) break block2;
                BlockPos blockPos = this.songSource;
                Intrinsics.checkNotNull((Object)blockPos);
                if (!blockPos.closerToCenterThan((Position)this.position(), 3.5)) break block2;
                Level level = this.level();
                BlockPos blockPos2 = this.songSource;
                Intrinsics.checkNotNull((Object)blockPos2);
                if (level.getBlockState(blockPos2).is(Blocks.JUKEBOX)) break block3;
            }
            this.songPlaying = false;
            this.songSource = null;
        }
        super.aiStep();
    }

    public int getMaxHeadXRot() {
        return 1;
    }

    public int getMaxHeadYRot() {
        return 1;
    }

    public void setRecordPlayingNearby(@NotNull BlockPos songPosition, boolean playing) {
        Intrinsics.checkNotNullParameter((Object)songPosition, (String)"songPosition");
        this.songSource = songPosition;
        this.songPlaying = playing;
    }

    private final boolean isSongPlaying() {
        return this.songPlaying;
    }

    protected boolean isAffectedByFluids() {
        return !this.onGround();
    }

    public boolean isPushedByFluid() {
        return false;
    }

    private final void startHiding() {
        this.isHiding = true;
        this.hidingTimer = 200;
    }

    public void tick() {
        block7: {
            block8: {
                super.tick();
                if (!this.level().isClientSide) {
                    this.setClimbingWall(this.horizontalCollision);
                }
                if (this.isClimbingWall()) {
                    int n = this.climbingTicks;
                    this.climbingTicks = n + 1;
                    BlockState blockStateAtPos = this.level().getBlockState(this.blockPosition());
                    if (this.isMoving() && blockStateAtPos.getFluidState().isEmpty() && this.climbingTicks % 6 == 0) {
                        this.playStepSound(this.blockPosition(), blockStateAtPos);
                    }
                } else {
                    this.climbingTicks = 0;
                }
                if (this.onClimbable()) {
                    Vec3 velocity = this.getDeltaMovement();
                    this.setDeltaMovement(velocity.x, velocity.y * 0.33, velocity.z);
                }
                if (!(this instanceof HermitCrabEntity) && !(this instanceof GiantIsopodEntity) || !this.isHiding) break block7;
                int n = this.hidingTimer;
                this.hidingTimer = n + -1;
                if (this.hidingTimer > 0 || this.level().getGameTime() - this.lastDamageTime < 200L) break block8;
                this.isHiding = false;
                AttributeInstance attributeInstance = this.getAttributes().getInstance(Attributes.MOVEMENT_SPEED);
                if (attributeInstance != null) {
                    attributeInstance.setBaseValue(0.3);
                }
                AttributeInstance attributeInstance2 = this.getAttributes().getInstance(Attributes.ARMOR);
                if (attributeInstance2 == null) break block7;
                attributeInstance2.setBaseValue(5.0);
                break block7;
            }
            AttributeInstance attributeInstance = this.getAttributes().getInstance(Attributes.MOVEMENT_SPEED);
            if (attributeInstance != null) {
                attributeInstance.setBaseValue(0.0);
            }
            AttributeInstance attributeInstance3 = this.getAttributes().getInstance(Attributes.ARMOR);
            if (attributeInstance3 == null) break block7;
            attributeInstance3.setBaseValue(50.0);
        }
    }

    public final boolean isMoving() {
        return (this.onGround() || this.onClimbable()) && this.getDeltaMovement().lengthSqr() >= 1.0E-4;
    }

    public boolean onClimbable() {
        return this.climbingTicks > 8 && this.isClimbingWall();
    }

    private final boolean isClimbingWall() {
        Object object = this.entityData.get(CLIMBING);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final void setClimbingWall(boolean isClimbingWall) {
        this.entityData.set(CLIMBING, (Object)isClimbingWall);
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (this instanceof HermitCrabEntity || this instanceof GiantIsopodEntity && !this.isHiding) {
            this.startHiding();
        }
        this.lastDamageTime = this.level().getGameTime();
        return super.hurt(source, amount);
    }

    protected void handleAirSupply(int air) {
    }

    protected int getMinSize() {
        return 0;
    }

    protected int getMaxSize() {
        return 0;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.addAdditionalSaveData(nbt);
        nbt.putInt(CRUSTACEAN_SIZE_KEY, this.getSize());
        nbt.putBoolean("FromFishingNet", this.fromFishingNet);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.readAdditionalSaveData(nbt);
        this.setSize(nbt.getInt(CRUSTACEAN_SIZE_KEY));
        this.fromFishingNet = nbt.getBoolean("FromFishingNet");
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(CRUSTACEAN_SIZE, (Object)0);
        builder.define(ATTEMPT_ATTACK, (Object)false);
        builder.define(CLIMBING, (Object)false);
    }

    protected float nextStep() {
        return this.moveDist + 0.5f;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        SoundEvent soundEvent = SoundEvents.TURTLE_EGG_CRACK;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"TURTLE_EGG_CRACK");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        SoundEvent soundEvent = SoundEvents.TURTLE_EGG_BREAK;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"TURTLE_EGG_BREAK");
        return soundEvent;
    }

    protected void dropFromLootTable(@NotNull DamageSource source, boolean causedByPlayer) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Entity attacker = source.getDirectEntity();
        if (!(attacker instanceof HybridAquaticFishEntity || attacker instanceof HybridAquaticSharkEntity || attacker instanceof HybridAquaticCephalopodEntity || attacker instanceof HybridAquaticMammalEntity)) {
            super.dropFromLootTable(source, causedByPlayer);
        }
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public boolean removeWhenFarAway(double distanceSquared) {
        return !this.fromFishingNet && !this.hasCustomName();
    }

    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllerRegistrar) {
        Intrinsics.checkNotNullParameter((Object)controllerRegistrar, (String)"controllerRegistrar");
        controllerRegistrar.add(DefaultAnimations.genericWalkIdleController((GeoAnimatable)((GeoAnimatable)this)));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "Hide", 4, arg_0 -> HybridAquaticCrustaceanEntity.registerControllers$lambda$0(this, arg_0)));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "Dance", 4, arg_0 -> HybridAquaticCrustaceanEntity.registerControllers$lambda$1(this, arg_0)));
    }

    @NotNull
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        AnimatableInstanceCache animatableInstanceCache = this.factory;
        Intrinsics.checkNotNullExpressionValue((Object)animatableInstanceCache, (String)"factory");
        return animatableInstanceCache;
    }

    private static final PlayState registerControllers$lambda$0(HybridAquaticCrustaceanEntity this$0, AnimationState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this$0.isHiding) {
            return state.setAndContinue(HIDE_ANIMATION);
        }
        return PlayState.STOP;
    }

    private static final PlayState registerControllers$lambda$1(HybridAquaticCrustaceanEntity this$0, AnimationState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this$0.getCanDance() && this$0.isSongPlaying()) {
            return state.setAndContinue(DANCE_ANIMATION);
        }
        return PlayState.STOP;
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(HybridAquaticCrustaceanEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        CRUSTACEAN_SIZE = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(HybridAquaticCrustaceanEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        ATTEMPT_ATTACK = entityDataAccessor2;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.defineId(HybridAquaticCrustaceanEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(...)");
        CLIMBING = entityDataAccessor3;
        RawAnimation rawAnimation = RawAnimation.begin().thenPlay("misc.dance");
        Intrinsics.checkNotNullExpressionValue((Object)rawAnimation, (String)"thenPlay(...)");
        DANCE_ANIMATION = rawAnimation;
        RawAnimation rawAnimation2 = RawAnimation.begin().thenPlay("misc.hide");
        Intrinsics.checkNotNullExpressionValue((Object)rawAnimation2, (String)"thenPlay(...)");
        HIDE_ANIMATION = rawAnimation2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0014\u001a\u00020\n2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ6\u0010 \u001a\u00020\n2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ6\u0010!\u001a\u00020\n2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020#R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010'\u001a\u00020(X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Ldev/hybridlabs/aquatic/entity/crustacean/HybridAquaticCrustaceanEntity$Companion;", "", "<init>", "()V", "CRUSTACEAN_SIZE", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getCRUSTACEAN_SIZE", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "ATTEMPT_ATTACK", "", "getATTEMPT_ATTACK", "CLIMBING", "getCLIMBING", "DANCE_ANIMATION", "Lsoftware/bernie/geckolib/animation/RawAnimation;", "getDANCE_ANIMATION", "()Lsoftware/bernie/geckolib/animation/RawAnimation;", "HIDE_ANIMATION", "getHIDE_ANIMATION", "canSurfaceSpawn", "type", "Lnet/minecraft/world/entity/EntityType;", "Lnet/minecraft/world/entity/animal/WaterAnimal;", "world", "Lnet/minecraft/world/level/ServerLevelAccessor;", "reason", "Lnet/minecraft/world/entity/MobSpawnType;", "pos", "Lnet/minecraft/core/BlockPos;", "random", "Lnet/minecraft/util/RandomSource;", "canWaterSpawn", "canDeepSpawn", "getScaleAdjustment", "", "crustacean", "Ldev/hybridlabs/aquatic/entity/crustacean/HybridAquaticCrustaceanEntity;", "adjustment", "CRUSTACEAN_SIZE_KEY", "", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Integer> getCRUSTACEAN_SIZE() {
            return CRUSTACEAN_SIZE;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getATTEMPT_ATTACK() {
            return ATTEMPT_ATTACK;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getCLIMBING() {
            return CLIMBING;
        }

        @NotNull
        public final RawAnimation getDANCE_ANIMATION() {
            return DANCE_ANIMATION;
        }

        @NotNull
        public final RawAnimation getHIDE_ANIMATION() {
            return HIDE_ANIMATION;
        }

        public final boolean canSurfaceSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            int topY = world.getSeaLevel() + 8;
            return pos.getY() <= topY && world.getBlockState(pos.below()).isSolid() && world.isEmptyBlock(pos);
        }

        public final boolean canWaterSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            int bottomY = world.getSeaLevel() - 24;
            return pos.getY() >= bottomY && world.getBlockState(pos.below()).isSolid() && world.isWaterAt(pos);
        }

        public final boolean canDeepSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            int topY = world.getSeaLevel() - 24;
            int bottomY = world.getSeaLevel() - 128;
            int n = pos.getY();
            return (bottomY <= n ? n <= topY : false) && world.getBlockState(pos.below()).isSolid() && world.isWaterAt(pos);
        }

        public final float getScaleAdjustment(@NotNull HybridAquaticCrustaceanEntity crustacean, float adjustment) {
            Intrinsics.checkNotNullParameter((Object)((Object)crustacean), (String)"crustacean");
            return 1.0f + (float)crustacean.getSize() * adjustment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

