/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.mammal;

import dev.hybridlabs.aquatic.entity.HybridAquaticEntityTypes;
import dev.hybridlabs.aquatic.entity.mammal.HybridAquaticMammalEntity;
import dev.hybridlabs.aquatic.tag.HybridAquaticEntityTags;
import java.util.Collection;
import java.util.EnumSet;
import java.util.function.IntFunction;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 P2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\tPQRSTUVWXB\u001f\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0013H\u0014J\b\u0010\u001c\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rH\u0014J\b\u0010\u001f\u001a\u00020\u0015H\u0016J\b\u0010 \u001a\u00020\rH\u0016J\b\u0010!\u001a\u00020\rH\u0016J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0015H\u0016J,\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0006\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010'H\u0016J\n\u0010.\u001a\u0004\u0018\u00010/H\u0014J\u0012\u00100\u001a\u0004\u0018\u00010/2\u0006\u00101\u001a\u00020\u0017H\u0014J\n\u00102\u001a\u0004\u0018\u00010/H\u0014J\b\u00103\u001a\u00020/H\u0014J\b\u00104\u001a\u00020/H\u0014J\u001a\u00105\u001a\u0004\u0018\u00010\u00002\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020\u0019H\u0016J\u0010\u0010;\u001a\u00020\u00132\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u00132\u0006\u0010?\u001a\u00020@H\u0014J\u0010\u0010A\u001a\u00020\u00132\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020\u00132\u0006\u0010B\u001a\u00020CH\u0016J\b\u0010E\u001a\u00020\u0003H\u0016J\u0010\u0010F\u001a\u00020\u00132\u0006\u0010G\u001a\u00020\u0003H\u0016J\u000e\u0010H\u001a\u00020\u00132\u0006\u0010I\u001a\u00020JJ\u0006\u0010K\u001a\u00020JJ\u0012\u0010L\u001a\u00020\u00152\b\u0010M\u001a\u0004\u0018\u00010NH\u0002J\u0006\u0010O\u001a\u00020\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006Y"}, d2={"Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;", "Ldev/hybridlabs/aquatic/entity/mammal/HybridAquaticMammalEntity;", "Lnet/minecraft/world/entity/VariantHolder;", "Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity$Companion$Type;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "swimControl", "Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity$OtterMoveControl;", "hunger", "", "getHunger", "()I", "setHunger", "(I)V", "tick", "", "hurt", "", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "maxUpStep", "registerGoals", "getMaxAirSupply", "increaseAirSupply", "currentAir", "isPushedByFluid", "getMaxHeadXRot", "getMaxHeadYRot", "travel", "travelVector", "Lnet/minecraft/world/phys/Vec3;", "isVisuallySwimming", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnReason", "Lnet/minecraft/world/entity/MobSpawnType;", "entityData", "getAmbientSound", "Lnet/minecraft/sounds/SoundEvent;", "getHurtSound", "damageSource", "getDeathSound", "getSwimSplashSound", "getSwimSound", "getBreedOffspring", "p0", "Lnet/minecraft/server/level/ServerLevel;", "p1", "Lnet/minecraft/world/entity/AgeableMob;", "getWaterline", "registerControllers", "controllers", "Lsoftware/bernie/geckolib/animation/AnimatableManager$ControllerRegistrar;", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "addAdditionalSaveData", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "getVariant", "setVariant", "type", "setAction", "action", "Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity$Companion$OtterAction;", "getAction", "closeToBlockPos", "blockpos", "Lnet/minecraft/core/BlockPos;", "closeToNextPos", "Companion", "OtterAttackGoal", "OtterBreathAirGoal", "OtterWalkingGoal", "OtterSwimmingGoal", "OtterDiveGoal", "OtterFloatGoal", "OtterMoveControl", "OtterLookControl", "hybrid-aquatic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nOtterEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OtterEntity.kt\ndev/hybridlabs/aquatic/entity/mammal/OtterEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,606:1\n1761#2,3:607\n*S KotlinDebug\n*F\n+ 1 OtterEntity.kt\ndev/hybridlabs/aquatic/entity/mammal/OtterEntity\n*L\n114#1:607,3\n*E\n"})
public final class OtterEntity
extends HybridAquaticMammalEntity
implements VariantHolder<Companion.Type> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OtterMoveControl swimControl;
    public static final int MAX_HUNGER = 4800;
    @NotNull
    public static final String HUNGER_KEY = "Hunger";
    @NotNull
    private static final RawAnimation FLOAT_ANIMATION;
    @NotNull
    private static final EntityDataAccessor<Integer> TYPE;
    @NotNull
    private static final EntityDataAccessor<Integer> HUNGER;
    @NotNull
    private static final EntityDataAccessor<Integer> ACTION;

    public OtterEntity(@NotNull EntityType<? extends OtterEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world, CollectionsKt.listOf(HybridAquaticEntityTags.INSTANCE.getKELP_PREY()), CollectionsKt.listOf(HybridAquaticEntityTags.INSTANCE.getSHARK()));
        this.swimControl = new OtterMoveControl(this, 45, 3, 0.02f, 1.0f, true);
        this.moveControl = (MoveControl)this.swimControl;
        this.lookControl = new OtterLookControl(this);
        this.navigation = (PathNavigation)new AmphibiousPathNavigation((Mob)this, this.level());
        this.setPathfindingMalus(PathType.WATER_BORDER, 0.0f);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public final int getHunger() {
        Object object = this.entityData.get(HUNGER);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setHunger(int hunger) {
        this.entityData.set(HUNGER, (Object)hunger);
    }

    public void tick() {
        super.tick();
        if (this.getHunger() > 0) {
            this.setHunger(this.getHunger() - 1);
        }
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (Intrinsics.areEqual((Object)source, (Object)this.damageSources().drown())) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public float maxUpStep() {
        return 1.0f;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new OtterBreathAirGoal(this));
        this.goalSelector.addGoal(2, (Goal)new OtterDiveGoal(this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new OtterFloatGoal(this));
        this.goalSelector.addGoal(2, (Goal)new OtterSwimmingGoal(this, 0.8, 20));
        this.goalSelector.addGoal(3, (Goal)new OtterWalkingGoal(this, 0.7, 20));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f, 0.1f, true));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new OtterAttackGoal(this, 1.0, true));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, true, arg_0 -> OtterEntity.registerGoals$lambda$0(this, arg_0)));
    }

    public int getMaxAirSupply() {
        return 800;
    }

    protected int increaseAirSupply(int currentAir) {
        return this.getMaxAirSupply();
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public int getMaxHeadXRot() {
        if (this.isUnderWater()) {
            return 0;
        }
        return super.getMaxHeadXRot();
    }

    public int getMaxHeadYRot() {
        if (this.isUnderWater()) {
            return 0;
        }
        return super.getMaxHeadYRot();
    }

    public void travel(@NotNull Vec3 travelVector) {
        Intrinsics.checkNotNullParameter((Object)travelVector, (String)"travelVector");
        if (this.isEffectiveAi() && this.isInWater() && this.getAction() != Companion.OtterAction.FLOATING) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.9, 1.0, 0.9));
        }
        super.travel(travelVector);
    }

    public boolean isVisuallySwimming() {
        return this.isSwimming();
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnReason, (String)"spawnReason");
        Holder biome = world.getBiome(this.blockPosition());
        Intrinsics.checkNotNull((Object)biome);
        Companion.Type selectedType = Companion.Type.Companion.fromBiome((Holder<Biome>)biome);
        this.setVariant(selectedType);
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.FOX_AMBIENT;
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        return SoundEvents.FOX_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.FOX_DEATH;
    }

    @NotNull
    protected SoundEvent getSwimSplashSound() {
        SoundEvent soundEvent = SoundEvents.DOLPHIN_SPLASH;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"DOLPHIN_SPLASH");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getSwimSound() {
        SoundEvent soundEvent = SoundEvents.DOLPHIN_SWIM;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"DOLPHIN_SWIM");
        return soundEvent;
    }

    @Nullable
    public OtterEntity getBreedOffspring(@NotNull ServerLevel p0, @NotNull AgeableMob p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        return (OtterEntity)HybridAquaticEntityTypes.INSTANCE.getOTTER().get().create((Level)p0);
    }

    @Override
    public float getWaterline() {
        return 0.125f;
    }

    @Override
    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllers) {
        Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
        controllers.add(new AnimationController((GeoAnimatable)this, "otter_controller", 8, arg_0 -> OtterEntity.registerControllers$lambda$0(this, arg_0)));
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(TYPE, (Object)0);
        builder.define(HUNGER, (Object)4800);
        builder.define(ACTION, (Object)0);
        super.defineSynchedData(builder);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.putString("Type", this.getVariant().getSerializedName());
        nbt.putInt(HUNGER_KEY, this.getHunger());
        nbt.putString("Action", this.getAction().getSerializedName());
        super.addAdditionalSaveData(nbt);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        this.setVariant(Companion.Type.Companion.byName(nbt.getString("Type")));
        this.setHunger(nbt.getInt(HUNGER_KEY));
        this.setAction(Companion.OtterAction.Companion.byName(nbt.getString("Action")));
        super.readAdditionalSaveData(nbt);
    }

    @NotNull
    public Companion.Type getVariant() {
        Object object = this.entityData.get(TYPE);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        return Companion.Type.Companion.fromId((Integer)object);
    }

    public void setVariant(@NotNull Companion.Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.entityData.set(TYPE, (Object)type.getId());
    }

    public final void setAction(@NotNull Companion.OtterAction action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        this.entityData.set(ACTION, (Object)action.getId());
    }

    @NotNull
    public final Companion.OtterAction getAction() {
        Object object = this.entityData.get(ACTION);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return Companion.OtterAction.Companion.fromId(((Number)object).intValue());
    }

    private final boolean closeToBlockPos(BlockPos blockpos) {
        BlockPos blockPos = blockpos;
        return blockPos != null ? blockPos.closerToCenterThan((Position)this.position(), 12.0) : false;
    }

    public final boolean closeToNextPos() {
        Path path = this.getNavigation().getPath();
        BlockPos blockpos = path != null && (path = path.getNextNode()) != null ? path.asBlockPos() : null;
        return this.closeToBlockPos(blockpos);
    }

    private static final boolean registerGoals$lambda$0(OtterEntity this$0, LivingEntity entity) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Iterable $this$any$iv = this$0.getPrey();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TagKey preyType = (TagKey)element$iv;
                    boolean bl2 = false;
                    if (!entity.getType().is(preyType)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl && this$0.getHunger() < 1200;
    }

    private static final PlayState registerControllers$lambda$0(OtterEntity this$0, AnimationState state) {
        return state.isMoving() && this$0.getAction() == Companion.OtterAction.WALKING ? state.setAndContinue(DefaultAnimations.WALK) : (state.isMoving() && this$0.getAction() == Companion.OtterAction.SWIMMING ? state.setAndContinue(DefaultAnimations.SWIM) : (state.isMoving() && this$0.getAction() == Companion.OtterAction.DIVING ? state.setAndContinue(DefaultAnimations.SWIM) : (!state.isMoving() && this$0.isInWater() && !this$0.onGround() && this$0.getAction() == Companion.OtterAction.FLOATING ? state.setAndContinue(FLOAT_ANIMATION) : (this$0.isInWater() ? state.setAndContinue(HybridAquaticMammalEntity.Companion.getWATER_IDLE()) : state.setAndContinue(DefaultAnimations.IDLE)))));
    }

    static {
        RawAnimation rawAnimation = RawAnimation.begin().thenPlay("misc.float_idle");
        Intrinsics.checkNotNullExpressionValue((Object)rawAnimation, (String)"thenPlay(...)");
        FLOAT_ANIMATION = rawAnimation;
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(OtterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        TYPE = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(OtterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        HUNGER = entityDataAccessor2;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.defineId(OtterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(...)");
        ACTION = entityDataAccessor3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011\u00a8\u0006\u0018"}, d2={"Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity$Companion;", "", "<init>", "()V", "createMobAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "MAX_HUNGER", "", "HUNGER_KEY", "", "FLOAT_ANIMATION", "Lsoftware/bernie/geckolib/animation/RawAnimation;", "getFLOAT_ANIMATION", "()Lsoftware/bernie/geckolib/animation/RawAnimation;", "TYPE", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "getTYPE", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "HUNGER", "getHUNGER", "ACTION", "getACTION", "OtterAction", "Type", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createMobAttributes() {
            AttributeSupplier.Builder builder = Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.FOLLOW_RANGE, 16.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        @NotNull
        public final RawAnimation getFLOAT_ANIMATION() {
            return FLOAT_ANIMATION;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getTYPE() {
            return TYPE;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getHUNGER() {
            return HUNGER;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getACTION() {
            return ACTION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u0000 \u00112\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0011B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0010\u001a\u00020\u0006H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0012"}, d2={"Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity$Companion$OtterAction;", "Lnet/minecraft/util/StringRepresentable;", "", "id", "", "key", "", "<init>", "(Ljava/lang/String;IILjava/lang/String;)V", "getId", "()I", "IDLE", "SWIMMING", "DIVING", "FLOATING", "WALKING", "getSerializedName", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
        @SourceDebugExtension(value={"SMAP\nOtterEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OtterEntity.kt\ndev/hybridlabs/aquatic/entity/mammal/OtterEntity$Companion$OtterAction\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,606:1\n37#2,2:607\n37#2,2:609\n*S KotlinDebug\n*F\n+ 1 OtterEntity.kt\ndev/hybridlabs/aquatic/entity/mammal/OtterEntity$Companion$OtterAction\n*L\n262#1:607,2\n265#1:609,2\n*E\n"})
        public static final class OtterAction
        extends Enum<OtterAction>
        implements StringRepresentable {
            @NotNull
            public static final Companion Companion;
            private final int id;
            @NotNull
            private final String key;
            @NotNull
            private static final StringRepresentable.EnumCodec<OtterAction> CODEC;
            @NotNull
            private static final IntFunction<OtterAction> BY_ID;
            public static final /* enum */ OtterAction IDLE;
            public static final /* enum */ OtterAction SWIMMING;
            public static final /* enum */ OtterAction DIVING;
            public static final /* enum */ OtterAction FLOATING;
            public static final /* enum */ OtterAction WALKING;
            private static final /* synthetic */ OtterAction[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private OtterAction(int id, String key) {
                this.id = id;
                this.key = key;
            }

            public final int getId() {
                return this.id;
            }

            @NotNull
            public String getSerializedName() {
                return this.key;
            }

            public static OtterAction[] values() {
                return (OtterAction[])$VALUES.clone();
            }

            public static OtterAction valueOf(String value) {
                return Enum.valueOf(OtterAction.class, value);
            }

            @NotNull
            public static EnumEntries<OtterAction> getEntries() {
                return $ENTRIES;
            }

            private static final OtterAction[] CODEC$lambda$0() {
                Collection $this$toTypedArray$iv = (Collection)OtterAction.getEntries();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new OtterAction[0]);
            }

            private static final int BY_ID$lambda$0(OtterAction obj) {
                Intrinsics.checkNotNullParameter((Object)((Object)obj), (String)"obj");
                return obj.id;
            }

            static {
                IDLE = new OtterAction(0, "idle");
                SWIMMING = new OtterAction(1, "swimming");
                DIVING = new OtterAction(2, "diving");
                FLOATING = new OtterAction(3, "floating");
                WALKING = new OtterAction(4, "walking");
                $VALUES = otterActionArray = new OtterAction[]{OtterAction.IDLE, OtterAction.SWIMMING, OtterAction.DIVING, OtterAction.FLOATING, OtterAction.WALKING};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
                StringRepresentable.EnumCodec enumCodec = StringRepresentable.fromEnum(OtterAction::CODEC$lambda$0);
                Intrinsics.checkNotNullExpressionValue((Object)enumCodec, (String)"fromEnum(...)");
                CODEC = enumCodec;
                Collection $this$toTypedArray$iv = (Collection)OtterAction.getEntries();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                IntFunction intFunction = ByIdMap.continuous(OtterAction::BY_ID$lambda$0, (Object[])thisCollection$iv.toArray(new OtterAction[0]), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
                Intrinsics.checkNotNullExpressionValue((Object)intFunction, (String)"continuous(...)");
                BY_ID = intFunction;
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity$Companion$OtterAction$Companion;", "", "<init>", "()V", "CODEC", "Lnet/minecraft/util/StringRepresentable$EnumCodec;", "Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity$Companion$OtterAction;", "getCODEC", "()Lnet/minecraft/util/StringRepresentable$EnumCodec;", "BY_ID", "Ljava/util/function/IntFunction;", "byName", "name", "", "fromId", "id", "", "hybrid-aquatic-neoforge-1.21.1"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final StringRepresentable.EnumCodec<OtterAction> getCODEC() {
                    return CODEC;
                }

                @NotNull
                public final OtterAction byName(@Nullable String name) {
                    Enum enum_ = Companion.getCODEC().byName(name, (Enum)IDLE);
                    Intrinsics.checkNotNull((Object)enum_, (String)"null cannot be cast to non-null type dev.hybridlabs.aquatic.entity.mammal.OtterEntity.Companion.OtterAction");
                    return (OtterAction)enum_;
                }

                @NotNull
                public final OtterAction fromId(int id) {
                    Object r = BY_ID.apply(id);
                    Intrinsics.checkNotNull(r, (String)"null cannot be cast to non-null type dev.hybridlabs.aquatic.entity.mammal.OtterEntity.Companion.OtterAction");
                    return (OtterAction)((Object)r);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u0000 \u000e2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u000eB\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u0006H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000f"}, d2={"Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity$Companion$Type;", "Lnet/minecraft/util/StringRepresentable;", "", "id", "", "key", "", "<init>", "(Ljava/lang/String;IILjava/lang/String;)V", "getId", "()I", "RIVER", "SEA", "getSerializedName", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
        @SourceDebugExtension(value={"SMAP\nOtterEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OtterEntity.kt\ndev/hybridlabs/aquatic/entity/mammal/OtterEntity$Companion$Type\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,606:1\n37#2,2:607\n37#2,2:609\n*S KotlinDebug\n*F\n+ 1 OtterEntity.kt\ndev/hybridlabs/aquatic/entity/mammal/OtterEntity$Companion$Type\n*L\n288#1:607,2\n291#1:609,2\n*E\n"})
        public static final class Type
        extends Enum<Type>
        implements StringRepresentable {
            @NotNull
            public static final Companion Companion;
            private final int id;
            @NotNull
            private final String key;
            @NotNull
            private static final StringRepresentable.EnumCodec<Type> CODEC;
            @NotNull
            private static final IntFunction<Type> BY_ID;
            public static final /* enum */ Type RIVER;
            public static final /* enum */ Type SEA;
            private static final /* synthetic */ Type[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Type(int id, String key) {
                this.id = id;
                this.key = key;
            }

            public final int getId() {
                return this.id;
            }

            @NotNull
            public String getSerializedName() {
                return this.key;
            }

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String value) {
                return Enum.valueOf(Type.class, value);
            }

            @NotNull
            public static EnumEntries<Type> getEntries() {
                return $ENTRIES;
            }

            private static final Type[] CODEC$lambda$0() {
                Collection $this$toTypedArray$iv = (Collection)Type.getEntries();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new Type[0]);
            }

            private static final int BY_ID$lambda$0(Type obj) {
                Intrinsics.checkNotNullParameter((Object)((Object)obj), (String)"obj");
                return obj.id;
            }

            static {
                RIVER = new Type(0, "river");
                SEA = new Type(1, "sea");
                $VALUES = typeArray = new Type[]{Type.RIVER, Type.SEA};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
                StringRepresentable.EnumCodec enumCodec = StringRepresentable.fromEnum(Type::CODEC$lambda$0);
                Intrinsics.checkNotNullExpressionValue((Object)enumCodec, (String)"fromEnum(...)");
                CODEC = enumCodec;
                Collection $this$toTypedArray$iv = (Collection)Type.getEntries();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                IntFunction intFunction = ByIdMap.continuous(Type::BY_ID$lambda$0, (Object[])thisCollection$iv.toArray(new Type[0]), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
                Intrinsics.checkNotNullExpressionValue((Object)intFunction, (String)"continuous(...)");
                BY_ID = intFunction;
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity$Companion$Type$Companion;", "", "<init>", "()V", "CODEC", "Lnet/minecraft/util/StringRepresentable$EnumCodec;", "Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity$Companion$Type;", "getCODEC", "()Lnet/minecraft/util/StringRepresentable$EnumCodec;", "BY_ID", "Ljava/util/function/IntFunction;", "byName", "name", "", "fromId", "id", "", "fromBiome", "biome", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/biome/Biome;", "hybrid-aquatic-neoforge-1.21.1"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final StringRepresentable.EnumCodec<Type> getCODEC() {
                    return CODEC;
                }

                @NotNull
                public final Type byName(@Nullable String name) {
                    Enum enum_ = this.getCODEC().byName(name, (Enum)RIVER);
                    Intrinsics.checkNotNull((Object)enum_, (String)"null cannot be cast to non-null type dev.hybridlabs.aquatic.entity.mammal.OtterEntity.Companion.Type");
                    return (Type)enum_;
                }

                @NotNull
                public final Type fromId(int id) {
                    Object r = BY_ID.apply(id);
                    Intrinsics.checkNotNull(r, (String)"null cannot be cast to non-null type dev.hybridlabs.aquatic.entity.mammal.OtterEntity.Companion.Type");
                    return (Type)((Object)r);
                }

                @NotNull
                public final Type fromBiome(@NotNull Holder<Biome> biome) {
                    Intrinsics.checkNotNullParameter(biome, (String)"biome");
                    return biome.is(BiomeTags.IS_BEACH) ? SEA : (biome.is(BiomeTags.IS_OCEAN) ? SEA : RIVER);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity$OtterAttackGoal;", "Lnet/minecraft/world/entity/ai/goal/MeleeAttackGoal;", "otter", "Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;", "speedModifier", "", "followingTargetEvenIfNotSeen", "", "<init>", "(Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;DZ)V", "getOtter", "()Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;", "checkAndPerformAttack", "", "enemy", "Lnet/minecraft/world/entity/LivingEntity;", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class OtterAttackGoal
    extends MeleeAttackGoal {
        @NotNull
        private final OtterEntity otter;

        public OtterAttackGoal(@NotNull OtterEntity otter, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            Intrinsics.checkNotNullParameter((Object)((Object)otter), (String)"otter");
            super((PathfinderMob)otter, speedModifier, followingTargetEvenIfNotSeen);
            this.otter = otter;
        }

        @NotNull
        public final OtterEntity getOtter() {
            return this.otter;
        }

        protected void checkAndPerformAttack(@NotNull LivingEntity enemy) {
            Intrinsics.checkNotNullParameter((Object)enemy, (String)"enemy");
            if (this.canPerformAttack(enemy)) {
                this.resetAttackCooldown();
                this.otter.swing(InteractionHand.MAIN_HAND);
                this.otter.doHurtTarget((Entity)enemy);
                if (enemy.getHealth() <= 0.0f) {
                    this.otter.setHunger(4800);
                }
                this.otter.setHealth(this.otter.getMaxHealth());
            }
            super.checkAndPerformAttack(enemy);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity$OtterBreathAirGoal;", "Lnet/minecraft/world/entity/ai/goal/BreathAirGoal;", "otter", "Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;", "<init>", "(Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;)V", "getOtter", "()Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;", "start", "", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class OtterBreathAirGoal
    extends BreathAirGoal {
        @NotNull
        private final OtterEntity otter;

        public OtterBreathAirGoal(@NotNull OtterEntity otter) {
            Intrinsics.checkNotNullParameter((Object)((Object)otter), (String)"otter");
            super((PathfinderMob)otter);
            this.otter = otter;
        }

        @NotNull
        public final OtterEntity getOtter() {
            return this.otter;
        }

        public void start() {
            super.start();
            this.otter.setAction(Companion.OtterAction.SWIMMING);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity$OtterDiveGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "otter", "Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;", "speedModifier", "", "<init>", "(Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;D)V", "target", "Lnet/minecraft/world/phys/Vec3;", "minDiveDelay", "", "nextDiveTime", "canUse", "", "canContinueToUse", "start", "", "stop", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class OtterDiveGoal
    extends Goal {
        @NotNull
        private final OtterEntity otter;
        private final double speedModifier;
        @NotNull
        private Vec3 target;
        private final long minDiveDelay;
        private long nextDiveTime;

        public OtterDiveGoal(@NotNull OtterEntity otter, double speedModifier) {
            Intrinsics.checkNotNullParameter((Object)((Object)otter), (String)"otter");
            this.otter = otter;
            this.speedModifier = speedModifier;
            Vec3 vec3 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
            this.target = vec3;
            this.minDiveDelay = 500L;
            this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.otter.isInWater() && !this.otter.isUnderWater() && this.otter.level().getGameTime() >= this.nextDiveTime;
        }

        public boolean canContinueToUse() {
            return !Intrinsics.areEqual((Object)this.target, (Object)Vec3.ZERO) && this.otter.navigation.isInProgress() && !this.otter.isVehicle();
        }

        public void start() {
            this.otter.setAction(Companion.OtterAction.DIVING);
            this.otter.swimControl.setApplyGravity(false);
            Vec3 vec3 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
            this.target = vec3;
            BlockPos.MutableBlockPos pos = this.otter.blockPosition().mutable();
            float angle = this.otter.random.nextFloat() * ((float)Math.PI * 2);
            Vec2 vec = new Vec2(Mth.cos((float)angle), Mth.sin((float)angle));
            vec.scale(this.otter.random.nextFloat() * (float)6 + (float)2);
            pos.move((int)vec.x, 0, (int)vec.y);
            pos.setY(this.otter.level().getHeight(Heightmap.Types.OCEAN_FLOOR, pos.getX(), pos.getZ()) + 1);
            if (Intrinsics.areEqual((Object)this.otter.level().getBlockState((BlockPos)pos), (Object)Blocks.WATER.defaultBlockState())) {
                Vec3 vec32 = pos.getCenter();
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getCenter(...)");
                this.target = vec32;
                this.otter.navigation.moveTo(this.target.x, this.target.y, this.target.z, this.speedModifier);
            }
        }

        public void stop() {
            Vec3 vec3 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
            this.target = vec3;
            this.nextDiveTime = this.otter.level().getGameTime() + this.minDiveDelay;
            this.otter.navigation.stop();
            this.otter.swimControl.setApplyGravity(true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity$OtterFloatGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "otter", "Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;", "<init>", "(Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;)V", "floatingTimer", "", "nextFloatTime", "minFloatDelay", "", "requiresUpdateEveryTick", "", "canUse", "canContinueToUse", "start", "", "stop", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class OtterFloatGoal
    extends Goal {
        @NotNull
        private final OtterEntity otter;
        private long floatingTimer;
        private long nextFloatTime;
        private final int minFloatDelay;

        public OtterFloatGoal(@NotNull OtterEntity otter) {
            Intrinsics.checkNotNullParameter((Object)((Object)otter), (String)"otter");
            this.otter = otter;
            this.minFloatDelay = 300;
            this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE));
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean canUse() {
            return this.otter.isInWater() && !this.otter.onGround() && !this.otter.isUnderWater() && this.otter.level().getGameTime() > this.nextFloatTime && (double)this.otter.random.nextFloat() <= 0.3;
        }

        public boolean canContinueToUse() {
            return this.otter.isInWater() && !this.otter.onGround() && this.otter.level().getGameTime() < this.floatingTimer;
        }

        public void start() {
            this.otter.navigation.stop();
            this.otter.setDeltaMovement(Vec3.ZERO);
            this.floatingTimer = (long)this.otter.random.nextInt(100, 300) + this.otter.level().getGameTime();
            this.otter.setAction(Companion.OtterAction.FLOATING);
        }

        public void stop() {
            this.floatingTimer = 0L;
            this.nextFloatTime = this.otter.level().getGameTime() + (long)this.minFloatDelay;
            this.otter.setAction(Companion.OtterAction.IDLE);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0014J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity$OtterLookControl;", "Lnet/minecraft/world/entity/ai/control/LookControl;", "otter", "Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;", "<init>", "(Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;)V", "getOtter", "()Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;", "resetXRotOnTick", "", "setLookAt", "", "x", "", "y", "z", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class OtterLookControl
    extends LookControl {
        @NotNull
        private final OtterEntity otter;

        public OtterLookControl(@NotNull OtterEntity otter) {
            Intrinsics.checkNotNullParameter((Object)((Object)otter), (String)"otter");
            super((Mob)otter);
            this.otter = otter;
        }

        @NotNull
        public final OtterEntity getOtter() {
            return this.otter;
        }

        protected boolean resetXRotOnTick() {
            if (this.otter.isUnderWater() && this.otter.getY() < (double)(this.otter.level().getSeaLevel() - 1)) {
                return false;
            }
            return super.resetXRotOnTick();
        }

        public void setLookAt(double x, double y, double z) {
            if (this.otter.getAction() == Companion.OtterAction.FLOATING) {
                Vec3 lookVec = new Vec3(x, y, z).scale(-1.0);
                super.setLookAt(lookVec.z, y, lookVec.x, (float)this.mob.getHeadRotSpeed(), (float)this.mob.getMaxHeadXRot());
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity$OtterMoveControl;", "Lnet/minecraft/world/entity/ai/control/SmoothSwimmingMoveControl;", "otter", "Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;", "maxTurnX", "", "maxTurnY", "inWaterSpeedModifier", "", "outsideWaterSpeedModifier", "applyGravity", "", "<init>", "(Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;IIFFZ)V", "getOtter", "()Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;", "getApplyGravity", "()Z", "setApplyGravity", "(Z)V", "tick", "", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class OtterMoveControl
    extends SmoothSwimmingMoveControl {
        @NotNull
        private final OtterEntity otter;
        private boolean applyGravity;

        public OtterMoveControl(@NotNull OtterEntity otter, int maxTurnX, int maxTurnY, float inWaterSpeedModifier, float outsideWaterSpeedModifier, boolean applyGravity) {
            Intrinsics.checkNotNullParameter((Object)((Object)otter), (String)"otter");
            super((Mob)otter, maxTurnX, maxTurnY, inWaterSpeedModifier, outsideWaterSpeedModifier, false);
            this.otter = otter;
            this.applyGravity = applyGravity;
        }

        @NotNull
        public final OtterEntity getOtter() {
            return this.otter;
        }

        public final boolean getApplyGravity() {
            return this.applyGravity;
        }

        public final void setApplyGravity(boolean bl) {
            this.applyGravity = bl;
        }

        public void tick() {
            if (this.applyGravity && this.otter.isInWater()) {
                Vec3 deltaMovement = this.otter.getDeltaMovement();
                double factor = 0.006;
                if (this.otter.getAction() == Companion.OtterAction.FLOATING && this.otter.isBelowWaterline()) {
                    factor += 0.025;
                    if (this.otter.isUnderWater()) {
                        factor += 0.02;
                    }
                }
                double distance = -(this.otter.getY() - (62.78 - (double)this.otter.getWaterline()));
                factor = Math.min(factor, distance);
                this.otter.setDeltaMovement(deltaMovement.add(0.0, factor, 0.0));
            }
            super.tick();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity$OtterSwimmingGoal;", "Lnet/minecraft/world/entity/ai/goal/RandomStrollGoal;", "otter", "Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;", "speedModifier", "", "interval", "", "<init>", "(Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;DI)V", "swimTimer", "", "maxSwimTime", "canUse", "", "canContinueToUse", "tick", "", "start", "stop", "getPosition", "Lnet/minecraft/world/phys/Vec3;", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class OtterSwimmingGoal
    extends RandomStrollGoal {
        @NotNull
        private final OtterEntity otter;
        private long swimTimer;
        private final long maxSwimTime;

        public OtterSwimmingGoal(@NotNull OtterEntity otter, double speedModifier, int interval) {
            Intrinsics.checkNotNullParameter((Object)((Object)otter), (String)"otter");
            super((PathfinderMob)otter, speedModifier, interval);
            this.otter = otter;
            this.maxSwimTime = 300L;
            this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.otter.isInWater() && this.otter.getAction() != Companion.OtterAction.FLOATING && this.swimTimer <= this.otter.level().getGameTime() && super.canUse();
        }

        public boolean canContinueToUse() {
            return this.otter.isInWater() && super.canContinueToUse();
        }

        public void tick() {
            if (this.otter.navigation.isDone() || this.otter.closeToNextPos()) {
                this.forceTrigger = true;
            }
            super.tick();
        }

        public void start() {
            this.otter.setAction(Companion.OtterAction.SWIMMING);
            this.swimTimer = this.otter.level().getGameTime() + this.maxSwimTime;
            super.start();
        }

        public void stop() {
            this.swimTimer = 0L;
            this.otter.navigation.stop();
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 pos = DefaultRandomPos.getPos((PathfinderMob)((PathfinderMob)this.otter), (int)8, (int)0);
            if (pos != null) {
                int height = this.otter.level().getHeight(Heightmap.Types.WORLD_SURFACE, (int)pos.x, (int)pos.z) + 1;
                pos = new Vec3(pos.x, (double)height, pos.z);
            }
            return pos;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity$OtterWalkingGoal;", "Lnet/minecraft/world/entity/ai/goal/RandomStrollGoal;", "otter", "Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;", "speedModifier", "", "interval", "", "<init>", "(Ldev/hybridlabs/aquatic/entity/mammal/OtterEntity;DI)V", "canUse", "", "canContinueToUse", "start", "", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class OtterWalkingGoal
    extends RandomStrollGoal {
        @NotNull
        private final OtterEntity otter;

        public OtterWalkingGoal(@NotNull OtterEntity otter, double speedModifier, int interval) {
            Intrinsics.checkNotNullParameter((Object)((Object)otter), (String)"otter");
            super((PathfinderMob)otter, speedModifier, interval);
            this.otter = otter;
        }

        public boolean canUse() {
            return !this.otter.isInWater() && !this.otter.isUnderWater() && super.canUse();
        }

        public boolean canContinueToUse() {
            return !this.otter.isInWater() && !this.otter.isUnderWater() && super.canContinueToUse();
        }

        public void start() {
            this.otter.setAction(Companion.OtterAction.WALKING);
            super.start();
        }
    }
}

