/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.item;

import dev.hybridlabs.aquatic.block.SeaMessage;
import dev.hybridlabs.aquatic.registry.HybridAquaticRegistryKeys;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001b"}, d2={"Ldev/hybridlabs/aquatic/item/SeaMessageBookItem;", "Lnet/minecraft/world/item/Item;", "settings", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "getName", "Lnet/minecraft/network/chat/Component;", "stack", "Lnet/minecraft/world/item/ItemStack;", "appendHoverText", "", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltip", "", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "world", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class SeaMessageBookItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String SEA_MESSAGE_KEY = "sea_message";

    public SeaMessageBookItem(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        WrittenBookContent writtenBookContent = (WrittenBookContent)stack.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (writtenBookContent != null) {
            WrittenBookContent content = writtenBookContent;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)content.title().get(false), (Object)"")) {
                MutableComponent mutableComponent = Component.translatable((String)((String)content.title().get(false)));
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
                return (Component)mutableComponent;
            }
        }
        Component component = super.getName(stack);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getName(...)");
        return component;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
            Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
            HolderLookup.Provider provider = context.registries();
            if (provider == null) break block1;
            HolderLookup.Provider registryManager = provider;
            boolean bl = false;
            SeaMessage seaMessage = Companion.getSeaMessage(stack, registryManager);
            if (seaMessage != null) {
                SeaMessage message = seaMessage;
                message.getAuthor().ifPresent(arg_0 -> SeaMessageBookItem.appendHoverText$lambda$0$1(arg_0 -> SeaMessageBookItem.appendHoverText$lambda$0$0(tooltip, arg_0), arg_0));
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.has(DataComponents.WRITTEN_BOOK_CONTENT)) {
            Intrinsics.checkNotNull((Object)stack);
            RegistryAccess registryAccess = world.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            SeaMessageBookItem.Companion.setWrittenBookConent(stack, (HolderLookup.Provider)registryAccess);
        }
        player.openItemGui(stack, hand);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"sidedSuccess(...)");
        return interactionResultHolder;
    }

    private static final Unit appendHoverText$lambda$0$0(List $tooltip, String author) {
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Object[] objectArray = new Object[]{author};
        MutableComponent mutableComponent = Component.translatable((String)"book.byAuthor", (Object[])objectArray).withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        $tooltip.add(mutableComponent);
        return Unit.INSTANCE;
    }

    private static final void appendHoverText$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/hybridlabs/aquatic/item/SeaMessageBookItem$Companion;", "", "<init>", "()V", "SEA_MESSAGE_KEY", "", "setWrittenBookConent", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "registryAccess", "Lnet/minecraft/core/HolderLookup$Provider;", "getSeaMessage", "Ldev/hybridlabs/aquatic/block/SeaMessage;", "registryManager", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        private final void setWrittenBookConent(ItemStack stack, HolderLookup.Provider registryAccess) {
            block0: {
                SeaMessage seaMessage = this.getSeaMessage(stack, registryAccess);
                if (seaMessage == null) break block0;
                SeaMessage message = seaMessage;
                boolean bl = false;
                WrittenBookContent cfr_ignored_0 = (WrittenBookContent)stack.set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)message.getWrittenBookContent());
            }
        }

        @Nullable
        public final SeaMessage getSeaMessage(@NotNull ItemStack stack, @NotNull HolderLookup.Provider registryManager) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)registryManager, (String)"registryManager");
            CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            if (customData == null || (customData = customData.copyTag()) == null) {
                return null;
            }
            CustomData customData2 = customData;
            ResourceLocation resourceLocation = ResourceLocation.tryParse((String)customData2.getString(SeaMessageBookItem.SEA_MESSAGE_KEY));
            if (resourceLocation == null) {
                return null;
            }
            ResourceLocation id = resourceLocation;
            Object t = registryManager.lookup(HybridAquaticRegistryKeys.INSTANCE.getSEA_MESSAGE()).get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            HolderLookup.RegistryLookup registry = (HolderLookup.RegistryLookup)t;
            Optional optional = registry.get(ResourceKey.create(HybridAquaticRegistryKeys.INSTANCE.getSEA_MESSAGE(), (ResourceLocation)id));
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"get(...)");
            Holder.Reference reference = (Holder.Reference)OptionalsKt.getOrNull((Optional)optional);
            return reference != null ? (SeaMessage)reference.value() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

