/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.platform.services;

import dev.hybridlabs.aquatic.platform.registration.RegistryObject;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;

public interface PlatformHelper {
    public String getPlatformName();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    default public String getEnvironmentName() {
        return this.isDevelopmentEnvironment() ? "development" : "production";
    }

    public <T extends Mob> Supplier<SpawnEggItem> registerSpawnEggItem(@NotNull String var1, Supplier<EntityType<T>> var2, int var3, int var4);

    public Path getConfigDir();

    public <T extends Mob> void registerSpawnPlacement(RegistryObject<EntityType<T>> var1, SpawnPlacementType var2, Heightmap.Types var3, SpawnPlacements.SpawnPredicate<T> var4);

    public <T extends LivingEntity> void registerAttributes(@NotNull String var1, EntityType<T> var2, Callable<AttributeSupplier.Builder> var3);

    public MobCategory getMobCategoryByName(String var1);

    public Item createBlockItem(Block var1, Item.Properties var2);

    public Item createMessageInABottleItem(Item.Properties var1);

    public void sendHookToServer(int var1, ItemStack var2);
}

