/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.world.gen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hybridlabs.aquatic.world.gen.structure.SpawnModifier;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.common.world.ModifiableStructureInfo;
import net.neoforged.neoforge.common.world.StructureModifier;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Ldev/hybridlabs/aquatic/world/gen/structure/StructureSpawnModifier;", "Lnet/neoforged/neoforge/common/world/StructureModifier;", "spawnModifier", "Ldev/hybridlabs/aquatic/world/gen/structure/SpawnModifier;", "<init>", "(Ldev/hybridlabs/aquatic/world/gen/structure/SpawnModifier;)V", "getSpawnModifier", "()Ldev/hybridlabs/aquatic/world/gen/structure/SpawnModifier;", "modify", "", "structure", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/levelgen/structure/Structure;", "phase", "Lnet/neoforged/neoforge/common/world/StructureModifier$Phase;", "builder", "Lnet/neoforged/neoforge/common/world/ModifiableStructureInfo$StructureInfo$Builder;", "codec", "Lcom/mojang/serialization/MapCodec;", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class StructureSpawnModifier
implements StructureModifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SpawnModifier spawnModifier;

    public StructureSpawnModifier(@NotNull SpawnModifier spawnModifier) {
        Intrinsics.checkNotNullParameter((Object)spawnModifier, (String)"spawnModifier");
        this.spawnModifier = spawnModifier;
    }

    @NotNull
    public final SpawnModifier getSpawnModifier() {
        return this.spawnModifier;
    }

    public void modify(@NotNull Holder<Structure> structure, @NotNull StructureModifier.Phase phase, @NotNull ModifiableStructureInfo.StructureInfo.Builder builder) {
        Intrinsics.checkNotNullParameter(structure, (String)"structure");
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (phase == StructureModifier.Phase.ADD) {
            Object t = structure.unwrapKey().get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            ResourceKey key = (ResourceKey)t;
            if (Intrinsics.areEqual(this.spawnModifier.getStructure(), (Object)key)) {
                for (Map.Entry<String, List<MobSpawnSettings.SpawnerData>> entry : this.spawnModifier.getSpawns().entrySet()) {
                    String categoryName = entry.getKey();
                    List<MobSpawnSettings.SpawnerData> spawns = entry.getValue();
                    MobCategory category = MobCategory.valueOf((String)categoryName);
                    for (MobSpawnSettings.SpawnerData spawn : spawns) {
                        builder.getStructureSettings().getOrAddSpawnOverrides(category).addSpawn(spawn);
                    }
                }
            }
        }
    }

    @NotNull
    public MapCodec<? extends StructureModifier> codec() {
        return Companion.makeCodec();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Ldev/hybridlabs/aquatic/world/gen/structure/StructureSpawnModifier$Companion;", "", "<init>", "()V", "makeCodec", "Lcom/mojang/serialization/MapCodec;", "Lnet/neoforged/neoforge/common/world/StructureModifier;", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<? extends StructureModifier> makeCodec() {
            MapCodec mapCodec = RecordCodecBuilder.mapCodec(Companion::makeCodec$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
            return mapCodec;
        }

        private static final App makeCodec$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)SpawnModifier.Companion.getCODEC().fieldOf("modifier").forGetter(Companion::makeCodec$lambda$0$0)).apply((Applicative)instance, StructureSpawnModifier::new);
        }

        private static final SpawnModifier makeCodec$lambda$0$0(StructureSpawnModifier modifier) {
            return modifier.getSpawnModifier();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

