package uk.co.cablepost.ftech_robots;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3230;
import net.minecraft.class_3414;
import net.minecraft.class_4048;
import net.minecraft.class_7923;
import uk.co.cablepost.ftech_robots.buildInstructions.CreateSchematicInstructionItem;
import uk.co.cablepost.ftech_robots.buildInstructions.InPersonAreaFillerItem;
import uk.co.cablepost.ftech_robots.buildInstructions.InPersonPathPlotterItem;
import uk.co.cablepost.ftech_robots.commandCenter.CommandCenterInit;
import uk.co.cablepost.ftech_robots.materialProvider.MaterialProviderInit;
import uk.co.cablepost.ftech_robots.robot.RobotEntity;

import java.util.Comparator;
import java.util.UUID;

public class F_TechRobots implements ModInitializer {
    public static final String MOD_ID = "f_tech_robots";

    public static int GLOBAL_ROBOT_PATH_CALC_COOLDOWN = 100;// To limit robots from all trying to path at once

    public static final class_3230<UUID> ROBOT_CHUNK_TICKET_TYPE = class_3230.method_14291("f_tech_robot", Comparator.comparingLong(x -> x.getMostSignificantBits() & Long.MAX_VALUE));
    public static final class_3230<class_2338> COMMAND_CENTER_TICKET_TYPE = class_3230.method_14291("f_tech_robot_command_center", class_2382::method_10265);

    public static final class_1299<RobotEntity> ROBOT_ENTITY = class_2378.method_10230(
            class_7923.field_41177,
            new class_2960(MOD_ID, "robot"),
            FabricEntityTypeBuilder.create(class_1311.field_17715, RobotEntity::new).dimensions(class_4048.method_18385(0.5f, 0.5f)).build()
    );

    public static final class_2960 ROBOT_HOVER_SOUND_ID = new class_2960(MOD_ID, "robot_hover_sound");
    public static class_3414 ROBOT_HOVER_SOUND_EVENT = class_3414.method_47908(ROBOT_HOVER_SOUND_ID);

    public static final CommandCenterInit COMMAND_CENTER = new CommandCenterInit();
    public static final MaterialProviderInit MATERIAL_PROVIDER = new MaterialProviderInit();

    public static final InPersonPathPlotterItem IN_PERSON_PATH_PLOTTER_ITEM = new InPersonPathPlotterItem(new FabricItemSettings().method_7889(1));
    public static final InPersonAreaFillerItem IN_PERSON_AREA_FILLER_ITEM = new InPersonAreaFillerItem(new FabricItemSettings().method_7889(1));
    public static final CreateSchematicInstructionItem CREATE_SCHEMATIC_INSTRUCTION_ITEM = new CreateSchematicInstructionItem(new FabricItemSettings().method_7889(1));

    public static final class_1761 ITEM_GROUP = FabricItemGroup.builder()
        .method_47320(() -> new class_1799(COMMAND_CENTER.getBlock()))
        .method_47321(class_2561.method_43471("itemGroup.f_tech_robots.items"))
        .method_47317((context, entries) -> {
            entries.method_45421(COMMAND_CENTER.getBlock());
            entries.method_45421(MATERIAL_PROVIDER.getBlock());
            entries.method_45421(IN_PERSON_PATH_PLOTTER_ITEM);
            entries.method_45421(IN_PERSON_AREA_FILLER_ITEM);
            entries.method_45421(CREATE_SCHEMATIC_INSTRUCTION_ITEM);
        })
        .method_47324()
    ;

    @Override
    public void onInitialize() {
        FabricDefaultAttributeRegistry.register(ROBOT_ENTITY, RobotEntity.method_26827());

        COMMAND_CENTER.onInitialize();
        MATERIAL_PROVIDER.onInitialize();

        class_2378.method_10230(class_7923.field_41178, new class_2960(MOD_ID, "in_person_path_plotter"), IN_PERSON_PATH_PLOTTER_ITEM);
        class_2378.method_10230(class_7923.field_41178, new class_2960(MOD_ID, "in_person_area_filler"), IN_PERSON_AREA_FILLER_ITEM);
        class_2378.method_10230(class_7923.field_41178, new class_2960(MOD_ID, "create_schematic_instruction_item"), CREATE_SCHEMATIC_INSTRUCTION_ITEM);

        class_2378.method_10230(class_7923.field_44687, new class_2960(MOD_ID, "main_creative_inventory_tab"), ITEM_GROUP);

        // Add chunk tickets for robots and controllers based on what is in world state
        ServerWorldEvents.LOAD.register((server, serverWorld) -> {
            F_TechRobots.GLOBAL_ROBOT_PATH_CALC_COOLDOWN = 100;
            StateSaverAndLoader fTechRobotsState = serverWorld.method_17983().method_17924(StateSaverAndLoader::createFromNbt, StateSaverAndLoader::new, F_TechRobots.MOD_ID);
            fTechRobotsState.robotChunkPoses.forEach((x -> serverWorld.method_14178().method_17297(F_TechRobots.ROBOT_CHUNK_TICKET_TYPE, x.chunkPos, 3, x.uuid)));
            fTechRobotsState.controllerBlockPoses.forEach((x -> serverWorld.method_14178().method_17297(F_TechRobots.COMMAND_CENTER_TICKET_TYPE, new class_1923(x), 3, x)));
        });

        ServerTickEvents.START_SERVER_TICK.register((server) -> {
            if(F_TechRobots.GLOBAL_ROBOT_PATH_CALC_COOLDOWN > 0){
                F_TechRobots.GLOBAL_ROBOT_PATH_CALC_COOLDOWN--;
            }
        });
    }
}
