package uk.co.cablepost.ftech_robots;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import uk.co.cablepost.ftech_robots.models.BlockPosAndItem;
import uk.co.cablepost.ftech_robots.models.UuidAndChunkPos;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_4844;

public class StateSaverAndLoader extends class_18 {
    public List<BlockPosAndItem> materialProviders = new ArrayList<>();
    public List<UuidAndChunkPos> robotChunkPoses = new ArrayList<>();
    public List<class_2338> controllerBlockPoses = new ArrayList<>();

    private static final Codec<BlockPosAndItem> BLOCK_POS_AND_ITEM_CODEC = RecordCodecBuilder.create(instance -> instance.group(
        class_2338.field_25064.fieldOf("pos").forGetter(BlockPosAndItem::getBlockPos),
        class_1799.field_24671.fieldOf("item").forGetter(BlockPosAndItem::getItemStack)
    ).apply(instance, BlockPosAndItem::new));

    private static final Codec<UuidAndChunkPos> UUID_AND_CHUNK_POS_CODEC = RecordCodecBuilder.create(instance -> instance.group(
        class_4844.field_40825.fieldOf("uuid").forGetter(UuidAndChunkPos::getUuid),
        Codec.LONG.fieldOf("pos").forGetter(UuidAndChunkPos::getChunkPosLong)
    ).apply(instance, UuidAndChunkPos::new));

    @Override
    public class_2487 method_75(class_2487 nbt) {
        // Material Providers
        {
            Codec<List<BlockPosAndItem>> listCodec = BLOCK_POS_AND_ITEM_CODEC.listOf();
            Optional<class_2520> listNbt = listCodec.encodeStart(class_2509.field_11560, materialProviders).result();

            if (listNbt.isEmpty()) {
                throw new RuntimeException("Failed to write materialProviders to NBT");
            }

            nbt.method_10566("materialProviders", listNbt.get());
        }

        // Robot Chunk Poses
        {
            Codec<List<UuidAndChunkPos>> listCodec = UUID_AND_CHUNK_POS_CODEC.listOf();
            Optional<class_2520> listNbt = listCodec.encodeStart(class_2509.field_11560, robotChunkPoses).result();

            if (listNbt.isEmpty()) {
                throw new RuntimeException("Failed to write robotChunkPoses to NBT");
            }

            nbt.method_10566("robotChunkPoses", listNbt.get());
        }

        // Controller BlockPoses
        {
            Codec<List<class_2338>> listCodec = class_2338.field_25064.listOf();
            Optional<class_2520> listNbt = listCodec.encodeStart(class_2509.field_11560, controllerBlockPoses).result();

            if (listNbt.isEmpty()) {
                throw new RuntimeException("Failed to write controllerBlockPoses to NBT");
            }

            nbt.method_10566("controllerBlockPoses", listNbt.get());
        }

        return nbt;
    }

    public static StateSaverAndLoader createFromNbt(class_2487 tag) {
        StateSaverAndLoader state = new StateSaverAndLoader();

        // Material Providers
        {
            class_2520 listNbt = tag.method_10580("materialProviders");
            //System.out.println("materialProviders NBT: " + materialProvidersNbt);
            Codec<List<BlockPosAndItem>> listCodec = BLOCK_POS_AND_ITEM_CODEC.listOf();
            Optional<List<BlockPosAndItem>> list = listCodec.parse(class_2509.field_11560, listNbt).result();

            if(list.isEmpty()){
                //System.out.println("materialProviders NBT could not be parsed with codec");
                throw new RuntimeException("Failed to read materialProviders from NBT");
            }

            state.materialProviders = new ArrayList<>(list.get());
            //System.out.println("materialProviders: " + state.materialProviders);
            //System.out.println("materialProviders size: " + state.materialProviders.size());
        }

        // Robot Chunk Poses
        {
            class_2520 listNbt = tag.method_10580("robotChunkPoses");
            Codec<List<UuidAndChunkPos>> listCodec = UUID_AND_CHUNK_POS_CODEC.listOf();
            Optional<List<UuidAndChunkPos>> list = listCodec.parse(class_2509.field_11560, listNbt).result();

            if(list.isEmpty()){
                throw new RuntimeException("Failed to read robotChunkPoses from NBT");
            }

            state.robotChunkPoses = new ArrayList<>(list.get());
        }

        // Robot Chunk Poses
        {
            class_2520 listNbt = tag.method_10580("controllerBlockPoses");
            Codec<List<class_2338>> listCodec = class_2338.field_25064.listOf();
            Optional<List<class_2338>> list = listCodec.parse(class_2509.field_11560, listNbt).result();

            if(list.isEmpty()){
                throw new RuntimeException("Failed to read controllerBlockPoses from NBT");
            }

            state.controllerBlockPoses = new ArrayList<>(list.get());
        }

        return state;
    }
}