package uk.co.cablepost.ftech_robots.buildInstructions;

import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public abstract class AbstractInPersonTwoPointItem extends AbstractBuildInstructionsItem {
    public AbstractInPersonTwoPointItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        if(context.method_8036() == null || !context.method_8036().method_5715()){
            return class_1269.field_5811;
        }

        onUse(context.method_8045(), context.method_8036(), context.method_8041(), context.method_8037());
        return class_1269.field_5812;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
        class_1799 itemStack = playerEntity.method_5998(hand);

        if(playerEntity.method_5715()){
            return class_1271.method_22430(itemStack);
        }

        onUse(world, playerEntity, itemStack, null);
        return class_1271.method_22427(itemStack);
    }

    private void onUse(class_1937 world, class_1657 playerEntity, class_1799 itemStack, @Nullable class_2338 usedOnBlockPos){
        if(world.method_8608()){
            return;
        }

        if(getFirstPosition(itemStack) == null){
            class_2338 firstPos = getFirstPos(itemStack, world, playerEntity, usedOnBlockPos);

            if(firstPos == null){
                return;
            }

            setFirstPosition(itemStack, firstPos);
            playerEntity.method_43496(class_2561.method_43471("two_point_item.set_first_position"));
            return;
        }

        if(getSecondPosition(itemStack) == null) {
            class_2338 firstPos = getFirstPosition(itemStack);
            class_2338 secondPos = getSecondPos(itemStack, world, playerEntity, usedOnBlockPos, firstPos);

            if(secondPos == null){
                return;
            }

            assert firstPos != null;

            if(firstPos.method_19455(new class_2338(secondPos.method_10263(), firstPos.method_10264(), secondPos.method_10260())) > 500) {
                playerEntity.method_43496(class_2561.method_43471("two_point_item.too_long"));
                return;
            }

            if(!setBuildInstructions(itemStack, world, playerEntity, firstPos, secondPos)){
                return;
            }
            setSecondPosition(itemStack, secondPos);
            playerEntity.method_43496(class_2561.method_43471("two_point_item.set_second_position"));
            return;
        }

        wipePositions(itemStack);
        new BuildInstructions(itemStack, world).wipeInstructionsAndInstructionsNbt(world, true);
        playerEntity.method_43496(class_2561.method_43471("two_point_item.positions_wiped"));
    }

    abstract @Nullable class_2338 getFirstPos(class_1799 itemStack, class_1937 world, class_1657 playerEntity, @Nullable class_2338 usedOnBlockPos);
    abstract @Nullable class_2338 getSecondPos(class_1799 itemStack, class_1937 world, class_1657 playerEntity, @Nullable class_2338 usedOnBlockPos, class_2338 firstPos);
    abstract boolean setBuildInstructions(class_1799 itemStack, class_1937 world, class_1657 playerEntity, class_2338 firstPos, class_2338 secondPos);

//    @Override
//    public boolean hasGlint(ItemStack stack) {
//        return getFirstPosition(stack) != null && getSecondPosition(stack) != null;
//    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add(class_2561.method_43471("two_point_item.tooltip_1").method_27692(class_124.field_1054));
        tooltip.add(class_2561.method_43471("two_point_item.tooltip_2").method_27692(class_124.field_1054));
        tooltip.add(class_2561.method_43471("two_point_item.tooltip_3").method_27692(class_124.field_1054));

        if(getFirstPosition(stack) == null){
            tooltip.add(class_2561.method_43471("two_point_item.no_positions_set").method_27692(class_124.field_1065));
        }
        else if(getSecondPosition(stack) == null){
            tooltip.add(class_2561.method_43471("two_point_item.first_position_set").method_27692(class_124.field_1065));
        }
        else{
            tooltip.add(class_2561.method_43471("two_point_item.second_position_set").method_27692(class_124.field_1065));
        }
    }

    static @Nullable class_2338 getFirstPosition(class_1799 itemStack){
        class_2487 nbtCompound = itemStack.method_7948();

        if(!nbtCompound.method_10545("pos_1_x")){
            return null;
        }

        return new class_2338(
            nbtCompound.method_10550("pos_1_x"),
            nbtCompound.method_10550("pos_1_y"),
            nbtCompound.method_10550("pos_1_z")
        );
    }

    private static void setFirstPosition(class_1799 itemStack, class_2338 pos){
        class_2487 nbtCompound = itemStack.method_7948();
        nbtCompound.method_10569("pos_1_x", pos.method_10263());
        nbtCompound.method_10569("pos_1_y", pos.method_10264());
        nbtCompound.method_10569("pos_1_z", pos.method_10260());
    }

    static @Nullable class_2338 getSecondPosition(class_1799 itemStack){
        class_2487 nbtCompound = itemStack.method_7948();

        if(!nbtCompound.method_10545("pos_2_x")){
            return null;
        }

        return new class_2338(
        nbtCompound.method_10550("pos_2_x"),
        nbtCompound.method_10550("pos_2_y"),
        nbtCompound.method_10550("pos_2_z")
        );
    }

    private static void setSecondPosition(class_1799 itemStack, class_2338 pos){
        class_2487 nbtCompound = itemStack.method_7948();
        nbtCompound.method_10569("pos_2_x", pos.method_10263());
        nbtCompound.method_10569("pos_2_y", pos.method_10264());
        nbtCompound.method_10569("pos_2_z", pos.method_10260());
    }

    private static void wipePositions(class_1799 itemStack){
        class_2487 nbtCompound = itemStack.method_7948();
        nbtCompound.method_10551("pos_1_x");
        nbtCompound.method_10551("pos_1_y");
        nbtCompound.method_10551("pos_1_z");
        nbtCompound.method_10551("pos_2_x");
        nbtCompound.method_10551("pos_2_y");
        nbtCompound.method_10551("pos_2_z");
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected){
        super.method_7888(stack, world, entity, slot, selected);

        if(!selected || world.method_8608() || world.method_8510() % 5 != 0){
            return;
        }

        class_2338 firstPosition = getFirstPosition(stack);
        if(firstPosition != null) {
            highlightBlock((class_3218) world, firstPosition);
        }

        class_2338 secondPosition = getSecondPosition(stack);
        if(secondPosition != null) {
            highlightBlock((class_3218) world, secondPosition);
        }
    }
}
