package uk.co.cablepost.ftech_robots.buildInstructions;

import org.jetbrains.annotations.Nullable;

import java.io.*;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_5218;

public class BuildInstructionsFileUtils {
    public static void save(class_3218 serverWorld, String fileName, class_2520 nbtElement){
        class_2487 compound = new class_2487();
        compound.method_10566("instructions", nbtElement);

        class_156.method_27958().execute(() -> {
            try {
                class_2507.method_10630(compound, getSaveFile(serverWorld, fileName));
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static @Nullable class_2520 load(class_3218 serverWorld, String fileName){
        File file = getSaveFile(serverWorld, fileName);

        if (!file.exists()) {
            return null;
        }

        class_2487 nbtCompound;

        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            PushbackInputStream pushbackInputStream = new PushbackInputStream(fileInputStream, 2);
            DataInputStream dataInputStream = new DataInputStream(pushbackInputStream);
            nbtCompound = class_2507.method_10627(dataInputStream);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        return nbtCompound.method_10580("instructions");
    }

    public static boolean delete(class_3218 serverWorld, String fileName){
        File file = getSaveFile(serverWorld, fileName);
        return file.delete();
    }

    private static File getSaveFile(class_3218 serverWorld, String fileName){
        File saveFolder = serverWorld.method_8503().method_27050(class_5218.field_24188).resolve("f_tech_robots/instructions").toFile();
        if(!saveFolder.exists()){
            saveFolder.mkdirs();
        }
        return new File(saveFolder, fileName + ".dat");
    }
}
