package uk.co.cablepost.ftech_robots.buildInstructions;

import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.schematics.SchematicItem;
import com.simibubi.create.content.schematics.SchematicPrinter;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_5536;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ftech_robots.models.BlockPosAndState;

import java.util.ArrayList;
import java.util.List;

public class CreateSchematicInstructionItem extends AbstractBuildInstructionsItem {
    public CreateSchematicInstructionItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add(class_2561.method_43471("create_schematic_instruction_item.tooltip_1").method_27692(class_124.field_1054));
        tooltip.add(class_2561.method_43471("create_schematic_instruction_item.tooltip_2").method_27692(class_124.field_1054));
        tooltip.add(class_2561.method_43471("create_schematic_instruction_item.tooltip_3").method_27692(class_124.field_1080));

        class_2487 nbtCompound = stack.method_7948();
        if(nbtCompound.method_10545("instructions_uuid")){
            tooltip.add(class_2561.method_43471("create_schematic_instruction_item.ready").method_27692(class_124.field_1065));
        }
    }

    @Override
    public boolean method_31565(class_1799 itemStack, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType != class_5536.field_27014) {
            return false;
        }

        if(!FabricLoader.getInstance().isModLoaded("create")){
            return false;
        }

        if(slot.method_7677().method_7909() instanceof SchematicItem){
            class_2487 nbtCompound = itemStack.method_7948();
            class_2487 schematicItemNbt = slot.method_7677().method_7948();
            if(!schematicItemNbt.method_10577("Deployed")){
                player.method_43496(class_2561.method_43471("create_schematic_instruction_item.schematic_not_deployed"));
                return false;
            }
            nbtCompound.method_10566("CreateSchematicItemNbt", schematicItemNbt);

            player.method_5783(class_3417.field_26979, 1f, 1f);
            return true;
        }

        return false;
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected){
        super.method_7888(stack, world, entity, slot, selected);

        if(world.method_8608()){
            return;
        }

        if(!FabricLoader.getInstance().isModLoaded("create")){
            return;
        }

        // This is run server side, so if there is a tag saying the block needs changing in the instructions, will re-write them here and save to file
        class_2487 nbtCompound = stack.method_7948();
        if(nbtCompound.method_10545("CreateSchematicItemNbt")){
            SchematicPrinter printer = new SchematicPrinter();

            class_1799 schematicStack = new class_1799(class_1802.field_8831);
            schematicStack.method_7980(nbtCompound.method_10562("CreateSchematicItemNbt"));

            printer.loadSchematic(schematicStack, world, false);
            if (!printer.isLoaded() || printer.isErrored()) {
                nbtCompound.method_10551("CreateSchematicItemNbt");
                return;
            }

            ArrayList<BlockPosAndState> instructions = new ArrayList<>();

            while (printer.advanceCurrentPos()) {
                if (!printer.shouldPlaceCurrent(world))
                    continue;

                printer.handleCurrentTarget((pos, state, blockEntity) -> {
                    if (state.method_26215()) {
                        return;
                    }

                    if(state.method_26204() instanceof BeltBlock){
                        return;
                    }
                    instructions.add(new BlockPosAndState(pos, state));
                }, (pos, entity2) -> {
                    //world.spawnEntity(entity2);
                });
            }

            new BuildInstructions(stack, world).setInstructionsAndWrite(instructions, world, entity.method_24515());
            nbtCompound.method_10551("CreateSchematicItemNbt");
        }
    }
}
