package uk.co.cablepost.ftech_robots.buildInstructions;

import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ftech_robots.models.BlockPosAndState;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_5536;

public class InPersonAreaFillerItem extends AbstractInPersonTwoPointItem {
    public InPersonAreaFillerItem(class_1793 settings) {
        super(settings);
    }

    @Override
    @Nullable
    class_2338 getFirstPos(class_1799 itemStack, class_1937 world, class_1657 playerEntity, @Nullable class_2338 usedOnBlockPos) {
        if(usedOnBlockPos != null){
            return usedOnBlockPos;
        }
        return playerEntity.method_24515();
    }

    @Override
    @Nullable
    class_2338 getSecondPos(class_1799 itemStack, class_1937 world, class_1657 playerEntity, @Nullable class_2338 usedOnBlockPos, class_2338 firstPos) {
        if(usedOnBlockPos != null){
            return usedOnBlockPos;
        }
        return playerEntity.method_24515();
    }

    @Override
    boolean setBuildInstructions(class_1799 itemStack, class_1937 world, class_1657 playerEntity, class_2338 firstPos, class_2338 secondPos) {
        class_2680 blockState = getFillBlockState(itemStack);

        ArrayList<BlockPosAndState> instructions = new ArrayList<>();

        for(int x = Math.min(firstPos.method_10263(), secondPos.method_10263()); x <= Math.max(firstPos.method_10263(), secondPos.method_10263()); x++){
            for(int y = Math.min(firstPos.method_10264(), secondPos.method_10264()); y <= Math.max(firstPos.method_10264(), secondPos.method_10264()); y++){
                for(int z = Math.min(firstPos.method_10260(), secondPos.method_10260()); z <= Math.max(firstPos.method_10260(), secondPos.method_10260()); z++){
                    instructions.add(new BlockPosAndState(new class_2338(x, y, z), blockState));
                }
            }
        }

        new BuildInstructions(itemStack, world).setInstructionsAndWrite(instructions, world, playerEntity.method_24515());
        return true;
    }

    private class_2680 getFillBlockState(class_1799 itemStack){
        class_2487 nbtCompound = itemStack.method_7948();
        class_2680 blockState = class_2246.field_10124.method_9564();
        if(nbtCompound.method_10545("fill_block_state")){
            Optional<class_2680> bs = class_2680.field_24734.parse(class_2509.field_11560, nbtCompound.method_10580("fill_block_state")).result();
            if(bs.isEmpty()){
                throw new RuntimeException("Failed to read blockState to NBT");
            }
            blockState = bs.get();
        }

        return blockState;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        class_2680 blockState = getFillBlockState(stack);
        tooltip.add(class_2561.method_43470("Fill block: ").method_10852(class_2561.method_43471(blockState.method_26204().method_9539())).method_27692(class_124.field_1060));
    }

    @Override
    public boolean method_31565(class_1799 itemStack, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType != class_5536.field_27014) {
            return false;
        }

        class_2680 blockState = class_2246.field_10124.method_9564();
        if(slot.method_7677().method_7909() instanceof class_1747 blockItem){
            blockState = blockItem.method_7711().method_9564();
        }

        class_2487 nbtCompound = itemStack.method_7948();
        Optional<class_2520> blockStateNbt = class_2680.field_24734.encodeStart(class_2509.field_11560, blockState).result();
        if(blockStateNbt.isEmpty()){
            throw new RuntimeException("Failed to write blockState to NBT");
        }
        nbtCompound.method_10566("fill_block_state", blockStateNbt.get());
        nbtCompound.method_10556("fill_block_state_changed", true);// As this is client side, can't write to instructions file here, but can set NBT that is sent to the server (handled in inventoryTick below)

        player.method_5783(class_3417.field_26979, 1f, 1f);

        return true;
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected){
        super.method_7888(stack, world, entity, slot, selected);

        if(world.method_8608()){
            return;
        }

        // This is run server side, so if there is a tag saying the block needs changing in the instructions, will re-write them here and save to file
        class_2487 nbtCompound = stack.method_7948();
        if(nbtCompound.method_10545("fill_block_state_changed")){
            class_2338 firstPosition = getFirstPosition(stack);
            class_2338 secondPosition = getSecondPosition(stack);
            if(firstPosition != null && secondPosition != null && entity instanceof class_1657 player){
                setBuildInstructions(stack, player.method_37908(), player, firstPosition, secondPosition);
            }
            nbtCompound.method_10551("fill_block_state_changed");
        }
    }
}