package uk.co.cablepost.ftech_robots.buildInstructions;

import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ftech_robots.dynamicPaths.DynamicPath;
import uk.co.cablepost.ftech_robots.models.BlockPosAndState;

import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;

public class InPersonPathPlotterItem extends AbstractInPersonTwoPointItem {

    public InPersonPathPlotterItem(class_1793 settings) {
        super(settings);
    }

    @Override
    @Nullable class_2338 getFirstPos(class_1799 itemStack, class_1937 world, class_1657 playerEntity, @Nullable class_2338 usedOnBlockPos) {
        if(usedOnBlockPos != null){
            return usedOnBlockPos;
        }
        return playerEntity.method_24515().method_10069(0, -1, 0);
    }

    @Override
    @Nullable class_2338 getSecondPos(class_1799 itemStack, class_1937 world, class_1657 playerEntity, @Nullable class_2338 usedOnBlockPos, class_2338 firstPos) {
        class_2338 blockPos = playerEntity.method_24515().method_10069(0, -1, 0);
        if(usedOnBlockPos != null){
            blockPos = new class_2338(usedOnBlockPos);
        }

        if(firstPos.method_19455(new class_2338(blockPos.method_10263(), firstPos.method_10264(), blockPos.method_10260())) == 0) {
            playerEntity.method_43496(class_2561.method_43471("in_person_path_plotter.positions_invalid"));
            return null;
        }

        return blockPos;
    }

    @Override
    boolean setBuildInstructions(class_1799 itemStack, class_1937 world, class_1657 playerEntity, class_2338 firstPos, class_2338 secondPos) {
        DynamicPath dynamicPath = new DynamicPath(
            world,
            firstPos,
            secondPos
        );
        ArrayList<BlockPosAndState> instructions = new ArrayList<>(dynamicPath.getBlocks().entrySet().stream().toList().stream().map((x) -> new BlockPosAndState(x.getKey(), x.getValue())).toList());

        new BuildInstructions(itemStack, world).setInstructionsAndWrite(instructions, world, playerEntity.method_24515());
        return true;
    }
}
