package uk.co.cablepost.ftech_robots.commandCenter;

import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.f_tech.config.FTechConfig;
import uk.co.cablepost.f_tech.machines.abstract_machine.AbstractMachineBlockEntity;
import uk.co.cablepost.ftech_robots.F_TechRobots;
import uk.co.cablepost.ftech_robots.StateSaverAndLoader;
import uk.co.cablepost.ftech_robots.buildInstructions.AbstractBuildInstructionsItem;
import uk.co.cablepost.ftech_robots.models.BlockPosAndState;
import uk.co.cablepost.ftech_robots.buildInstructions.BuildInstructions;
import uk.co.cablepost.ftech_robots.robot.RobotEntity;

import java.util.*;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class CommandCenterBlockEntity extends AbstractMachineBlockEntity {
    private int lastPlotItemHash = 0;
    private @Nullable BuildInstructions buildInstructions = null;
    List<UUID> robots = new ArrayList<>();
    private int robotSpawnDelayCounter = 0;
    private int robotLastInOutCooldown = 0;
    private boolean needToStartChunkLoading = true;
    private int loadRobotsGracePeriod = 1000;

    public float clientRobotArmAnimationCounter = -1;
    public int clientLastRobotCount = -1;
    public boolean clientRobotArmAnimationDirection = false;


    public CommandCenterBlockEntity(class_2338 pos, class_2680 state) {
        super(
            F_TechRobots.COMMAND_CENTER.getBlockEntity(),
            pos,
            state,
            new int[]{ 0 },
            new int[]{ 1 },
            1000000,
            1000,
            0,
            false
        );
    }

    @Override
    public int getMaxProcessProgress() {
        return buildInstructions == null ? 0 : (buildInstructions.getStartingSize() == null ? 0 : buildInstructions.getStartingSize());
    }

    private void writeNbt(class_2487 tag, boolean saveToFile){
        if(buildInstructions != null){
            buildInstructions.writeInstructionsNbt(field_11863, saveToFile);
        }

        super.method_11007(tag);

        int c = 0;
        for(UUID robot : robots){
            tag.method_25927("Robot_" + c, robot);
            c++;
        }
    }

    @Override
    public void method_11007(class_2487 tag) {
        writeNbt(tag, true);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);

        robots = new ArrayList<>();
        for(String key : tag.method_10541()){
            if(key.startsWith("Robot_")){
                robots.add(tag.method_25926(key));
            }
        }
    }

    @Override
    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();

        this.writeNbt(nbtCompound, false);

        return nbtCompound;
    }

    @Override
    public int processEnergyConsumption() {
        return 100 * FTechConfig.CONFIG.getOrDefault("f_tech_core.energy_mul", 1);
    }

    public boolean haveEnoughEnergy(){
        return _energyStorage.amount >= processEnergyConsumption();
    }

    @Override
    public void serverTickExtra() {
        if(needToStartChunkLoading){
            assert field_11863 != null;
            ((class_3218)field_11863).method_14178().method_17297(F_TechRobots.COMMAND_CENTER_TICKET_TYPE, new class_1923(field_11867), 3, field_11867);

            StateSaverAndLoader fTechRobotsState = ((class_3218)field_11863).method_17983().method_17924(StateSaverAndLoader::createFromNbt, StateSaverAndLoader::new, F_TechRobots.MOD_ID);
            if(fTechRobotsState.controllerBlockPoses.stream().noneMatch((x -> x.method_19455(field_11867) == 0))){
                fTechRobotsState.controllerBlockPoses.add(field_11867);
                fTechRobotsState.method_80();
            }

            needToStartChunkLoading = false;
        }

        int currentPlotItemHash = 0;
        if(!_inventory.get(0).method_7960()){
            currentPlotItemHash = _inventory.get(0).hashCode();
        }

        if(lastPlotItemHash != currentPlotItemHash){
            buildInstructions = null;

            if(currentPlotItemHash != 0 && _inventory.get(0).method_7909() instanceof AbstractBuildInstructionsItem){
                buildInstructions = new BuildInstructions(_inventory.get(0), field_11863);
            }

            lastPlotItemHash = currentPlotItemHash;
        }

        long processEnergyConsumption = processEnergyConsumption();
        if(buildInstructions != null) {
            if(_energyStorage.amount > 0) {
                _energyStorage.amount = Math.max(0, _energyStorage.amount - processEnergyConsumption);
                method_5431();
            }
        }

        class_2338 homePos = field_11867.method_10069(0, 3, 0);
        assert field_11863 != null;
        robotSpawnDelayCounter++;
        if(robotLastInOutCooldown < 1000) {
            robotLastInOutCooldown++;
        }
        if (robotSpawnDelayCounter >= 30) {
            robotSpawnDelayCounter = 0;

            if(
                robots.size() < 30 &&
                buildInstructions != null &&
                robotLastInOutCooldown > 50 &&
                _energyStorage.amount >= processEnergyConsumption
            ){
                {
                    Integer blocksToChangeSize = buildInstructions.getBlocksToChangeSize();
                    if(blocksToChangeSize != null) {
                        int lastProcessProgress = _processProgress;
                        _processProgress = getMaxProcessProgress() - blocksToChangeSize;
                        if(lastProcessProgress != _processProgress) {
                            method_5431();
                        }
                    }
                    else{
                        if(_processProgress > 0){
                            method_5431();
                        }
                        _processProgress = 0;
                    }
                }

                BlockPosAndState toDoNext = buildInstructions.getNextBlockToChange(field_11863, null);
                if(toDoNext != null) {
                    //buildInstructions.removeBlockToChange(toDoNext.blockPos, toDoNext.blockState);

                    RobotEntity robotEntity = F_TechRobots.ROBOT_ENTITY.method_5883(field_11863);

                    assert robotEntity != null;
                    robotEntity.method_5808(homePos.method_46558().method_10216(), homePos.method_46558().method_10214(), homePos.method_46558().method_10215(), 0.0f, 0.0f);
                    robotEntity.setHomeLocation(homePos);
                    robotEntity.tryGetObjectives(this);

                    field_11863.method_8649(robotEntity);

                    robots.add(robotEntity.method_5667());
                    robotLastInOutCooldown = 0;

                    method_5431();
                    field_11863.method_8413(field_11867, field_11863.method_8320(field_11867), field_11863.method_8320(field_11867), class_2248.field_31028);
                }
                else{
                    // Try to move instructions item into output slot and wipe it (by creating a new version of the item)
                    if(method_5438(1).method_7960()){
                        method_5447(1, new class_1799(method_5438(0).method_7909()));
                        method_5441(0);
                        buildInstructions.wipeInstructionsAndInstructionsNbt(field_11863, true);
                        buildInstructions = null;
                        lastPlotItemHash = 0;
                        method_5431();
                    }
                }
            }

            if(buildInstructions == null){
                _processProgress = 0;
            }
            else{
                if(!robots.isEmpty() && robots.stream().anyMatch(x -> {
                    RobotEntity robot = (RobotEntity) ((class_3218) field_11863).method_14190(x);
                    if (robot == null) {
                        return false;
                    }

                    return
                        robot.method_24515().method_10263() == homePos.method_10263() &&
                        robot.method_24515().method_10264() == homePos.method_10264() &&
                        robot.method_24515().method_10260() == homePos.method_10260()
                    ;
                })) {
                    buildInstructions.removeCompletedInstructions(field_11863);
                }
            }
        }

        if(robotLastInOutCooldown > 50){
            for(int i = robots.size() - 1; i >= 0; i--){
                RobotEntity robot = (RobotEntity)((class_3218)field_11863).method_14190(robots.get(i));

                if(robot == null){
                    continue;
                }

                Integer blocksToChangeSize = (buildInstructions == null) ? Integer.valueOf(0) : buildInstructions.getBlocksToChangeSize();
                if(
                    (blocksToChangeSize == null || blocksToChangeSize == 0) &&
                    !robot.hasObjective() &&
                    robot.method_24515().method_10263() == homePos.method_10263() &&
                    robot.method_24515().method_10264() == homePos.method_10264() &&
                    robot.method_24515().method_10260() == homePos.method_10260()
                ){
                    robots.remove(robot.method_5667());
                    robotLastInOutCooldown = 0;

                    robot.method_20620(homePos.method_46558().field_1352, homePos.method_46558().field_1351, homePos.method_46558().field_1350);
                    for(int j = 0; j < 5; j++) {
                        ((class_3218) field_11863).method_14199(
                            class_2398.field_11204,
                            homePos.method_10263() - 0.5f + field_11863.field_9229.method_43058() * 2f,
                            homePos.method_10264() + field_11863.field_9229.method_43058() * 1.6f,
                            homePos.method_10260() - 0.5f + field_11863.field_9229.method_43058() * 2f,
                            5,
                            0, 0, 0, 0
                        );
                    }
                    robot.method_5650(class_1297.class_5529.field_26998);
                    method_5431();
                    field_11863.method_8413(field_11867, field_11863.method_8320(field_11867), field_11863.method_8320(field_11867), class_2248.field_31028);

                    break;
                }
            }
        }

        if(loadRobotsGracePeriod > 0){
            loadRobotsGracePeriod--;
        }
        else {
            boolean removedA = robots.removeIf(robotUuid -> {
                RobotEntity robot = (RobotEntity) ((class_3218) field_11863).method_14190(robotUuid);
                return robot == null || !robot.method_5805();
            });
            boolean removedB = robots.removeIf(Objects::isNull);

            if(removedA || removedB) {
                method_5431();
                field_11863.method_8413(field_11867, field_11863.method_8320(field_11867), field_11863.method_8320(field_11867), class_2248.field_31028);
            }
        }
    }

    public void killRobots(){
        assert field_11863 != null;
        for(int i = robots.size() - 1; i >= 0; i--){
            RobotEntity robot = (RobotEntity)((class_3218)field_11863).method_14190(robots.get(i));

            if(robot == null){
                continue;
            }
            robots.remove(robot);
            robot.method_5650(class_1297.class_5529.field_26998);
            field_11863.method_8413(field_11867, field_11863.method_8320(field_11867), field_11863.method_8320(field_11867), class_2248.field_31028);
        }
    }

    public boolean containsRobot(UUID uuid){
        return robots.contains(uuid);
    }

    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new CommandCenterScreenHandler(syncId, playerInventory, this, _propertyDelegate);
    }

    public @Nullable BlockPosAndState getNextBlockToChange(@Nullable class_1792 ofItem) {
        if(buildInstructions == null){
            return null;
        }

        return buildInstructions.getNextBlockToChange(field_11863, ofItem);
    }

    public void removeBlockToChange(class_2338 objectiveLocation, class_2680 blockState) {
        if(buildInstructions == null){
            return;
        }

        buildInstructions.removeBlockToChange(objectiveLocation, blockState);

        Integer blocksToChangeSize = buildInstructions.getBlocksToChangeSize();
        if(blocksToChangeSize != null) {
            _processProgress = getMaxProcessProgress() - blocksToChangeSize;
        }

        method_5431();
    }

    public void sayPowerStatus(class_1657 player){
        if(!haveEnoughEnergy()){
            player.method_43496(class_2561.method_43470("Out of power, robots are unable to continue construction until more energy is supplied.").method_27692(class_124.field_1061).method_27692(class_124.field_1067));
        }
    }

    public void listRobotStatuses(class_1657 player) {
        for(UUID robotUuid : robots){
            assert field_11863 != null;
            RobotEntity robot = (RobotEntity)((class_3218)field_11863).method_14190(robotUuid);

            if(robot == null){
                continue;
            }

            player.method_43496(robot.getStatusText());
        }
    }
}
