package uk.co.cablepost.ftech_robots.commandCenter;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Vector3f;
import uk.co.cablepost.ftech_robots.F_TechRobots;
import uk.co.cablepost.ftech_robots.F_TechRobotsClient;
import uk.co.cablepost.ftech_robots.robot.RobotEntity;
import uk.co.cablepost.ftech_robots.robot.RobotEntityModel;

import java.util.Objects;

@Environment(EnvType.CLIENT)
public class CommandCenterBlockEntityRenderer implements class_827<CommandCenterBlockEntity> {

    final CommandCenterModel commandCenterModel;
    final CommandCenterRackModel commandCenterRackModel;
    final CommandCenterArmModel commandCenterArmModel;
    final RobotEntityModel<RobotEntity> robotEntityModel;

    public CommandCenterBlockEntityRenderer(class_5614.class_5615 ctx) {
        commandCenterModel = new CommandCenterModel(ctx.method_32140(CommandCenterInit.MODEL_COMMAND_CENTER_LAYER));
        commandCenterRackModel = new CommandCenterRackModel(ctx.method_32140(CommandCenterInit.MODEL_COMMAND_CENTER_RACK_LAYER));
        commandCenterArmModel = new CommandCenterArmModel(ctx.method_32140(CommandCenterInit.MODEL_COMMAND_CENTER_ARM_LAYER));
        robotEntityModel = new RobotEntityModel<>(ctx.method_32140(F_TechRobotsClient.MODEL_ROBOT_LAYER));
    }

    @Override
    public void render(CommandCenterBlockEntity blockEntity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        int light2 = class_761.method_23794(Objects.requireNonNull(blockEntity.method_10997()), blockEntity.method_11016().method_10069(0, 3, 0));

        // Frame
        {
            matrices.method_22903();
            matrices.method_46416(0.5f, 1.5f, 0.5f);

            matrices.method_22907(class_7833.field_40714.rotation((float) Math.PI));
            commandCenterModel.method_2828(matrices,
                vertexConsumers.getBuffer(class_1921.method_23576(new class_2960(F_TechRobots.MOD_ID, "textures/block/command_center.png"))),
                light2,
                overlay,
                1f,
                1f,
                1f,
                1f
            );

            matrices.method_22909();
        }

        // Update counter starters
        {
            if (blockEntity.clientLastRobotCount == -1) {
                blockEntity.clientLastRobotCount = blockEntity.robots.size();
            }
            else if(blockEntity.clientLastRobotCount < blockEntity.robots.size()){
                blockEntity.clientRobotArmAnimationCounter = 0;
                blockEntity.clientRobotArmAnimationDirection = true;
                blockEntity.clientLastRobotCount = blockEntity.robots.size();
            }
            else if(blockEntity.clientLastRobotCount > blockEntity.robots.size()){
                blockEntity.clientRobotArmAnimationCounter = 0;
                blockEntity.clientRobotArmAnimationDirection = false;
                blockEntity.clientLastRobotCount = blockEntity.robots.size();
            }
        }

        // Robot rack
        {
            int robotsOutCount = blockEntity.robots.size();

            if(blockEntity.clientRobotArmAnimationCounter != -1 && !blockEntity.clientRobotArmAnimationDirection){
                robotsOutCount++;
            }

            matrices.method_46416(0.5f, 3f, 0.5f);
            matrices.method_22907(class_7833.field_40714.rotation((float) Math.PI));

            for(int l = 0; l < 3; l++) {
                matrices.method_22903();
                matrices.method_46416(0f, 0.5f * l, 0f);
                for (double r = 0; r < 10; r++) {
                    matrices.method_22903();
                    matrices.method_22907(class_7833.field_40716.rotation((float) ((Math.PI * 2d / 10d) * r)));
                    matrices.method_46416(0.9f, 0f, 0f);
                    {
                        matrices.method_22903();
                        matrices.method_22907(class_7833.field_40716.rotation((float) Math.PI));
                        matrices.method_22905(0.8f, 0.8f, 0.8f);
                        matrices.method_46416(-0.35f, 0.78f, 0f);
                        commandCenterRackModel.method_2828(matrices,
                            vertexConsumers.getBuffer(class_1921.method_23576(new class_2960(F_TechRobots.MOD_ID, "textures/block/command_center_rack.png"))),
                            light2,
                            overlay,
                            1f,
                            1f,
                            1f,
                            1f
                        );
                        matrices.method_22909();
                    }
                    if(robotsOutCount <= l * 10 + r) {
                        robotEntityModel.method_2828(
                            matrices,
                            vertexConsumers.getBuffer(class_1921.method_23576(new class_2960(F_TechRobots.MOD_ID, "textures/entity/robot/robot.png"))),
                            light2,
                            overlay,
                            1, 1, 1, 1
                        );
                    }
                    matrices.method_22909();
                }
                matrices.method_22909();
            }
        }

        // Display animation
        double armHeight = 0d;
        double armDepth = 0d;
        double armAngle = 0d;

        if(blockEntity.clientRobotArmAnimationCounter > -1){
            blockEntity.clientRobotArmAnimationCounter += tickDelta;

            int animSpeedMul = 4;

            int indexOffset = blockEntity.clientRobotArmAnimationDirection ? 1 : 0;

            int slotShelf = 2 - (int)Math.floor((blockEntity.robots.size() - indexOffset) / 10f);
            double slotHeight = (2 - slotShelf) * 0.5f;
            double slotAngle = (Math.PI * 2d / 10d) * ((blockEntity.robots.size() % 10) - indexOffset);
            double slotDepth = 0.9f;

            if(slotAngle > Math.PI){
                slotAngle -= 2d * Math.PI;
            }

            double topHeight = -1.96d;

            double robotHeight = -1000;
            double robotDepth = -1000;
            double robotAngle = 0;

            if(blockEntity.clientRobotArmAnimationDirection) {
                if (blockEntity.clientRobotArmAnimationCounter < 2 * animSpeedMul) {
                    // Rotate arm + move up / down to robot shelf
                    double progress = inverseLerp(0, 2 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);

                    robotHeight = slotHeight;
                    robotDepth = slotDepth;
                    robotAngle = slotAngle;

                    armHeight = lerp(0f, slotShelf, progress);
                    armDepth = 0d;
                    armAngle = lerp(0f, slotAngle, progress);
                }
                else if (blockEntity.clientRobotArmAnimationCounter < 3 * animSpeedMul) {
                    // Reach to robot
                    double progress = inverseLerp(2 * animSpeedMul, 3 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);

                    robotHeight = slotHeight;
                    robotDepth = slotDepth;
                    robotAngle = slotAngle;

                    armHeight = slotShelf;
                    armDepth = lerp(0f, slotDepth, progress);
                    armAngle = robotAngle;
                }
                else if (blockEntity.clientRobotArmAnimationCounter < 4 * animSpeedMul) {
                    // Pull robot out
                    double progress = inverseLerp(3 * animSpeedMul, 4 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);

                    robotHeight = slotHeight;
                    robotDepth = lerp(slotDepth, 0d, progress);
                    robotAngle = slotAngle;

                    armHeight = slotShelf;
                    armDepth = lerp(slotDepth, 0d, progress);
                    armAngle = robotAngle;
                }
                else if (blockEntity.clientRobotArmAnimationCounter < 7 * animSpeedMul) {
                    // Lift robot up
                    double progress = inverseLerp(4 * animSpeedMul, 7 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);

                    robotHeight = lerp(slotHeight, topHeight, progress);
                    robotDepth = 0d;
                    robotAngle = lerp(slotAngle, 0d, progress);

                    armHeight = slotShelf;
                    armDepth = 0d;
                    armAngle = robotAngle;
                }
                else if (blockEntity.clientRobotArmAnimationCounter < 10 * animSpeedMul) {
                    // Return to starting pos
                    double progress = inverseLerp(7 * animSpeedMul, 10 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);

                    robotHeight = topHeight;
                    robotDepth = 0d;
                    robotAngle = 0d;

                    armHeight = lerp(slotShelf, 0d, progress);
                    armDepth = 0d;
                    armAngle = 0d;
                }
                else {
                    robotHeight = topHeight;
                    robotDepth = 0d;
                    robotAngle = 0d;

                    armHeight = 0d;
                    armDepth = 0d;
                    armAngle = 0d;

                    blockEntity.clientRobotArmAnimationCounter = -1;
                }
            }
            else{
                if (blockEntity.clientRobotArmAnimationCounter < 3 * animSpeedMul){
                    // Reach to top
                    double progress = inverseLerp(0, 3 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);

                    robotHeight = topHeight;
                    robotDepth = 0d;
                    robotAngle = 0d;

                    armHeight = lerp(0d, slotShelf, progress);;
                    armDepth = 0d;
                    armAngle = 0d;
                }
                else if (blockEntity.clientRobotArmAnimationCounter < 6 * animSpeedMul) {
                    // Pull down
                    double progress = inverseLerp(3 * animSpeedMul, 6 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);

                    robotHeight = lerp(topHeight, slotHeight, progress);
                    robotDepth = 0d;
                    robotAngle = lerp(0d, slotAngle, progress);

                    armHeight = slotShelf;
                    armDepth = 0d;
                    armAngle = robotAngle;
                }
                else if (blockEntity.clientRobotArmAnimationCounter < 7 * animSpeedMul) {
                    // Push into slot
                    double progress = inverseLerp(6 * animSpeedMul, 7 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);

                    robotHeight = slotHeight;
                    robotDepth = lerp(0d, slotDepth, progress);
                    robotAngle = slotAngle;

                    armHeight = slotShelf;
                    armDepth = robotDepth;
                    armAngle = robotAngle;
                }
                else if (blockEntity.clientRobotArmAnimationCounter < 8 * animSpeedMul) {
                    // Remove arm from slot
                    double progress = inverseLerp(7 * animSpeedMul, 8 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);

                    robotHeight = slotHeight;
                    robotDepth = slotDepth;
                    robotAngle = slotAngle;

                    armHeight = slotShelf;
                    armDepth = lerp(slotDepth, 0d, progress);
                    armAngle = robotAngle;
                }
                else if (blockEntity.clientRobotArmAnimationCounter < 10 * animSpeedMul) {
                    // Return to starting pos
                    double progress = inverseLerp(8 * animSpeedMul, 10 * animSpeedMul, blockEntity.clientRobotArmAnimationCounter);

                    robotHeight = slotHeight;
                    robotDepth = slotDepth;
                    robotAngle = slotAngle;

                    armHeight = lerp(slotShelf, 0d, progress);
                    armDepth = 0d;
                    armAngle = lerp(robotAngle, 0d, progress);
                }
                else {
                    robotHeight = slotHeight;
                    robotDepth = slotDepth;
                    robotAngle = slotAngle;

                    armHeight = 0d;
                    armDepth = 0d;
                    armAngle = 0d;

                    blockEntity.clientRobotArmAnimationCounter = -1;
                }
            }

            if(robotHeight > -1000d){
                matrices.method_22903();
                matrices.method_22904(0f, robotHeight, 0f);
                matrices.method_22907(class_7833.field_40716.rotation((float) robotAngle));
                matrices.method_22904(robotDepth, 0f, 0f);
                robotEntityModel.method_2828(
                    matrices,
                    vertexConsumers.getBuffer(class_1921.method_23576(new class_2960(F_TechRobots.MOD_ID, "textures/entity/robot/robot.png"))),
                    light2,
                    overlay,
                    1, 1, 1, 1
                );
                matrices.method_22909();
            }
        }

        // Render arm
        {
            matrices.method_22903();
            matrices.method_46416(0f, 1.3f, 0f);
            matrices.method_22907(class_7833.field_40716.rotation((float) armAngle + ((float)Math.PI * -0.5f)));
            matrices.method_22905(0.8f, 1.1f, 0.8f);

            float v1min = 0.8f;
            float v1max = -5f;

            float v2min = 0.2f;
            float v2max = -6f;

            float h1min = 0.5f;
            float h1max = -4.5f;

            float h2min = 0.4f;
            float h2max = -4.5f;

            float h3min = 0f;
            float h3max = -4.5f;

            float v1 = (float) lerp(v1min, v1max, armHeight / 2f);
            float v2 = (float) lerp(v2min, v2max, armHeight / 2f);

            float h1 = (float) lerp(h1min, h1max, armDepth * 1.1f);
            float h2 = (float) lerp(h2min, h2max, armDepth * 1.1f);
            float h3 = (float) lerp(h3min, h3max, armDepth * 1.1f);

            commandCenterArmModel.v1.method_41920(new Vector3f(0.5f, v1, 0f));
            commandCenterArmModel.v2.method_41920(new Vector3f(0f, v2, 0f));
            commandCenterArmModel.h1.method_41920(new Vector3f(0f, 0f, h1));
            commandCenterArmModel.h2.method_41920(new Vector3f(0f, 0f, h2));
            commandCenterArmModel.h3.method_41920(new Vector3f(0f, 0f, h3));

            commandCenterArmModel.method_2828(matrices,
                vertexConsumers.getBuffer(class_1921.method_23576(new class_2960(F_TechRobots.MOD_ID, "textures/block/command_center_arm.png"))),
                light2,
                overlay,
                1f,
                1f,
                1f,
                1f
            );

            commandCenterArmModel.h1.method_41920(new Vector3f(0f, 0f, -h1));
            commandCenterArmModel.h2.method_41920(new Vector3f(0f, 0f, -h2));
            commandCenterArmModel.h3.method_41920(new Vector3f(0f, 0f, -h3));
            commandCenterArmModel.v2.method_41920(new Vector3f(0f, -v2, 0f));
            commandCenterArmModel.v1.method_41920(new Vector3f(-0.5f, -v1, 0f));

            matrices.method_22909();
        }
    }

    double lerp(double a, double b, double f)
    {
        return a * (1.0 - f) + (b * f);
    }

    double inverseLerp(double a, double b, double value) {
        if (a != b) {
            return (value - a) / (b - a);
        } else {
            return 0f;
        }
    }
}
