package uk.co.cablepost.ftech_robots.commandCenter;

import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_2960;
import net.minecraft.class_3929;
import net.minecraft.class_5601;
import net.minecraft.class_5616;
import uk.co.cablepost.f_tech.machines.abstract_machine.AbstractMachineInit;
import uk.co.cablepost.ftech_robots.F_TechRobots;
import uk.co.cablepost.ftech_robots.F_TechRobotsClient;

public class CommandCenterInit extends AbstractMachineInit<CommandCenterBlock, CommandCenterBlockEntity, CommandCenterScreenHandler, CommandCenterScreen> {

    public static class_5601 MODEL_COMMAND_CENTER_LAYER;
    public static class_5601 MODEL_COMMAND_CENTER_RACK_LAYER;
    public static class_5601 MODEL_COMMAND_CENTER_ARM_LAYER;


    public CommandCenterInit() {
        super(F_TechRobots.MOD_ID, "command_center");
    }

    @Override
    protected CommandCenterBlock createBlock(FabricBlockSettings blockSettings) {
        return new CommandCenterBlock(blockSettings);
    }

    @Override
    protected FabricBlockEntityTypeBuilder.Factory<CommandCenterBlockEntity> createBlockEntityFactory() {
        return CommandCenterBlockEntity::new;
    }

    @Override
    protected ExtendedScreenHandlerType<CommandCenterScreenHandler> createScreenHandler() {
        return new ExtendedScreenHandlerType<>(CommandCenterScreenHandler::new);
    }

    @Override
    protected void registerScreen(ExtendedScreenHandlerType<CommandCenterScreenHandler> screenHandler) {
        class_3929.method_17542(screenHandler, CommandCenterScreen::new);
    }

    @Override
    public void onInitializeClient(){
        MODEL_COMMAND_CENTER_LAYER = new class_5601(new class_2960(F_TechRobots.MOD_ID, "command_center"), "main");
        MODEL_COMMAND_CENTER_RACK_LAYER = new class_5601(new class_2960(F_TechRobots.MOD_ID, "command_center_rack"), "main");
        MODEL_COMMAND_CENTER_ARM_LAYER = new class_5601(new class_2960(F_TechRobots.MOD_ID, "command_center_arm"), "main");

        super.onInitializeClient();
        class_5616.method_32144(blockEntity, CommandCenterBlockEntityRenderer::new);
        EntityModelLayerRegistry.registerModelLayer(MODEL_COMMAND_CENTER_LAYER, CommandCenterModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(MODEL_COMMAND_CENTER_RACK_LAYER, CommandCenterRackModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(MODEL_COMMAND_CENTER_ARM_LAYER, CommandCenterArmModel::getTexturedModelData);
    }
}
