package uk.co.cablepost.ftech_robots.materialProvider;

import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.f_tech.machines.abstract_machine.AbstractMachineBlockEntity;
import uk.co.cablepost.ftech_robots.F_TechRobots;
import uk.co.cablepost.ftech_robots.StateSaverAndLoader;
import uk.co.cablepost.ftech_robots.models.BlockPosAndItem;

import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class MaterialProviderBlockEntity extends AbstractMachineBlockEntity {
    private int lastItemsHash = 0;

    public MaterialProviderBlockEntity(class_2338 pos, class_2680 state){
        super(
            F_TechRobots.MATERIAL_PROVIDER.getBlockEntity(),
            pos,
            state,
            new int[]{ 0, 1, 2, 3, 4, 5, 6, 7, 8 },
            new int[]{},
            0,
            0,
            0,
            false
        );
    }

    @Override
    public int getMaxProcessProgress() {
        return 0;
    }

    @Override
    public void serverTickExtra() {
        assert field_11863 != null;

        // Update records of this block providing items from this world's state saver
        // by removing records of items this block no longer contains and adding ones it now does

        ArrayList<class_1792> items = new ArrayList<>();
        for (int slot : _inputSlots) {
            if(_inventory.get(slot).method_7960()){
                continue;
            }

            if(!items.contains(_inventory.get(slot).method_7909())){
                items.add(_inventory.get(slot).method_7909());
            }
        }

        int itemsHash = items.hashCode();
        if(lastItemsHash != itemsHash) {
            lastItemsHash = itemsHash;

            StateSaverAndLoader fTechRobotsState = ((class_3218) field_11863).method_17983().method_17924(StateSaverAndLoader::createFromNbt, StateSaverAndLoader::new, F_TechRobots.MOD_ID);

            boolean changesToSave = fTechRobotsState.materialProviders.removeIf((x) ->
                x.blockPos.method_19455(field_11867) == 0 &&
                !items.contains(x.item)
            );

            for (class_1792 item : items) {
                if (fTechRobotsState.materialProviders.stream().noneMatch(blockPosAndItem ->
                    blockPosAndItem.blockPos.method_19455(field_11867) == 0 &&
                    blockPosAndItem.item == item)
                ) {
                    fTechRobotsState.materialProviders.add(new BlockPosAndItem(field_11867, item));
                    changesToSave = true;
                }
            }

            if (changesToSave) {
                fTechRobotsState.method_80();
            }
        }
    }

    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new MaterialProviderScreenHandler(syncId, playerInventory, this, _propertyDelegate);
    }
}
