package uk.co.cablepost.ftech_robots.materialProvider;

import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_3929;
import uk.co.cablepost.f_tech.machines.abstract_machine.AbstractMachineInit;
import uk.co.cablepost.ftech_robots.F_TechRobots;

public class MaterialProviderInit extends AbstractMachineInit<MaterialProviderBlock, MaterialProviderBlockEntity, MaterialProviderScreenHandler, MaterialProviderScreen> {
    public MaterialProviderInit() {
        super(F_TechRobots.MOD_ID, "material_provider");
    }

    @Override
    protected MaterialProviderBlock createBlock(FabricBlockSettings blockSettings) {
        return new MaterialProviderBlock(blockSettings);
    }

    @Override
    protected FabricBlockEntityTypeBuilder.Factory<MaterialProviderBlockEntity> createBlockEntityFactory() {
        return MaterialProviderBlockEntity::new;
    }

    @Override
    protected ExtendedScreenHandlerType<MaterialProviderScreenHandler> createScreenHandler() {
        return new ExtendedScreenHandlerType<>(MaterialProviderScreenHandler::new);
    }

    @Override
    protected void registerScreen(ExtendedScreenHandlerType<MaterialProviderScreenHandler> screenHandler) {
        class_3929.method_17542(screenHandler, MaterialProviderScreen::new);
    }
}
