package uk.co.cablepost.ftech_robots.robot;

import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_7833;
import net.minecraft.class_922;
import uk.co.cablepost.ftech_robots.F_TechRobotsClient;

public class RobotBeamFeatureRenderer<T extends RobotEntity> extends class_3887<T, RobotEntityModel<T>> {
    private final RobotEntityModel<T> model;

    public RobotBeamFeatureRenderer(class_3883<T, RobotEntityModel<T>> context, class_5599 loader) {
        super(context);
        model = new RobotEntityModel<>(loader.method_32072(F_TechRobotsClient.MODEL_ROBOT_LAYER));
    }

    @Override
    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if(entity.getActionProgressTracked() <= 0){
            return;
        }

        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23592(this.method_23194(entity), true));

        class_2338 targetLocation = entity.getBeamTargetLocationTracked();
        class_243 relativeTarget = targetLocation.method_46558().method_1020(entity.method_33571());

        //double relativeTargetHorizontalDis = relativeTarget.distanceTo(new Vec3d(0d, relativeTarget.y, 0d));

        double hypotenuse = relativeTarget.method_1033();
        float pitch = (float)Math.asin(relativeTarget.field_1351 / hypotenuse);

        //float pitch = (float)Math.acos(Math.max(-1d, Math.min(1d, relativeTarget.y / relativeTargetHorizontalDis)));
        float yaw = (float)Math.atan2(relativeTarget.field_1350, relativeTarget.field_1352);

        matrices.method_22903();
        matrices.method_46416(0f, 1.24f, 0f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-entity.field_6283));

        matrices.method_22907(class_7833.field_40716.rotation(1.5707964f + yaw));
        matrices.method_22907(class_7833.field_40714.rotation(-1.5707964f + pitch));

        double beamLength = relativeTarget.method_1022(new class_243(0d, 0d, 0d));
        matrices.method_22904(0f, -beamLength / 2d, 0f);
        matrices.method_22905(
                ((float)Math.sin(entity.animCounter / 20d) * 0.1f) + 0.1f,
                (float)beamLength * 3.9f,
                ((float)Math.cos(entity.animCounter / 20d) * 0.1f) + 0.1f
        );

        model.beam.method_22699(
            matrices,
            vertexConsumer,
            light,
            class_922.method_23622(entity, 0.0f),
            ((float)Math.sin(entity.animCounter / 10d + 100f) * 0.5f) + 0.5f,
            ((float)Math.sin(entity.animCounter / 20d + 200f) * 0.5f) + 0.5f,
            ((float)Math.sin(entity.animCounter / 30d + 300f) * 0.5f) + 0.5f,
            0.5f
        );
        matrices.method_22909();
    }
}
