package uk.co.cablepost.ftech_robots.robot;

import f_baritone.api.BaritoneAPI;
import f_baritone.api.IBaritone;
import f_baritone.api.movementSettionsFunc.MoveTowardsFuncParams;
import f_baritone.api.pathing.goals.GoalBlock;
import f_baritone.api.pathing.goals.GoalNear;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.block.*;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2544;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_6067;
import net.minecraft.entity.*;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ftech_robots.F_TechRobots;
import uk.co.cablepost.ftech_robots.StateSaverAndLoader;
import uk.co.cablepost.ftech_robots.buildInstructions.BuildInstructions;
import uk.co.cablepost.ftech_robots.commandCenter.CommandCenterBlockEntity;
import uk.co.cablepost.ftech_robots.models.BlockPosAndState;
import uk.co.cablepost.ftech_robots.models.BlockPosAndItem;
import uk.co.cablepost.ftech_robots.materialProvider.MaterialProviderBlockEntity;
import uk.co.cablepost.ftech_robots.models.UuidAndChunkPos;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class RobotEntity extends class_1309 implements class_6067 {

    private class_1923 lastChunkPos = null;
    private int hoverSoundCounter = 9999;
    private final class_1277 inventory = new class_1277(1);
    private class_2338 homeLocation = null;
    private static final class_2382 HOME_LOCATION_CONTROLLER_OFFSET = new class_2382(0, -3, 0);
    private List<BlockPosAndState> objectives = new ArrayList<>();
    private int actionProgress = 0;
    private IBaritone baritone = null;
    public int animCounter = 0;
    private int calculateBaritoneGoalCounter = 0;

    private static final class_2940<Integer> ACTION_PROGRESS = class_2945.method_12791(RobotEntity.class, class_2943.field_13327);
    private static final class_2940<class_2338> BEAM_TARGET_LOCATION = class_2945.method_12791(RobotEntity.class, class_2943.field_13324);

    public RobotEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public boolean method_5733() {
        return super.method_5733();
    }

    @Override
    protected float method_6107() {
        return 0.1f;
    }

    @Override
    public float method_6017() {
        return ((float) method_18798().method_1027()) + 0.8f;
    }

    @Override
    public Iterable<class_1799> method_5661() {
        return class_2371.method_10213(0, class_1799.field_8037);
    }

    @Override
    public class_1799 method_6118(class_1304 slot) {
        if(
            slot == class_1304.field_6166 &&
            FabricLoader.getInstance().isModLoaded("create")
        ){
            StackTraceElement[] cause = Thread.currentThread().getStackTrace();
            String fileName = cause[2].getFileName();
            if(fileName == null){
                fileName = "";
            }
            if(fileName.startsWith("DivingBootsItem")) {
                return new class_1799(com.simibubi.create.AllItems.COPPER_DIVING_BOOTS);
            }
        }

        return inventory.method_5438(0);
    }

    @Override
    public void method_5673(class_1304 slot, class_1799 stack) {
        if(slot == class_1304.field_6173) {
            inventory.method_5447(0, stack);
        }
    }

    @Override
    public class_1306 method_6068() {
        return class_1306.field_6182;
    }

    @Override
    public void method_5773(){
        this.method_5875(true);
        super.method_5773();

        if(method_37908() instanceof class_3218 serverWorld){
            if(field_6012 < 40 && homeLocation != null){
                method_20620(homeLocation.method_46558().field_1352, homeLocation.method_46558().field_1351, homeLocation.method_46558().field_1350);

                if(field_6012 == 27 || field_6012 == 35){
                    for(int j = 0; j < 10; j++) {
                        serverWorld.method_14199(
                            class_2398.field_11204,
                            homeLocation.method_10263() - 0.25f + serverWorld.field_9229.method_43058() * 1.5f,
                            homeLocation.method_10264() + serverWorld.field_9229.method_43058() * 1.6f,
                            homeLocation.method_10260() - 0.25f + serverWorld.field_9229.method_43058() * 1.5f,
                            5,
                            0, 0, 0, 0
                        );
                    }
                }
            }

            // Do objective
            {
                if(baritone == null){
                    baritone = BaritoneAPI.getProvider().getBaritone(this);
                    baritone.settings().allowBreak.set(false);
                    baritone.settings().allowPlace.set(false);
                    baritone.settings().allowSprint.set(true);
                    baritone.settings().assumeStep.set(true);
                    baritone.settings().allowParkour.set(false);
                    baritone.settings().allowInventory.set(false);
                    baritone.settings().allowDownward.set(true);
                    baritone.settings().allowSwimming.set(true);
                    //baritone.settings().assumeWalkOnWater.set(true);
                    baritone.settings().okIfWater.set(true);
                    //baritone.settings().assumeWalkOnLava.set(true);
                    baritone.settings().maxFallHeightNoWater.set(999);

                    baritone.settings().primaryTimeoutMS.set(2000L);

                    baritone.settings().moveTowardsFunc.set((MoveTowardsFuncParams params) -> {
                        class_243 current = params.entity().method_19538();
                        class_243 target = params.pos().method_46558().method_1031(0f, -0.1f, 0f);

                        class_2248 block = method_37908().method_8320(params.pos()).method_26204();
                        class_2248 blockBelow = method_37908().method_8320(params.pos().method_10069(0, -1, 0)).method_26204();

                        if(
                            (block instanceof class_2354) || (block instanceof class_2544) || (block instanceof class_2349) ||
                            (blockBelow instanceof class_2354) || (blockBelow instanceof class_2544) || (blockBelow instanceof class_2349)
                        ){
                            params.entity().method_18799(target.method_1019(current.method_1021(-1f)).method_1021(0.2f).method_1031(0, 1, 0));
                        }else {
                            params.entity().method_18799(target.method_1019(current.method_1021(-1f)).method_1021(0.2f));
                        }

                        params.entity().method_5702(class_2183.class_2184.field_9851, target);

                        return true;
                    });
                }

                if(baritone.getCustomGoalProcess().getGoal() == null) {
                    calculateBaritoneGoalCounter++;
                    if(calculateBaritoneGoalCounter > 20 && F_TechRobots.GLOBAL_ROBOT_PATH_CALC_COOLDOWN == 0) {
                        F_TechRobots.GLOBAL_ROBOT_PATH_CALC_COOLDOWN = 2;
                        calculateBaritoneGoalCounter = 0;
                        if (!objectives.isEmpty() && objectives.get(0).blockPos != null) {
                            BlockPosAndState objective = objectives.get(0);
                            if (objective.blockState.method_26215() || !method_35199().method_5438(0).method_7960()) {
                                baritone.getCustomGoalProcess().setGoalAndPath(new GoalNear(objective.blockPos, 5));
                            } else {
                                class_2338 materialProviderPos = findMaterialProviderForItem(objective.blockState.method_26204().method_8389());

                                if (materialProviderPos != null) {
                                    baritone.getCustomGoalProcess().setGoalAndPath(new GoalBlock(new class_2338(materialProviderPos.method_10084())));
                                }
                                else {
                                    calculateBaritoneGoalCounter = -100;
                                    F_TechRobots.GLOBAL_ROBOT_PATH_CALC_COOLDOWN = 0;
                                }
                            }
                        } else if (homeLocation != null) {
                            baritone.getCustomGoalProcess().setGoalAndPath(new GoalBlock(homeLocation));
                        }
                    }
                }

                if(
                    !objectives.isEmpty() &&
                    !objectives.get(0).blockState.method_26215() &&
                    method_35199().method_5438(0).method_7947() < objectives.size() &&
                    method_37908().method_8321(method_24515().method_10074()) instanceof MaterialProviderBlockEntity materialProviderBlockEntity
                ){
                    BlockPosAndState objective = objectives.get(0);
                    for(int slot : materialProviderBlockEntity._inputSlots) {
                        class_1799 itemStack = materialProviderBlockEntity._inventory.get(slot);
                        if(!itemStack.method_7960() && itemStack.method_7909().equals(objective.blockState.method_26204().method_8389())) {
                            if(method_35199().method_5438(0).method_7909() != itemStack.method_7909()){
                                method_35199().method_5447(0, new class_1799(itemStack.method_7909(), 1));
                            }
                            else{
                                method_35199().method_5447(0, new class_1799(itemStack.method_7909(), method_35199().method_5438(0).method_7947() + 1));
                            }
                            materialProviderBlockEntity.method_5434(slot, 1);
                            break;
                        }
                    }
                }

                if(
                    !objectives.isEmpty() &&
                    objectives.get(0).blockPos != null &&
                    objectives.get(0).blockPos.method_19455(method_24515()) < 10
                ){
                    BlockPosAndState objective = objectives.get(0);
                    if(method_35199().method_5438(0).method_7960() && objective.blockState.method_26215()){
                        // Break block - Not storing block to inventory
                        actionProgress += 10;
                        if(actionProgress >= 100) {
                            // TODO - prevent breaking unbreakable block
                            for(int i = 1; i <= 50; i++){
                                if(!(serverWorld.method_8320(objective.blockPos.method_10086(i)).method_26204() instanceof class_2346)){
                                    break;
                                }
                                serverWorld.method_8652(objective.blockPos.method_10086(i), class_2246.field_10124.method_9564(), class_2248.field_31036);
                            }
                            serverWorld.method_8652(objective.blockPos, class_2246.field_10124.method_9564(), class_2248.field_31036);
                            this.method_5783(class_3417.field_14890, this.method_6107(), this.method_6017());
                        }
                    }
                    else if(method_35199().method_5438(0).method_7909() instanceof class_1747 blockItem && objective.blockState.method_26204().method_8389().equals(method_35199().method_5438(0).method_7909())){
                        // Place block
                        actionProgress += 10;
                        if(actionProgress >= 100) {
//                            PlayerManager playerManager = serverWorld.getServer().getPlayerManager();
//                            playerManager.broadcast(
//                                Text.literal("Placing block: ")
//                                    .append(Text.translatable(blockItem.getBlock().getTranslationKey()))
//                                    .append(Text.literal(" replacing "))
//                                    .append(Text.translatable(serverWorld.getBlockState(objectiveLocation).getBlock().getTranslationKey()))
//                                ,
//                                false
//                            );

                            if(
                                (
                                    blockItem.method_7711() instanceof class_2346 &&
                                    !serverWorld.method_8320(objective.blockPos.method_10074()).method_45474()
                                ) ||
                                (
                                    !(blockItem.method_7711() instanceof class_2346) &&
                                    blockItem.method_7711().method_9558(objective.blockState, serverWorld, objective.blockPos)
                                )
                            ) {
                                serverWorld.method_8652(objective.blockPos, objective.blockState, class_2248.field_31036);
                                objective.blockState.method_26204().method_9567(serverWorld, objective.blockPos, objective.blockState, null, method_35199().method_5438(0));
                                method_35199().method_5447(0, new class_1799(method_35199().method_5438(0).method_7909(), method_35199().method_5438(0).method_7947() - 1));
                                this.method_5783(class_3417.field_14890, this.method_6107(), this.method_6017());
                            }
                            else{
                                actionProgress = 0;
                            }
                        }
                    }
                    // TODO - also allow using non BlockItems like water buckets etc
                    else{
                        actionProgress = 0;
                    }

                    field_6011.method_12778(ACTION_PROGRESS, actionProgress);
                    field_6011.method_12778(BEAM_TARGET_LOCATION, objective.blockPos);

                    if(actionProgress >= 100) {
                        objectives.remove(0);
                        actionProgress = 0;
                        method_5762(0, 0.1f, 0);
                    }
                }
                else{
                    actionProgress = 0;
                    field_6011.method_12778(ACTION_PROGRESS, 0);
                    field_6011.method_12778(BEAM_TARGET_LOCATION, new class_2338(0, 0, 0));

                    if(objectives.isEmpty()){
                        if(homeLocation == null){
                            this.method_5768();
                        }
                        else{
                            class_2586 be = serverWorld.method_8321(homeLocation.method_10081(HOME_LOCATION_CONTROLLER_OFFSET));
                            if(be instanceof CommandCenterBlockEntity commandCenterBlockEntity){
                                if(!commandCenterBlockEntity.containsRobot(method_5667())){
                                    this.method_5768();
                                }
                                else{
                                    if(commandCenterBlockEntity.haveEnoughEnergy()){
                                        tryGetObjectives(commandCenterBlockEntity);
                                    }

                                    if(!objectives.isEmpty()){
                                        baritone.getCustomGoalProcess().setGoal(null);
                                    }
                                }
                            }
                            else{
                                this.method_5768();
                            }
                        }
                    }
                }
            }

            // Chunk loading + World State Saver
            {
                class_1923 chunkPos = new class_1923(method_24515());
                if (lastChunkPos == null || lastChunkPos.field_9181 != chunkPos.field_9181 || lastChunkPos.field_9180 != chunkPos.field_9180) {
                    // Update chunk loading ticket
                    {
                        if (lastChunkPos != null) {
                            serverWorld.method_14178().method_17300(F_TechRobots.ROBOT_CHUNK_TICKET_TYPE, lastChunkPos, 3, field_6021);
                        }
                        serverWorld.method_14178().method_17297(F_TechRobots.ROBOT_CHUNK_TICKET_TYPE, chunkPos, 3, field_6021);
                        lastChunkPos = new class_1923(chunkPos.field_9181, chunkPos.field_9180);
                    }

                    // Update world state saver
                    {
                        StateSaverAndLoader fTechRobotsState = serverWorld.method_17983().method_17924(StateSaverAndLoader::createFromNbt, StateSaverAndLoader::new, F_TechRobots.MOD_ID);
                        if (fTechRobotsState.robotChunkPoses.stream().noneMatch(x -> x.uuid.equals(field_6021))) {
                            fTechRobotsState.robotChunkPoses.add(new UuidAndChunkPos(field_6021, chunkPos));
                        } else {
                            fTechRobotsState.robotChunkPoses.stream().filter(x -> x.uuid.equals(field_6021)).forEach(x -> x.chunkPos = chunkPos);
                        }
                        fTechRobotsState.method_80();
                    }
                }
            }

            // Hover SFX and Status effects
            {
                hoverSoundCounter++;
                if (hoverSoundCounter >= 30) {
                    this.method_5783(F_TechRobots.ROBOT_HOVER_SOUND_EVENT, this.method_6107(), this.method_6017());
                    this.method_6092(new class_1293(class_1294.field_5924, 31, 0, true, false));
                    this.method_6092(new class_1293(class_1294.field_5923, 31, 0, true, false));
                    this.method_6092(new class_1293(class_1294.field_5918, 31, 0, true, false));
                    hoverSoundCounter = 0;
                }
            }

            // Go up when in block
            {
                if (this.method_5757()) {
                    this.method_5762(0f, 1.1f, 0f);
                }
            }
        }
    }

    public void tryGetObjectives(CommandCenterBlockEntity commandCenterBlockEntity){
        if(!objectives.isEmpty()){
            throw new RuntimeException("Expected current objectives list to be empty but was not");
        }

        for(int i = 1; i <= 10; i++) {
            class_1792 ofItem = null;
            if(!objectives.isEmpty()){
                ofItem = objectives.get(0).blockState.method_26204().method_8389();
            }

            BlockPosAndState nextObjective = commandCenterBlockEntity.getNextBlockToChange(ofItem);
            if (nextObjective != null) {
                BlockPosAndState objective = new BlockPosAndState(nextObjective.blockPos, nextObjective.blockState);
                commandCenterBlockEntity.removeBlockToChange(objective.blockPos, objective.blockState);
                objectives.add(objective);
            }
            else{
                break;
            }
        }
    }

    // Used by command center block to suck up robots who have done their objective
    public boolean hasObjective(){
        return !objectives.isEmpty();
    }

    public int getActionProgressTracked(){
        return field_6011.method_12789(ACTION_PROGRESS);
    }

    public class_2338 getBeamTargetLocationTracked(){
        return field_6011.method_12789(BEAM_TARGET_LOCATION);
    }

    public void setHomeLocation(class_2338 pos){
        homeLocation = pos;
    }

//    public void setObjective(BlockPosAndState objective){
//        this.objective = new BlockPosAndState(objective.blockPos, objective.blockState);
//        calculateBaritoneGoalCounter = 100;
//    }

    @Override
    public void method_5650(class_5529 reason){
        if(method_37908() instanceof class_3218 serverWorld && lastChunkPos != null) {
            // Remove chunk ticket
            serverWorld.method_14178().method_17300(F_TechRobots.ROBOT_CHUNK_TICKET_TYPE, lastChunkPos, 3, field_6021);

            // Update world state saver
            {
                StateSaverAndLoader fTechRobotsState = serverWorld.method_17983().method_17924(StateSaverAndLoader::createFromNbt, StateSaverAndLoader::new, F_TechRobots.MOD_ID);
                fTechRobotsState.robotChunkPoses.removeIf(x -> x.uuid.equals(field_6021));
                fTechRobotsState.method_80();
            }
        }
        super.method_5650(reason);
    }

    @Override
    public class_1277 method_35199() {
        return this.inventory;
    }

    @Override
    protected void method_16078() {
        this.inventory.method_24514().forEach(this::method_5775);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);

        nbt.method_10569("Age", field_6012);

        this.method_46399(nbt);

        if(homeLocation != null) {
            nbt.method_10569("HomeX", homeLocation.method_10263());
            nbt.method_10569("HomeY", homeLocation.method_10264());
            nbt.method_10569("HomeZ", homeLocation.method_10260());
        }

        Optional<class_2520> objectiveNbt = BuildInstructions.BLOCK_POS_AND_STATE_CODEC.listOf().encodeStart(class_2509.field_11560, objectives).result();
        if(objectiveNbt.isEmpty()){
            throw new RuntimeException("Failed to write objectives to NBT");
        }
        nbt.method_10566("Objectives", objectiveNbt.get());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);

        this.method_46400(nbt);

        field_6012 = nbt.method_10550("Age");

        if(nbt.method_10545("HomeX")) {
            this.homeLocation = new class_2338(
                nbt.method_10550("HomeX"),
                nbt.method_10550("HomeY"),
                nbt.method_10550("HomeZ")
            );
        }

        if(nbt.method_10545("Objective")) {
            Optional<List<BlockPosAndState>> objectivesNbt = BuildInstructions.BLOCK_POS_AND_STATE_CODEC.listOf().parse(class_2509.field_11560, nbt.method_10580("Objectives")).result();
            if(objectivesNbt.isEmpty()){
                throw new RuntimeException("Failed to read objectives from NBT");
            }
            this.objectives = objectivesNbt.get();
            calculateBaritoneGoalCounter = 100;
        }
        else{
            this.objectives = new ArrayList<>();
        }
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ACTION_PROGRESS, 0);
        this.field_6011.method_12784(BEAM_TARGET_LOCATION, new class_2338(0, 0, 0));
    }

    @Override
    public boolean method_5822(){
        return false;
    }

    @Override
    protected void method_6070() {
        List<class_1297> list = this.method_37908().method_8333(this, this.method_5829(), class_1301.method_5911(this));
        for (class_1297 entity : list) {
            if (!(this.method_5858(entity) <= 0.2)) continue;
            entity.method_5697(this);
        }
    }

    @Override
    protected int method_23329(float fallDistance, float damageMultiplier) {
        return 0;
    }

    @Override
    protected void method_23328() {
    }

    @Override
    public boolean method_5675() {
        return false;
    }

    @Override
    public boolean method_6094() {
        return true;
    }

    private @Nullable class_2338 findMaterialProviderForItem(class_1792 item){
        if(method_37908().method_8608()){
            return null;
        }

        StateSaverAndLoader fTechRobotsState = ((class_3218)method_37908()).method_17983().method_17924(StateSaverAndLoader::createFromNbt, StateSaverAndLoader::new, F_TechRobots.MOD_ID);

        Optional<BlockPosAndItem> res = fTechRobotsState.materialProviders.stream().filter(blockPosAndItem -> item.equals(blockPosAndItem.item)).sorted((a, b) -> Integer.compare(a.blockPos.method_19455(method_24515()), b.blockPos.method_19455(method_24515()))).findAny();

        return res.map(blockPosAndItem -> blockPosAndItem.blockPos).orElse(null);
    }

    @Override
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if(player.method_37908().method_8608() || hand == class_1268.field_5810){
            return class_1269.field_5811;
        }

        class_2586 be = player.method_37908().method_8321(homeLocation.method_10081(HOME_LOCATION_CONTROLLER_OFFSET));
        if(be instanceof CommandCenterBlockEntity commandCenterBlockEntity){
            commandCenterBlockEntity.sayPowerStatus(player);
        }

        player.method_43496(getStatusText());
        return class_1269.field_5812;
    }

    public class_2561 getStatusText(){
        boolean pathing = baritone != null && baritone.getCustomGoalProcess().getGoal() != null;
        boolean inventoryEmpty = inventory.method_5438(0).method_7960();
        boolean objectiveRequiresItem = !objectives.isEmpty() && !objectives.get(0).blockState.method_26215();

        class_5250 statusText = class_2561.method_43470("Status: ");
        if(pathing){
            if(!hasObjective()){
                statusText.method_10852(class_2561.method_43470("Going to build controller").method_27692(class_124.field_1060));
            }
            else if(inventoryEmpty && objectiveRequiresItem){
                statusText.method_10852(class_2561.method_43470("Going to material provider location").method_27692(class_124.field_1060));
            }
            else {
                statusText.method_10852(class_2561.method_43470("Going to build location").method_27692(class_124.field_1060));
            }
        }
        else if(inventoryEmpty && objectiveRequiresItem){
            if(findMaterialProviderForItem(objectives.get(0).blockState.method_26204().method_8389()) == null) {
                statusText.method_10852(class_2561.method_43470("Waiting for a material provider to have required building material").method_27692(class_124.field_1061));
            }
            else{
                statusText.method_10852(class_2561.method_43470("Calculating path to material provider location").method_27692(class_124.field_1054));
            }
        }
        else{
            if(hasObjective()) {
                statusText.method_10852(class_2561.method_43470("Calculating path to build site").method_27692(class_124.field_1054));
            }
            else{
                statusText.method_10852(class_2561.method_43470("Going to build controller").method_27692(class_124.field_1060));
            }
        }

        class_5250 objectiveText = class_2561.method_43470("Objective: ");
        if(hasObjective()){
            objectiveText
                .method_10852(class_2561.method_43471(objectives.get(0).blockState.method_26204().method_9539()).method_27692(class_124.field_1078))
                .method_10852(class_2561.method_43470(" at "))
                .method_10852(class_2561.method_43470(objectives.get(0).blockPos.method_23854()).method_27692(class_124.field_1080))
            ;
        }
        else{
            objectiveText.method_10852(class_2561.method_43470("No objective").method_27692(class_124.field_1054));
        }

        return class_2561.method_43470("[").method_10852(objectiveText).method_10852(class_2561.method_43470("] [")).method_10852(statusText).method_10852(class_2561.method_43470("]"));
    }
}
