package uk.co.cablepost.ftech_robots.robot;

import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_759;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import uk.co.cablepost.ftech_robots.F_TechRobotsClient;

public class RobotHeldItemFeatureRenderer<T extends RobotEntity> extends class_3887<T, RobotEntityModel<T>> {
    //private final RobotEntityModel<T> model;
    private final class_759 heldItemRenderer;

    public RobotHeldItemFeatureRenderer(class_3883<T, RobotEntityModel<T>> context, class_5599 loader, class_759 heldItemRenderer) {
        super(context);
        //model = new RobotEntityModel<>(loader.getModelPart(F_TechRobotsClient.MODEL_ROBOT_LAYER));
        this.heldItemRenderer = heldItemRenderer;
    }

    @Override
    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        class_1799 itemStack = entity.method_6047();
        if(itemStack.method_7960()){
            return;
        }

        matrices.method_22903();

        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));

        matrices.method_22905(0.15f, 0.15f, 0.15f);
        matrices.method_46416(0f, -6.3f, 0f);

        int actionProgress = entity.getActionProgressTracked();
        if(actionProgress > 0)
        {
            if(itemStack.method_7947() > 1){
                // As multiple, show one on top still as well as in beam
                this.heldItemRenderer.method_3233(entity, itemStack, class_811.field_4315, false, matrices, vertexConsumers, light);
            }

            //noinspection DuplicatedCode
            class_2338 targetLocation = entity.getBeamTargetLocationTracked();
            class_243 relativeTarget = targetLocation.method_46558().method_1020(entity.method_33571());//.rotateY(entity.getYaw() * ((float) Math.PI / 180f));

            double hypotenuse = relativeTarget.method_1033();
            float pitch = (float)Math.asin(relativeTarget.field_1351 / hypotenuse);
            float yaw = (float)Math.atan2(relativeTarget.field_1350, relativeTarget.field_1352);

            float bodyYaw = entity.field_6241 * ((float) Math.PI / 180f);

            matrices.method_22907(class_7833.field_40716.rotation(-yaw + bodyYaw));
            matrices.method_22907(class_7833.field_40718.rotation(pitch));

            //double beamLength = relativeTarget.distanceTo(new Vec3d(0d, 0d, 0d));

//            matrices.translate(
//                relativeTarget.x * (actionProgress / 100f),
//                relativeTarget.y * (actionProgress / 100f),
//                relativeTarget.z * (actionProgress / 100f)
//            );

            matrices.method_22904(
                (actionProgress / 100f) * hypotenuse * 4.5f,
                -2f,
                0
            );

            matrices.method_22907(class_7833.field_40714.rotationDegrees(entity.animCounter * 5f));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(entity.animCounter * 5f));
            matrices.method_22907(class_7833.field_40718.rotationDegrees(entity.animCounter * 5f));

            matrices.method_22905(2f, 2f, 2f);
        }

        this.heldItemRenderer.method_3233(entity, itemStack, class_811.field_4315, false, matrices, vertexConsumers, light);

        matrices.method_22909();
    }
}
