/*
 * Decompiled with CFR 0.152.
 */
package dev.mattware.slimebuckets;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.GameInstance;
import dev.mattware.slimebuckets.config.SlimeBucketsConfig;
import dev.mattware.slimebuckets.item.SlimeBucketsItemComponents;
import dev.mattware.slimebuckets.item.SlimeBucketsItems;
import dev.mattware.slimebuckets.network.SyncServerConfig;
import dev.mattware.slimebuckets.particle.SlimeBucketsParticles;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlimeBuckets {
    public static final String MOD_ID = "slimebuckets";
    private static SlimeBucketsConfig CONFIG = new SlimeBucketsConfig();
    public static SlimeBucketsConfig.SlimeBucketsServerConfig SERVER_CONFIG;
    @OnlyIn(value=Dist.CLIENT)
    public static SlimeBucketsConfig.SlimeBucketsClientConfig CLIENT_CONFIG;
    public static final Logger LOGGER;
    public static final DeferredRegister<CreativeModeTab> TABS;
    public static final RegistrySupplier<CreativeModeTab> SLIME_BUCKETS_TAB;

    public static void init() {
        LOGGER.info("Initialising Slime Buckets ^-^");
        AutoConfig.register(SlimeBucketsConfig.class, Toml4jConfigSerializer::new);
        ConfigHolder configHolder = AutoConfig.getConfigHolder(SlimeBucketsConfig.class);
        CONFIG = (SlimeBucketsConfig)configHolder.getConfig();
        if (Platform.getEnvironment() == Env.CLIENT) {
            CLIENT_CONFIG = SlimeBuckets.CONFIG.clientConfig;
        }
        SERVER_CONFIG = SlimeBuckets.CONFIG.serverConfig;
        PlayerEvent.PLAYER_JOIN.register(SlimeBuckets::sendConfigToPlayer);
        configHolder.registerLoadListener((manager, newData) -> {
            SlimeBuckets.resendConfigIfServer();
            return InteractionResult.PASS;
        });
        configHolder.registerSaveListener((manager, newData) -> {
            SlimeBuckets.resendConfigIfServer();
            return InteractionResult.PASS;
        });
        SlimeBucketsParticles.register();
        TABS.register();
        SlimeBucketsItemComponents.register();
        SlimeBucketsItems.register();
        if (Platform.getEnvironment() == Env.SERVER) {
            NetworkManager.registerS2CPayloadType(SyncServerConfig.TYPE, SyncServerConfig.PACKET_CODEC);
        }
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> Client::initClient);
    }

    private static void resendConfigIfServer() {
        LOGGER.info("Resending SlimeBuckets config to all players");
        MinecraftServer server = GameInstance.getServer();
        if (server != null) {
            NetworkManager.sendToPlayers((Iterable)server.getPlayerList().getPlayers(), (CustomPacketPayload)SlimeBuckets.CONFIG.serverConfig.writeToPacket());
        }
    }

    private static void sendConfigToPlayer(ServerPlayer player) {
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)SlimeBuckets.CONFIG.serverConfig.writeToPacket());
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
        TABS = DeferredRegister.create((String)MOD_ID, (ResourceKey)Registries.CREATIVE_MODE_TAB);
        SLIME_BUCKETS_TAB = TABS.register("slime_buckets_tab", () -> CreativeTabRegistry.create((Component)Component.translatable((String)"itemGroup.slimebuckets.slime_buckets_tab"), () -> new ItemStack((ItemLike)SlimeBucketsItems.SLIME_BUCKET.get())));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        public static void initClient() {
            ClientLifecycleEvent.CLIENT_SETUP.register(client -> SlimeBucketsItems.registerProperties());
            ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(player -> {
                if (Minecraft.getInstance().player == player) {
                    SERVER_CONFIG = SlimeBuckets.CONFIG.serverConfig;
                }
            });
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, SyncServerConfig.TYPE, SyncServerConfig.PACKET_CODEC, (value, context) -> {
                LOGGER.info("The server has sent their config over");
                SlimeBucketsConfig newConfig = new SlimeBucketsConfig();
                newConfig.serverConfig.readFromPacket((SyncServerConfig)value);
                SERVER_CONFIG = newConfig.serverConfig;
            });
        }
    }
}

