/*
 * Decompiled with CFR 0.152.
 */
package dev.mattware.slimebuckets.config;

import dev.mattware.slimebuckets.network.SyncServerConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;

@Config(name="slimebuckets")
public class SlimeBucketsConfig
extends PartitioningSerializer.GlobalData {
    @ConfigEntry.Category(value="server")
    @ConfigEntry.Gui.TransitiveObject
    public SlimeBucketsServerConfig serverConfig = new SlimeBucketsServerConfig();
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.TransitiveObject
    public SlimeBucketsClientConfig clientConfig = new SlimeBucketsClientConfig();

    @Config(name="slimebuckets-server")
    public static class SlimeBucketsServerConfig
    implements ConfigData {
        public boolean slimeBucketingEnabled = true;
        public boolean magmaCubeBucketingEnabled = true;
        public boolean enableSlimeChunkDetection = true;
        public boolean magmaCubeBucketHurts = true;
        public int maxBucketableSlimeSize = 1;

        public SyncServerConfig writeToPacket() {
            return new SyncServerConfig(this.slimeBucketingEnabled, this.magmaCubeBucketingEnabled, this.enableSlimeChunkDetection, this.magmaCubeBucketHurts, this.maxBucketableSlimeSize);
        }

        public void readFromPacket(SyncServerConfig packet) {
            this.slimeBucketingEnabled = packet.slimeBucketingEnabled();
            this.magmaCubeBucketingEnabled = packet.magmaCubeBucketingEnabled();
            this.enableSlimeChunkDetection = packet.enableSlimeChunkDetection();
            this.magmaCubeBucketHurts = packet.magmaCubeBucketHurts();
            this.maxBucketableSlimeSize = packet.maxBucketableSlime();
        }
    }

    @Config(name="slimebuckets-client")
    public static class SlimeBucketsClientConfig
    implements ConfigData {
        public boolean enableTrails = true;
    }
}

