/*
 * Decompiled with CFR 0.152.
 */
package dev.mattware.slimebuckets.item;

import dev.mattware.slimebuckets.SlimeBuckets;
import dev.mattware.slimebuckets.item.SlimeBucketItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class MagmaCubeBucketItem
extends SlimeBucketItem {
    public MagmaCubeBucketItem() {
        this.slimeType = EntityType.MAGMA_CUBE;
        this.heldParticle = ParticleTypes.FALLING_LAVA;
        this.enableSlimeChunkExcitement = false;
        this.descriptionComponent = Component.translatable((String)"itemdesc.slimebuckets.magma_cube_bucket").withStyle(ChatFormatting.RED);
    }

    @Override
    public void onHeld(LivingEntity entity) {
        super.onHeld(entity);
        if (!SlimeBuckets.SERVER_CONFIG.magmaCubeBucketHurts) {
            return;
        }
        if (entity.isInWaterOrRain()) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getAbilities().invulnerable) {
                return;
            }
        }
        if (entity.getRemainingFireTicks() <= 1) {
            entity.setRemainingFireTicks(21);
        }
    }
}

