/*
 * Decompiled with CFR 0.152.
 */
package dev.mattware.slimebuckets.item;

import dev.mattware.slimebuckets.SlimeBuckets;
import dev.mattware.slimebuckets.item.SlimeBucketsItemComponents;
import dev.mattware.slimebuckets.particle.SlimeBucketsParticles;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class SlimeBucketItem
extends Item {
    protected EntityType slimeType = EntityType.SLIME;
    protected Component descriptionComponent = Component.translatable((String)"itemdesc.slimebuckets.slime_bucket").withStyle(ChatFormatting.AQUA);
    protected ParticleOptions heldParticle;
    protected boolean enableSlimeChunkExcitement = true;

    public SlimeBucketItem() {
        super(new Item.Properties().arch$tab(SlimeBuckets.SLIME_BUCKETS_TAB).stacksTo(1).craftRemainder(Items.BUCKET));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        BlockHitResult blockHitResult = SlimeBucketItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockHitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (blockHitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        BlockPos blockPos = blockHitResult.getBlockPos();
        Direction direction = blockHitResult.getDirection();
        BlockPos offsetBlockPos = blockPos.relative(direction);
        if (level.mayInteract(player, blockPos) && player.mayUseItemAt(offsetBlockPos, direction, itemStack)) {
            ServerLevel serverLevel;
            Slime slime;
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            level.playSound(player, offsetBlockPos, SoundEvents.BUCKET_EMPTY_FISH, SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (level instanceof ServerLevel && (slime = (Slime)this.slimeType.create((Level)(serverLevel = (ServerLevel)level))) != null) {
                CustomData entity = (CustomData)itemStack.get(DataComponents.BUCKET_ENTITY_DATA);
                if (entity != null) {
                    entity.loadInto((Entity)slime);
                } else {
                    slime.setSize(1, true);
                }
                slime.moveTo(offsetBlockPos, 0.0f, 0.0f);
                serverLevel.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, slime.position());
                serverLevel.addFreshEntity((Entity)slime);
                player.swing(interactionHand);
            }
            return InteractionResultHolder.sidedSuccess((Object)(!player.getAbilities().instabuild ? new ItemStack((ItemLike)Items.BUCKET) : itemStack), (boolean)level.isClientSide);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        CompoundTag cmp;
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
        CustomData entity = (CustomData)itemStack.get(DataComponents.BUCKET_ENTITY_DATA);
        if (entity != null && (cmp = entity.copyTag()).contains("CustomName")) {
            list.set(0, (Component)Component.translatable((String)"item.slimebuckets.slime_bucket_named", (Object[])new Object[]{Component.Serializer.fromJson((String)cmp.getString("CustomName"), (HolderLookup.Provider)tooltipContext.registries())}));
        }
        list.add(this.descriptionComponent);
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int i, boolean bl) {
        if (entity instanceof LivingEntity) {
            LivingEntity liver = (LivingEntity)entity;
            if (liver.getMainHandItem() == itemStack || liver.getOffhandItem() == itemStack) {
                this.onHeld(liver);
            }
            if (this.enableSlimeChunkExcitement) {
                this.checkSlimeChunk(itemStack, entity);
            }
        }
    }

    public void onHeld(LivingEntity entity) {
        if (this.heldParticle == null) {
            this.heldParticle = (ParticleOptions)SlimeBucketsParticles.FALLING_SLIME.get();
        }
        if (entity.level().isClientSide && SlimeBuckets.CLIENT_CONFIG.enableTrails && entity.level().getGameTime() % 3L == 0L) {
            entity.level().addParticle(this.heldParticle, entity.position().x, entity.position().y + 1.0, entity.position().z, 0.0, 0.0, 0.0);
        }
    }

    protected void checkSlimeChunk(ItemStack itemStack, Entity entity) {
        boolean currentIsInSlimeChunk = Boolean.TRUE.equals(itemStack.get((DataComponentType)SlimeBucketsItemComponents.HOLDER_IN_SLIME_CHUNK.get()));
        if (this.enableSlimeChunkExcitement && entity instanceof ServerPlayer) {
            boolean inSlimeChunk;
            ServerPlayer player = (ServerPlayer)entity;
            if (!SlimeBuckets.SERVER_CONFIG.enableSlimeChunkDetection) {
                if (currentIsInSlimeChunk) {
                    itemStack.set((DataComponentType)SlimeBucketsItemComponents.HOLDER_IN_SLIME_CHUNK.get(), (Object)false);
                }
                return;
            }
            ChunkPos chunkPos = player.chunkPosition();
            RandomSource slimeChunk = WorldgenRandom.seedSlimeChunk((int)chunkPos.x, (int)chunkPos.z, (long)player.serverLevel().getSeed(), (long)987234911L);
            boolean bl = inSlimeChunk = slimeChunk.nextInt(10) == 0;
            if (currentIsInSlimeChunk != inSlimeChunk) {
                itemStack.set((DataComponentType)SlimeBucketsItemComponents.HOLDER_IN_SLIME_CHUNK.get(), (Object)inSlimeChunk);
            }
        }
    }
}

